/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestFileSystemTokens {
    private static String renewer = "renewer!";

    @Test
    public void testFsWithNoToken() throws Exception {
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        Credentials credentials = new Credentials();
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, false);
        Assert.assertEquals((long)0L, (long)credentials.numberOfTokens());
    }

    @Test
    public void testFsWithToken() throws Exception {
        Text service = new Text("singleTokenFs");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        Credentials credentials = new Credentials();
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, true);
        Assert.assertEquals((long)1L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(service));
    }

    @Test
    public void testFsWithTokenExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service, token);
        fs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(fs, false);
        Assert.assertEquals((long)1L, (long)credentials.numberOfTokens());
        Assert.assertSame((Object)token, credentials.getToken(service));
    }

    @Test
    public void testFsWithChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, fs1, fs2, fs3);
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, true);
        this.verifyTokenFetch(fs3, false);
        Assert.assertEquals((long)2L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(service1));
        Assert.assertNotNull(credentials.getToken(service2));
    }

    @Test
    public void testFsWithDuplicateChildren() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs1");
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, fs, new FilterFileSystem(fs));
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs, true);
        Assert.assertEquals((long)1L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(service));
    }

    @Test
    public void testFsWithDuplicateChildrenTokenExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service = new Text("singleTokenFs1");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service, token);
        FileSystemTestHelper.MockFileSystem fs = TestFileSystemTokens.createFileSystemForServiceName(service, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, fs, new FilterFileSystem(fs));
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs, false);
        Assert.assertEquals((long)1L, (long)credentials.numberOfTokens());
        Assert.assertSame((Object)token, credentials.getToken(service));
    }

    @Test
    public void testFsWithChildTokensOneExists() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(null, fs1, fs2, fs3);
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        this.verifyTokenFetch(fs3, false);
        Assert.assertEquals((long)2L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(service1));
        Assert.assertSame((Object)token, credentials.getToken(service2));
    }

    @Test
    public void testFsWithMyOwnAndChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text myService = new Text("multiTokenFs");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(myService, fs1, fs2);
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, true);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        Assert.assertEquals((long)3L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(myService));
        Assert.assertNotNull(credentials.getToken(service1));
        Assert.assertNotNull(credentials.getToken(service2));
    }

    @Test
    public void testFsWithMyOwnExistsAndChildTokens() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text myService = new Text("multiTokenFs");
        Token token = (Token)Mockito.mock(Token.class);
        credentials.addToken(myService, token);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(myService, fs1, fs2);
        multiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(multiFs, false);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, true);
        Assert.assertEquals((long)3L, (long)credentials.numberOfTokens());
        Assert.assertSame((Object)token, credentials.getToken(myService));
        Assert.assertNotNull(credentials.getToken(service1));
        Assert.assertNotNull(credentials.getToken(service2));
    }

    @Test
    public void testFsWithNestedDuplicatesChildren() throws Exception {
        Credentials credentials = new Credentials();
        Text service1 = new Text("singleTokenFs1");
        Text service2 = new Text("singleTokenFs2");
        Text service4 = new Text("singleTokenFs4");
        Text multiService = new Text("multiTokenFs");
        Token token2 = (Token)Mockito.mock(Token.class);
        credentials.addToken(service2, token2);
        FileSystemTestHelper.MockFileSystem fs1 = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs1B = TestFileSystemTokens.createFileSystemForServiceName(service1, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs2 = TestFileSystemTokens.createFileSystemForServiceName(service2, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs3 = TestFileSystemTokens.createFileSystemForServiceName(null, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem fs4 = TestFileSystemTokens.createFileSystemForServiceName(service4, new FileSystem[0]);
        FileSystemTestHelper.MockFileSystem multiFs = TestFileSystemTokens.createFileSystemForServiceName(multiService, fs1, fs1B, fs2, fs2, new FilterFileSystem(fs3), new FilterFileSystem(new FilterFileSystem(fs4)));
        FileSystemTestHelper.MockFileSystem superMultiFs = TestFileSystemTokens.createFileSystemForServiceName(null, fs1, fs1B, fs1, new FilterFileSystem(fs3), new FilterFileSystem(multiFs));
        superMultiFs.addDelegationTokens(renewer, credentials);
        this.verifyTokenFetch(superMultiFs, false);
        this.verifyTokenFetch(multiFs, true);
        this.verifyTokenFetch(fs1, true);
        this.verifyTokenFetch(fs2, false);
        this.verifyTokenFetch(fs3, false);
        this.verifyTokenFetch(fs4, true);
        Assert.assertEquals((long)4L, (long)credentials.numberOfTokens());
        Assert.assertNotNull(credentials.getToken(service1));
        Assert.assertNotNull(credentials.getToken(service2));
        Assert.assertSame((Object)token2, credentials.getToken(service2));
        Assert.assertNotNull(credentials.getToken(multiService));
        Assert.assertNotNull(credentials.getToken(service4));
    }

    public static FileSystemTestHelper.MockFileSystem createFileSystemForServiceName(final Text service, FileSystem ... children) throws IOException {
        FileSystemTestHelper.MockFileSystem fs = new FileSystemTestHelper.MockFileSystem();
        FileSystemTestHelper.MockFileSystem mockFs = fs.getRawFileSystem();
        if (service != null) {
            Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)service.toString());
            Mockito.when(mockFs.getDelegationToken((String)Mockito.any(String.class))).thenAnswer(new Answer<Token<?>>(){

                public Token<?> answer(InvocationOnMock invocation) throws Throwable {
                    Token token = new Token();
                    token.setService(service);
                    return token;
                }
            });
        }
        Mockito.when((Object)mockFs.getChildFileSystems()).thenReturn((Object)children);
        return fs;
    }

    private void verifyTokenFetch(FileSystemTestHelper.MockFileSystem fs, boolean expected) throws IOException {
        ((FileSystemTestHelper.MockFileSystem)Mockito.verify((Object)fs.getRawFileSystem(), (VerificationMode)Mockito.atLeast((int)1))).getCanonicalServiceName();
        if (expected) {
            ((FileSystemTestHelper.MockFileSystem)Mockito.verify((Object)fs.getRawFileSystem())).getDelegationToken(renewer);
        } else {
            ((FileSystemTestHelper.MockFileSystem)Mockito.verify((Object)fs.getRawFileSystem(), (VerificationMode)Mockito.never())).getDelegationToken((String)Mockito.any(String.class));
        }
        ((FileSystemTestHelper.MockFileSystem)Mockito.verify((Object)fs.getRawFileSystem(), (VerificationMode)Mockito.atLeast((int)1))).getChildFileSystems();
    }
}

