/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.fs.Options;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Test;

public class TestFsOptions {
    @Test
    public void testProcessChecksumOpt() {
        Options.ChecksumOpt defaultOpt = new Options.ChecksumOpt(DataChecksum.Type.CRC32, 512);
        Options.ChecksumOpt finalOpt = Options.ChecksumOpt.processChecksumOpt(defaultOpt, null);
        this.checkParams(defaultOpt, finalOpt);
        finalOpt = Options.ChecksumOpt.processChecksumOpt(defaultOpt, null, 1024);
        this.checkParams(DataChecksum.Type.CRC32, 1024, finalOpt);
        Options.ChecksumOpt myOpt = new Options.ChecksumOpt();
        finalOpt = Options.ChecksumOpt.processChecksumOpt(defaultOpt, myOpt);
        this.checkParams(defaultOpt, finalOpt);
        myOpt = new Options.ChecksumOpt(DataChecksum.Type.CRC32C, 2048);
        finalOpt = Options.ChecksumOpt.processChecksumOpt(defaultOpt, myOpt);
        this.checkParams(DataChecksum.Type.CRC32C, 2048, finalOpt);
        finalOpt = Options.ChecksumOpt.processChecksumOpt(defaultOpt, myOpt, 4096);
        this.checkParams(DataChecksum.Type.CRC32C, 4096, finalOpt);
    }

    private void checkParams(Options.ChecksumOpt expected, Options.ChecksumOpt obtained) {
        Assert.assertEquals((Object)((Object)expected.getChecksumType()), (Object)((Object)obtained.getChecksumType()));
        Assert.assertEquals((long)expected.getBytesPerChecksum(), (long)obtained.getBytesPerChecksum());
    }

    private void checkParams(DataChecksum.Type type, int bpc, Options.ChecksumOpt obtained) {
        Assert.assertEquals((Object)((Object)type), (Object)((Object)obtained.getChecksumType()));
        Assert.assertEquals((long)bpc, (long)obtained.getBytesPerChecksum());
    }
}

