/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestSymlinkHdfsDisable {
    @Test(timeout=60000L)
    public void testSymlinkHdfsDisable() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("fs.client.resolve.remote.symlinks", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        FileContext fc = FileContext.getFileContext(cluster.getURI(0), (Configuration)conf);
        FileContextTestHelper helper = new FileContextTestHelper("/tmp/TestSymlinkHdfsDisable");
        Path root = helper.getTestRootPath(fc);
        Path target = new Path(root, "target");
        Path link = new Path(root, "link");
        DFSTestUtil.createFile(dfs, target, 4096L, (short)1, -559030611L);
        fc.createSymlink(target, link, false);
        try {
            fc.open(link);
            Assert.fail((String)"Expected error when attempting to resolve link");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("resolution is disabled", e);
        }
        try {
            dfs.open(link);
            Assert.fail((String)"Expected error when attempting to resolve link");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("resolution is disabled", e);
        }
    }
}

