/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestUrlStreamHandler {
    private static final File TEST_ROOT_DIR = PathUtils.getTestDir(TestUrlStreamHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDfsUrls() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        FsUrlStreamHandlerFactory factory = new FsUrlStreamHandlerFactory();
        URL.setURLStreamHandlerFactory(factory);
        Path filePath = new Path("/thefile");
        try {
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(filePath);
            ((OutputStream)os).write(fileContent);
            ((OutputStream)os).close();
            URI uri = ((FileSystem)fs).getUri();
            URL fileURL = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), filePath.toString());
            InputStream is = fileURL.openStream();
            Assert.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            Assert.assertEquals((long)1024L, (long)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                Assert.assertEquals((long)fileContent[i], (long)bytes[i]);
            }
            ((FileSystem)fs).delete(filePath, false);
        }
        finally {
            ((FileSystem)fs).close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileUrls() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (!TEST_ROOT_DIR.exists() && !TEST_ROOT_DIR.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + TEST_ROOT_DIR);
        }
        File tmpFile = new File(TEST_ROOT_DIR, "thefile");
        URI uri = tmpFile.toURI();
        FileSystem fs = FileSystem.get(uri, conf);
        try {
            byte[] fileContent = new byte[1024];
            for (int i = 0; i < fileContent.length; ++i) {
                fileContent[i] = (byte)i;
            }
            FSDataOutputStream os = fs.create(new Path(uri.getPath()));
            ((OutputStream)os).write(fileContent);
            ((OutputStream)os).close();
            URL fileURL = uri.toURL();
            InputStream is = fileURL.openStream();
            Assert.assertNotNull((Object)is);
            byte[] bytes = new byte[4096];
            Assert.assertEquals((long)1024L, (long)is.read(bytes));
            is.close();
            for (int i = 0; i < fileContent.length; ++i) {
                Assert.assertEquals((long)fileContent[i], (long)bytes[i]);
            }
            fs.delete(new Path(uri.getPath()), false);
        }
        finally {
            fs.close();
        }
    }
}

