/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.util.ToolRunner;

public class StructureGenerator {
    private int maxDepth = 5;
    private int minWidth = 1;
    private int maxWidth = 5;
    private int numOfFiles = 10;
    private double avgFileSize = 1.0;
    private File outDir = DEFAULT_STRUCTURE_DIRECTORY;
    private static final String USAGE = "java StructureGenerator\n-maxDepth <maxDepth>\n-minWidth <minWidth>\n-maxWidth <maxWidth>\n-numOfFiles <#OfFiles>\n-avgFileSize <avgFileSizeInBlocks>\n-outDir <outDir>\n-seed <seed>";
    private Random r = null;
    static final File DEFAULT_STRUCTURE_DIRECTORY = new File(".");
    static final String DIR_STRUCTURE_FILE_NAME = "dirStructure";
    static final String FILE_STRUCTURE_FILE_NAME = "fileStructure";
    static final String FILE_NAME_PREFIX = "_file_";
    private INode root;

    public int run(String[] args) throws Exception {
        int exitCode = 0;
        exitCode = this.init(args);
        if (exitCode != 0) {
            return exitCode;
        }
        this.genDirStructure();
        this.output(new File(this.outDir, DIR_STRUCTURE_FILE_NAME));
        this.genFileStructure();
        this.outputFiles(new File(this.outDir, FILE_STRUCTURE_FILE_NAME));
        return exitCode;
    }

    private int init(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-maxDepth")) {
                    this.maxDepth = Integer.parseInt(args[++i]);
                    if (this.maxDepth >= 1) continue;
                    System.err.println("maxDepth must be positive: " + this.maxDepth);
                    return -1;
                }
                if (args[i].equals("-minWidth")) {
                    this.minWidth = Integer.parseInt(args[++i]);
                    if (this.minWidth >= 0) continue;
                    System.err.println("minWidth must be positive: " + this.minWidth);
                    return -1;
                }
                if (args[i].equals("-maxWidth")) {
                    this.maxWidth = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-numOfFiles")) {
                    this.numOfFiles = Integer.parseInt(args[++i]);
                    if (this.numOfFiles >= 1) continue;
                    System.err.println("NumOfFiles must be positive: " + this.numOfFiles);
                    return -1;
                }
                if (args[i].equals("-avgFileSize")) {
                    this.avgFileSize = Double.parseDouble(args[++i]);
                    if (!(this.avgFileSize <= 0.0)) continue;
                    System.err.println("AvgFileSize must be positive: " + this.avgFileSize);
                    return -1;
                }
                if (args[i].equals("-outDir")) {
                    this.outDir = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    this.r = new Random(Long.parseLong(args[++i]));
                    continue;
                }
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage(System.err);
                return -1;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        if (this.maxWidth < this.minWidth) {
            System.err.println("maxWidth must be bigger than minWidth: " + this.maxWidth);
            return -1;
        }
        if (this.r == null) {
            this.r = new Random();
        }
        return 0;
    }

    private void genDirStructure() {
        this.root = this.genDirStructure("", this.maxDepth);
    }

    private INode genDirStructure(String rootName, int maxDepth) {
        INode root = new INode(rootName);
        if (maxDepth > 0) {
            int minDepth = --maxDepth * 2 / 3;
            int numOfSubDirs = this.minWidth + this.r.nextInt(this.maxWidth - this.minWidth + 1);
            for (int i = 0; i < numOfSubDirs; ++i) {
                int childDepth = maxDepth == 0 ? 0 : this.r.nextInt(maxDepth - minDepth + 1) + minDepth;
                INode child = this.genDirStructure("dir" + i, childDepth);
                root.addChild(child);
            }
        }
        return root;
    }

    private List<INode> getLeaves() {
        ArrayList<INode> leaveDirs = new ArrayList<INode>();
        this.root.getLeaves(leaveDirs);
        return leaveDirs;
    }

    private void genFileStructure() {
        List<INode> leaves = this.getLeaves();
        int totalLeaves = leaves.size();
        for (int i = 0; i < this.numOfFiles; ++i) {
            double fileSize;
            int leaveNum = this.r.nextInt(totalLeaves);
            while ((fileSize = this.r.nextGaussian() + this.avgFileSize) < 0.0) {
            }
            leaves.get(leaveNum).addChild((INode)new FileINode(FILE_NAME_PREFIX + i, fileSize));
        }
    }

    private void output(File outFile) throws FileNotFoundException {
        System.out.println("Printing to " + outFile.toString());
        PrintStream out = new PrintStream(outFile);
        this.root.output(out, null);
        out.close();
    }

    private void outputFiles(File outFile) throws FileNotFoundException {
        System.out.println("Printing to " + outFile.toString());
        PrintStream out = new PrintStream(outFile);
        this.root.outputFiles(out, null);
        out.close();
    }

    public static void main(String[] args) throws Exception {
        StructureGenerator sg = new StructureGenerator();
        System.exit(sg.run(args));
    }

    private static class FileINode
    extends INode {
        private double numOfBlocks;

        private FileINode(String name, double numOfBlocks) {
            super(name);
            this.numOfBlocks = numOfBlocks;
        }

        @Override
        protected void outputFiles(PrintStream out, String prefix) {
            prefix = prefix == null ? ((INode)this).name : prefix + "/" + ((INode)this).name;
            out.println(prefix + " " + this.numOfBlocks);
        }
    }

    private static class INode {
        private String name;
        private List<INode> children = new ArrayList<INode>();

        private INode(String name) {
            this.name = name;
        }

        private void addChild(INode child) {
            this.children.add(child);
        }

        private void output(PrintStream out, String prefix) {
            String string = prefix = prefix == null ? this.name : prefix + "/" + this.name;
            if (this.children.isEmpty()) {
                out.println(prefix);
            } else {
                for (INode child : this.children) {
                    child.output(out, prefix);
                }
            }
        }

        protected void outputFiles(PrintStream out, String prefix) {
            prefix = prefix == null ? this.name : prefix + "/" + this.name;
            for (INode child : this.children) {
                child.outputFiles(out, prefix);
            }
        }

        private void getLeaves(List<INode> leaves) {
            if (this.children.isEmpty()) {
                leaves.add(this);
            } else {
                for (INode child : this.children) {
                    child.getLeaves(leaves);
                }
            }
        }
    }
}

