/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.INode;

class InMemoryFileSystemStore
implements FileSystemStore {
    private Configuration conf;
    private SortedMap<Path, INode> inodes = new TreeMap<Path, INode>();
    private Map<Long, byte[]> blocks = new HashMap<Long, byte[]>();

    InMemoryFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) {
        this.conf = conf;
    }

    @Override
    public String getVersion() throws IOException {
        return "0";
    }

    @Override
    public void deleteINode(Path path) throws IOException {
        this.inodes.remove(this.normalize(path));
    }

    @Override
    public void deleteBlock(Block block) throws IOException {
        this.blocks.remove(block.getId());
    }

    @Override
    public boolean inodeExists(Path path) throws IOException {
        return this.inodes.containsKey(this.normalize(path));
    }

    @Override
    public boolean blockExists(long blockId) throws IOException {
        return this.blocks.containsKey(blockId);
    }

    @Override
    public INode retrieveINode(Path path) throws IOException {
        return (INode)this.inodes.get(this.normalize(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File retrieveBlock(Block block, long byteRangeStart) throws IOException {
        byte[] data = this.blocks.get(block.getId());
        File file = this.createTempFile();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            ((BufferedOutputStream)out).write(data, (int)byteRangeStart, data.length - (int)byteRangeStart);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return file;
    }

    private File createTempFile() throws IOException {
        File dir = new File(this.conf.get("fs.s3.buffer.dir"));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create S3 buffer directory: " + dir);
        }
        File result = File.createTempFile("test-", ".tmp", dir);
        result.deleteOnExit();
        return result;
    }

    @Override
    public Set<Path> listSubPaths(Path path) throws IOException {
        Path normalizedPath = this.normalize(path);
        LinkedHashSet<Path> subPaths = new LinkedHashSet<Path>();
        for (Path p : this.inodes.tailMap(normalizedPath).keySet()) {
            if (!normalizedPath.equals(p.getParent())) continue;
            subPaths.add(p);
        }
        return subPaths;
    }

    @Override
    public Set<Path> listDeepSubPaths(Path path) throws IOException {
        Path normalizedPath = this.normalize(path);
        String pathString = normalizedPath.toUri().getPath();
        if (!pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        LinkedHashSet<Path> subPaths = new LinkedHashSet<Path>();
        for (Path p : this.inodes.tailMap(normalizedPath).keySet()) {
            if (!p.toUri().getPath().startsWith(pathString)) continue;
            subPaths.add(p);
        }
        return subPaths;
    }

    @Override
    public void storeINode(Path path, INode inode) throws IOException {
        this.inodes.put(this.normalize(path), inode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBlock(Block block, File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        BufferedInputStream in = null;
        try {
            int numRead;
            in = new BufferedInputStream(new FileInputStream(file));
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.blocks.put(block.getId(), out.toByteArray());
    }

    private Path normalize(Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        return new Path(path.toUri().getPath());
    }

    @Override
    public void purge() throws IOException {
        this.inodes.clear();
        this.blocks.clear();
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(", \n");
        for (Map.Entry<Path, INode> entry : this.inodes.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            INode inode = entry.getValue();
            sb.append("\t").append((Object)inode.getFileType()).append("\n");
            if (inode.getFileType() == INode.FileType.DIRECTORY) continue;
            for (int j = 0; j < inode.getBlocks().length; ++j) {
                sb.append("\t").append(inode.getBlocks()[j]).append("\n");
            }
        }
        System.out.println(sb);
        System.out.println(this.inodes.keySet());
        System.out.println(this.blocks.keySet());
    }
}

