/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.Jets3tNativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;

public abstract class NativeS3FileSystemContractBaseTest
extends FileSystemContractBaseTest {
    private NativeFileSystemStore store;

    abstract NativeFileSystemStore getNativeFileSystemStore() throws IOException;

    protected void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.store = this.getNativeFileSystemStore();
        this.fs = new NativeS3FileSystem(this.store);
        this.fs.initialize(URI.create(conf.get("test.fs.s3n.name")), conf);
    }

    @Override
    protected void tearDown() throws Exception {
        this.store.purge("test");
        super.tearDown();
    }

    public void testCanonicalName() throws Exception {
        NativeS3FileSystemContractBaseTest.assertNull((String)"s3n doesn't support security token and shouldn't have canonical name", (Object)this.fs.getCanonicalServiceName());
    }

    public void testListStatusForRoot() throws Exception {
        FileStatus[] paths = this.fs.listStatus(this.path("/"));
        NativeS3FileSystemContractBaseTest.assertEquals((int)0, (int)paths.length);
        Path testDir = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.mkdirs(testDir));
        paths = this.fs.listStatus(this.path("/"));
        NativeS3FileSystemContractBaseTest.assertEquals((int)1, (int)paths.length);
        NativeS3FileSystemContractBaseTest.assertEquals((Object)this.path("/test"), (Object)paths[0].getPath());
    }

    public void testNoTrailingBackslashOnBucket() throws Exception {
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(new Path(this.fs.getUri().toString())).isDirectory());
    }

    private void createTestFiles(String base) throws IOException {
        this.store.storeEmptyFile(base + "/file1");
        this.store.storeEmptyFile(base + "/dir/file2");
        this.store.storeEmptyFile(base + "/dir/file3");
    }

    public void testDirWithDifferentMarkersWorks() throws Exception {
        for (int i = 0; i < 3; ++i) {
            String base = "test/hadoop" + i;
            Path path = this.path("/" + base);
            this.createTestFiles(base);
            if (i != 0) {
                if (i == 1) {
                    this.store.storeEmptyFile(base + "_$folder$");
                    this.store.storeEmptyFile(base + "/dir_$folder$");
                } else if (i == 2) {
                    this.store.storeEmptyFile(base + "/");
                    this.store.storeEmptyFile(base + "/dir/");
                } else if (i == 3) {
                    this.store.storeEmptyFile(base + "_$folder$");
                    this.store.storeEmptyFile(base + "/dir_$folder$");
                    this.store.storeEmptyFile(base + "/");
                    this.store.storeEmptyFile(base + "/dir/");
                }
            }
            NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(path).isDirectory());
            NativeS3FileSystemContractBaseTest.assertEquals((int)2, (int)this.fs.listStatus(path).length);
        }
    }

    public void testDeleteWithNoMarker() throws Exception {
        String base = "test/hadoop";
        Path path = this.path("/" + base);
        this.createTestFiles(base);
        this.fs.delete(path, true);
        path = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(path).isDirectory());
        NativeS3FileSystemContractBaseTest.assertEquals((int)0, (int)this.fs.listStatus(path).length);
    }

    public void testRenameWithNoMarker() throws Exception {
        String base = "test/hadoop";
        Path dest = this.path("/test/hadoop2");
        this.createTestFiles(base);
        this.fs.rename(this.path("/" + base), dest);
        Path path = this.path("/test");
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(path).isDirectory());
        NativeS3FileSystemContractBaseTest.assertEquals((int)1, (int)this.fs.listStatus(path).length);
        NativeS3FileSystemContractBaseTest.assertTrue((boolean)this.fs.getFileStatus(dest).isDirectory());
        NativeS3FileSystemContractBaseTest.assertEquals((int)2, (int)this.fs.listStatus(dest).length);
    }

    public void testEmptyFile() throws Exception {
        this.store.storeEmptyFile("test/hadoop/file1");
        this.fs.open(this.path("/test/hadoop/file1")).close();
    }

    public void testBlockSize() throws Exception {
        Path file = this.path("/test/hadoop/file");
        this.createFile(file);
        NativeS3FileSystemContractBaseTest.assertEquals((String)"Default block size", (long)this.fs.getDefaultBlockSize(file), (long)this.fs.getFileStatus(file).getBlockSize());
        long newBlockSize = this.fs.getDefaultBlockSize(file) * 2L;
        this.fs.getConf().setLong("fs.s3n.block.size", newBlockSize);
        NativeS3FileSystemContractBaseTest.assertEquals((String)"Double default block size", (long)newBlockSize, (long)this.fs.getFileStatus(file).getBlockSize());
    }

    public void testRetryOnIoException() throws Exception {
        int i;
        class TestInputStream
        extends InputStream {
            boolean shouldThrow = false;
            int throwCount = 0;
            int pos = 0;
            byte[] bytes = new byte[256];

            public TestInputStream() {
                for (int i = 0; i < 256; ++i) {
                    this.bytes[i] = (byte)i;
                }
            }

            @Override
            public int read() throws IOException {
                boolean bl = this.shouldThrow = !this.shouldThrow;
                if (this.shouldThrow) {
                    ++this.throwCount;
                    throw new IOException();
                }
                return this.pos++;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                boolean bl = this.shouldThrow = !this.shouldThrow;
                if (this.shouldThrow) {
                    ++this.throwCount;
                    throw new IOException();
                }
                int sizeToRead = Math.min(len, 256 - this.pos);
                for (int i = 0; i < sizeToRead; ++i) {
                    b[i] = this.bytes[this.pos + i];
                }
                this.pos += sizeToRead;
                return sizeToRead;
            }
        }
        final TestInputStream is = new TestInputStream();
        class MockNativeFileSystemStore
        extends Jets3tNativeFileSystemStore {
            MockNativeFileSystemStore() {
            }

            @Override
            public InputStream retrieve(String key, long byteRangeStart) throws IOException {
                return is;
            }
        }
        NativeS3FileSystem.NativeS3FsInputStream stream = new NativeS3FileSystem.NativeS3FsInputStream(new MockNativeFileSystemStore(), null, is, "");
        byte[] result = new byte[256];
        for (i = 0; i < 128; ++i) {
            result[i] = (byte)stream.read();
        }
        for (i = 128; i < 256; i += 8) {
            byte[] temp = new byte[8];
            int read = stream.read(temp, 0, 8);
            NativeS3FileSystemContractBaseTest.assertEquals((int)8, (int)read);
            System.arraycopy(temp, 0, result, i, 8);
        }
        for (i = 0; i < 256; ++i) {
            NativeS3FileSystemContractBaseTest.assertEquals((byte)((byte)i), (byte)result[i]);
        }
        NativeS3FileSystemContractBaseTest.assertEquals((int)144, (int)is.throwCount);
    }
}

