/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommandFactory {
    static CommandFactory factory;
    static Configuration conf;

    static void registerCommands(CommandFactory factory) {
    }

    @Before
    public void testSetup() {
        factory = new CommandFactory(conf);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testRegistration() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])factory.getNames());
        factory.registerCommands(TestRegistrar.class);
        Object[] names = factory.getNames();
        Assert.assertArrayEquals((Object[])new String[]{"tc1", "tc2", "tc2.1"}, (Object[])names);
        factory.addClass(TestCommand3.class, "tc3");
        names = factory.getNames();
        Assert.assertArrayEquals((Object[])new String[]{"tc1", "tc2", "tc2.1", "tc3"}, (Object[])names);
    }

    @Test
    public void testGetInstances() {
        factory.registerCommands(TestRegistrar.class);
        Command instance = factory.getInstance("blarg");
        Assert.assertNull((Object)instance);
        instance = factory.getInstance("tc1");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand1.class, instance.getClass());
        Assert.assertEquals((Object)"tc1", (Object)instance.getCommandName());
        instance = factory.getInstance("tc2");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand2.class, instance.getClass());
        Assert.assertEquals((Object)"tc2", (Object)instance.getCommandName());
        instance = factory.getInstance("tc2.1");
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(TestCommand2.class, instance.getClass());
        Assert.assertEquals((Object)"tc2.1", (Object)instance.getCommandName());
    }

    static {
        conf = new Configuration();
    }

    static class TestCommand3
    extends FsCommand {
        TestCommand3() {
        }
    }

    static class TestCommand2
    extends FsCommand {
        TestCommand2() {
        }
    }

    static class TestCommand1
    extends FsCommand {
        TestCommand1() {
        }
    }

    static class TestRegistrar {
        TestRegistrar() {
        }

        public static void registerCommands(CommandFactory factory) {
            factory.addClass(TestCommand1.class, "tc1");
            factory.addClass(TestCommand2.class, "tc2", "tc2.1");
        }
    }
}

