/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.FailoverController;
import org.apache.hadoop.ha.FailoverFailedException;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.ha.TestNodeFencer;
import org.apache.hadoop.security.AccessControlException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;

public class TestFailoverController {
    private InetSocketAddress svc1Addr = new InetSocketAddress("svc1", 1234);
    private InetSocketAddress svc2Addr = new InetSocketAddress("svc2", 5678);
    private Configuration conf = new Configuration();
    HAServiceStatus STATE_NOT_READY = new HAServiceStatus(HAServiceProtocol.HAServiceState.STANDBY).setNotReadyToBecomeActive("injected not ready");

    @Test
    public void testFailoverAndFailback() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        TestNodeFencer.AlwaysSucceedFencer.fenceCalled = 0;
        this.doFailover(svc1, svc2, false, false);
        Assert.assertEquals((long)0L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
        TestNodeFencer.AlwaysSucceedFencer.fenceCalled = 0;
        this.doFailover(svc2, svc1, false, false);
        Assert.assertEquals((long)0L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverFromStandbyToStandby() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        this.doFailover(svc1, svc2, false, false);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverFromActiveToActive() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Can't failover to an already active service");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverWithoutPermission() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new AccessControlException("Access denied")).when((Object)svc1.proxy)).getServiceStatus();
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new AccessControlException("Access denied")).when((Object)svc2.proxy)).getServiceStatus();
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Can't failover when access is denied");
        }
        catch (FailoverFailedException ffe) {
            Assert.assertTrue((boolean)ffe.getCause().getMessage().contains("Access denied"));
        }
    }

    @Test
    public void testFailoverToUnreadyService() throws Exception {
        DummyHAService svc2;
        DummyHAService svc1;
        block2: {
            svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
            svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
            ((HAServiceProtocol)Mockito.doReturn((Object)this.STATE_NOT_READY).when((Object)svc2.proxy)).getServiceStatus();
            svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
            try {
                this.doFailover(svc1, svc2, false, false);
                Assert.fail((String)"Can't failover to a service that's not ready");
            }
            catch (FailoverFailedException ffe) {
                if (ffe.getMessage().contains("injected not ready")) break block2;
                throw ffe;
            }
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
        this.doFailover(svc1, svc2, false, true);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverToUnhealthyServiceFailsAndFailsback() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new HealthCheckFailedException("Failed!")).when((Object)svc2.proxy)).monitorHealth();
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failover to unhealthy service");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverFromFaultyServiceSucceeds() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc1.proxy)).transitionToStandby(this.anyReqInfo());
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        TestNodeFencer.AlwaysSucceedFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc2, false, false);
        }
        catch (FailoverFailedException ffe) {
            Assert.fail((String)"Faulty active prevented failover");
        }
        Assert.assertEquals((long)1L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertSame((Object)svc1, (Object)TestNodeFencer.AlwaysSucceedFencer.fencedSvc);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverFromFaultyServiceFencingFailure() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc1.proxy)).transitionToStandby(this.anyReqInfo());
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysFailFencer.class.getName());
        TestNodeFencer.AlwaysFailFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failed over even though fencing failed");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)TestNodeFencer.AlwaysFailFencer.fenceCalled);
        Assert.assertSame((Object)svc1, (Object)TestNodeFencer.AlwaysFailFencer.fencedSvc);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testFencingFailureDuringFailover() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysFailFencer.class.getName());
        TestNodeFencer.AlwaysFailFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc2, true, false);
            Assert.fail((String)"Failed over even though fencing requested and failed");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)TestNodeFencer.AlwaysFailFencer.fenceCalled);
        Assert.assertSame((Object)svc1, (Object)TestNodeFencer.AlwaysFailFencer.fencedSvc);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverFromNonExistantServiceWithFencer() throws Exception {
        DummyHAService svc1 = (DummyHAService)Mockito.spy((Object)new DummyHAService(null, this.svc1Addr));
        HAServiceProtocol errorThrowingProxy = (HAServiceProtocol)Mockito.mock(HAServiceProtocol.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)new ThrowsException((Throwable)new IOException("Could not connect to host"))).extraInterfaces(new Class[]{Closeable.class}));
        ((Closeable)Mockito.doNothing().when((Object)((Closeable)((Object)errorThrowingProxy)))).close();
        ((DummyHAService)Mockito.doReturn((Object)errorThrowingProxy).when((Object)svc1)).getProxy((Configuration)Mockito.any(), Mockito.anyInt());
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
        }
        catch (FailoverFailedException ffe) {
            Assert.fail((String)"Non-existant active prevented failover");
        }
        ((DummyHAService)Mockito.verify((Object)svc1)).getProxy((Configuration)Mockito.any(), Mockito.eq((int)5000));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc2.state));
    }

    @Test
    public void testFailoverToNonExistantServiceFails() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = (DummyHAService)Mockito.spy((Object)new DummyHAService(null, this.svc2Addr));
        ((DummyHAService)Mockito.doThrow((Throwable)new IOException("Failed to connect")).when((Object)svc2)).getProxy((Configuration)Mockito.any(), Mockito.anyInt());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failed over to a non-existant standby");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
    }

    @Test
    public void testFailoverToFaultyServiceFailsbackOK() throws Exception {
        DummyHAService svc1 = (DummyHAService)Mockito.spy((Object)new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr));
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc2.proxy)).transitionToActive(this.anyReqInfo());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failover to already active service");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        ((HAServiceProtocol)Mockito.verify((Object)svc1.proxy)).transitionToStandby(this.anyReqInfo());
        ((HAServiceProtocol)Mockito.verify((Object)svc1.proxy)).transitionToActive(this.anyReqInfo());
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testWeDontFailbackIfActiveWasFenced() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc2.proxy)).transitionToActive(this.anyReqInfo());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, true, false);
            Assert.fail((String)"Failed over to service that won't transition to active");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testWeFenceOnFailbackIfTransitionToActiveFails() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc2.proxy)).transitionToActive(this.anyReqInfo());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        TestNodeFencer.AlwaysSucceedFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failed over to service that won't transition to active");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        Assert.assertEquals((long)1L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertSame((Object)svc2, (Object)TestNodeFencer.AlwaysSucceedFencer.fencedSvc);
    }

    private HAServiceProtocol.StateChangeRequestInfo anyReqInfo() {
        return (HAServiceProtocol.StateChangeRequestInfo)Mockito.any();
    }

    @Test
    public void testFailureToFenceOnFailbackFailsTheFailback() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new IOException("Failed!")).when((Object)svc2.proxy)).transitionToActive(this.anyReqInfo());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysFailFencer.class.getName());
        TestNodeFencer.AlwaysFailFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failed over to service that won't transition to active");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((long)1L, (long)TestNodeFencer.AlwaysFailFencer.fenceCalled);
        Assert.assertSame((Object)svc2, (Object)TestNodeFencer.AlwaysFailFencer.fencedSvc);
    }

    @Test
    public void testFailbackToFaultyServiceFails() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc1.proxy)).transitionToActive(this.anyReqInfo());
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        ((HAServiceProtocol)Mockito.doThrow((Throwable)new ServiceFailedException("Failed!")).when((Object)svc2.proxy)).transitionToActive(this.anyReqInfo());
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        try {
            this.doFailover(svc1, svc2, false, false);
            Assert.fail((String)"Failover to already active service");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc1.state));
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    @Test
    public void testSelfFailoverFails() throws Exception {
        DummyHAService svc1 = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, this.svc1Addr);
        DummyHAService svc2 = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, this.svc2Addr);
        svc1.fencer = svc2.fencer = TestNodeFencer.setupFencer(TestNodeFencer.AlwaysSucceedFencer.class.getName());
        TestNodeFencer.AlwaysSucceedFencer.fenceCalled = 0;
        try {
            this.doFailover(svc1, svc1, false, false);
            Assert.fail((String)"Can't failover to yourself");
        }
        catch (FailoverFailedException ffe) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.ACTIVE), (Object)((Object)svc1.state));
        try {
            this.doFailover(svc2, svc2, false, false);
            Assert.fail((String)"Can't failover to yourself");
        }
        catch (FailoverFailedException failoverFailedException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)TestNodeFencer.AlwaysSucceedFencer.fenceCalled);
        Assert.assertEquals((Object)((Object)HAServiceProtocol.HAServiceState.STANDBY), (Object)((Object)svc2.state));
    }

    private void doFailover(HAServiceTarget tgt1, HAServiceTarget tgt2, boolean forceFence, boolean forceActive) throws FailoverFailedException {
        FailoverController fc = new FailoverController(this.conf, HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        fc.failover(tgt1, tgt2, forceFence, forceActive);
    }
}

