/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class BenchmarkThroughput
extends Configured
implements Tool {
    private LocalDirAllocator dir;
    private long startTime;
    private int BUFFER_SIZE;

    private void resetMeasurements() {
        this.startTime = Time.now();
    }

    private void printMeasurements() {
        System.out.println(" time: " + (Time.now() - this.startTime) / 1000L);
    }

    private Path writeLocalFile(String name, Configuration conf, long total) throws IOException {
        Path path = this.dir.getLocalPathForWrite(name, total, conf);
        System.out.print("Writing " + name);
        this.resetMeasurements();
        FileOutputStream out = new FileOutputStream(new File(path.toString()));
        byte[] data = new byte[this.BUFFER_SIZE];
        for (long size = 0L; size < total; size += (long)this.BUFFER_SIZE) {
            ((OutputStream)out).write(data);
        }
        ((OutputStream)out).close();
        this.printMeasurements();
        return path;
    }

    private void readLocalFile(Path path, String name, Configuration conf) throws IOException {
        System.out.print("Reading " + name);
        this.resetMeasurements();
        FileInputStream in = new FileInputStream(new File(path.toString()));
        byte[] data = new byte[this.BUFFER_SIZE];
        long size = 0L;
        while (size >= 0L) {
            size = ((InputStream)in).read(data);
        }
        ((InputStream)in).close();
        this.printMeasurements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndReadLocalFile(String name, Configuration conf, long size) throws IOException {
        Path f = null;
        try {
            f = this.writeLocalFile(name, conf, size);
            this.readLocalFile(f, name, conf);
        }
        finally {
            if (f != null) {
                new File(f.toString()).delete();
            }
        }
    }

    private Path writeFile(FileSystem fs, String name, Configuration conf, long total) throws IOException {
        Path f = this.dir.getLocalPathForWrite(name, total, conf);
        System.out.print("Writing " + name);
        this.resetMeasurements();
        FSDataOutputStream out = fs.create(f);
        byte[] data = new byte[this.BUFFER_SIZE];
        for (long size = 0L; size < total; size += (long)this.BUFFER_SIZE) {
            ((OutputStream)out).write(data);
        }
        ((OutputStream)out).close();
        this.printMeasurements();
        return f;
    }

    private void readFile(FileSystem fs, Path f, String name, Configuration conf) throws IOException {
        System.out.print("Reading " + name);
        this.resetMeasurements();
        FSDataInputStream in = fs.open(f);
        byte[] data = new byte[this.BUFFER_SIZE];
        long val = 0L;
        while (val >= 0L) {
            val = ((InputStream)in).read(data);
        }
        ((InputStream)in).close();
        this.printMeasurements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndReadFile(FileSystem fs, String name, Configuration conf, long size) throws IOException {
        Path f = null;
        try {
            f = this.writeFile(fs, name, conf, size);
            this.readFile(fs, f, name, conf);
        }
        finally {
            try {
                if (f != null) {
                    fs.delete(f, true);
                }
            }
            catch (IOException ie) {}
        }
    }

    private static void printUsage() {
        ToolRunner.printGenericCommandUsage(System.err);
        System.err.println("Usage: dfsthroughput [#reps]");
        System.err.println("Config properties:\n  dfsthroughput.file.size:\tsize of each write/read (10GB)\n  dfsthroughput.buffer.size:\tbuffer size for write/read (4k)\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws IOException {
        Log hadoopLog = LogFactory.getLog((String)"org");
        if (hadoopLog instanceof Log4JLogger) {
            ((Log4JLogger)hadoopLog).getLogger().setLevel(Level.WARN);
        }
        int reps = 1;
        if (args.length == 1) {
            try {
                reps = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                BenchmarkThroughput.printUsage();
                return -1;
            }
        } else if (args.length > 1) {
            BenchmarkThroughput.printUsage();
            return -1;
        }
        Configuration conf = this.getConf();
        long SIZE = conf.getLong("dfsthroughput.file.size", 0x280000000L);
        this.BUFFER_SIZE = conf.getInt("dfsthroughput.buffer.size", 4096);
        String localDir = conf.get("mapred.temp.dir");
        if (localDir == null) {
            localDir = conf.get("hadoop.tmp.dir");
            conf.set("mapred.temp.dir", localDir);
        }
        this.dir = new LocalDirAllocator("mapred.temp.dir");
        System.setProperty("test.build.data", localDir);
        System.out.println("Local = " + localDir);
        LocalFileSystem checkedLocal = FileSystem.getLocal(conf);
        FileSystem rawLocal = checkedLocal.getRawFileSystem();
        for (int i = 0; i < reps; ++i) {
            this.writeAndReadLocalFile("local", conf, SIZE);
            this.writeAndReadFile(rawLocal, "raw", conf, SIZE);
            this.writeAndReadFile(checkedLocal, "checked", conf, SIZE);
        }
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).racks(new String[]{"/foo"}).build();
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            for (int i = 0; i < reps; ++i) {
                this.writeAndReadFile(dfs, "dfs", conf, SIZE);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                rawLocal.delete(new Path(localDir, "dfs"), true);
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new HdfsConfiguration(), new BenchmarkThroughput(), args);
        System.exit(res);
    }
}

