/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Test;

public class TestClose {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteAfterClose() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            byte[] data = "foo".getBytes();
            FileSystem fs = FileSystem.get(conf);
            FSDataOutputStream out = fs.create(new Path("/test"));
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
            try {
                ((OutputStream)out).write(data);
                Assert.fail((String)"Should not have been able to write more data after file is closed.");
            }
            catch (ClosedChannelException cce) {
                // empty catch block
            }
            ((OutputStream)out).close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

