/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDFSUtil {
    @Before
    public void resetUGI() {
        UserGroupInformation.setConfiguration(new Configuration());
    }

    @Test
    public void testLocatedBlocks2Locations() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, 0L, false);
        ExtendedBlock b2 = new ExtendedBlock("bpid", 2L, 1L, 1L);
        LocatedBlock l2 = new LocatedBlock(b2, ds, 0L, true);
        List<LocatedBlock> ls = Arrays.asList(l1, l2);
        LocatedBlocks lbs = new LocatedBlocks(10L, false, ls, l2, true);
        BlockLocation[] bs = DFSUtil.locatedBlocks2Locations(lbs);
        Assert.assertTrue((String)("expected 2 blocks but got " + bs.length), (bs.length == 2 ? 1 : 0) != 0);
        int corruptCount = 0;
        for (BlockLocation b : bs) {
            if (!b.isCorrupt()) continue;
            ++corruptCount;
        }
        Assert.assertTrue((String)("expected 1 corrupt files but got " + corruptCount), (corruptCount == 1 ? 1 : 0) != 0);
        bs = DFSUtil.locatedBlocks2Locations(new LocatedBlocks());
        Assert.assertEquals((long)0L, (long)bs.length);
    }

    @Test
    public void testLocatedBlockConstructorWithNullCachedLocs() {
        DatanodeInfo d = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, null, null, 0L, false, null);
        DatanodeInfo[] cachedLocs = l1.getCachedLocations();
        Assert.assertTrue((cachedLocs.length == 0 ? 1 : 0) != 0);
    }

    private Configuration setupAddress(String key) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1");
        conf.set(DFSUtil.addKeySuffixes(key, "nn1"), "localhost:9000");
        return conf;
    }

    @Test
    public void getNameServiceId() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservice.id", "nn1");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId(conf));
    }

    @Test
    public void getNameNodeNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.rpc-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId(conf));
    }

    @Test
    public void getBackupNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.backup.address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getBackupNameServiceId(conf));
    }

    @Test
    public void getSecondaryNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.secondary.http-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getSecondaryNameServiceId(conf));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testGetNameServiceIdException() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "nn1"), "localhost:9000");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "nn2"), "localhost:9001");
        DFSUtil.getNamenodeNameServiceId(conf);
        Assert.fail((String)"Expected exception is not thrown");
    }

    @Test
    public void testGetNameServiceIds() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        Collection<String> nameserviceIds = DFSUtil.getNameServiceIds(conf);
        Iterator<String> it = nameserviceIds.iterator();
        Assert.assertEquals((long)2L, (long)nameserviceIds.size());
        Assert.assertEquals((Object)"nn1", (Object)it.next().toString());
        Assert.assertEquals((Object)"nn2", (Object)it.next().toString());
    }

    @Test
    public void testGetOnlyNameServiceIdOrNull() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1,ns2");
        Assert.assertNull((Object)DFSUtil.getOnlyNameServiceIdOrNull(conf));
        conf.set("dfs.nameservices", "");
        Assert.assertNull((Object)DFSUtil.getOnlyNameServiceIdOrNull(conf));
        conf.set("dfs.nameservices", "ns1");
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getOnlyNameServiceIdOrNull(conf));
    }

    @Test
    public void testMultipleNamenodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "nn1,nn2");
        String NN1_ADDRESS = "localhost:9000";
        String NN2_ADDRESS = "localhost:9001";
        String NN3_ADDRESS = "localhost:9002";
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "nn1"), "localhost:9000");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "nn2"), "localhost:9001");
        Map<String, Map<String, InetSocketAddress>> nnMap = DFSUtil.getNNServiceRpcAddresses(conf);
        Assert.assertEquals((long)2L, (long)nnMap.size());
        Map<String, InetSocketAddress> nn1Map = nnMap.get("nn1");
        Assert.assertEquals((long)1L, (long)nn1Map.size());
        InetSocketAddress addr = nn1Map.get(null);
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9000L, (long)addr.getPort());
        Map<String, InetSocketAddress> nn2Map = nnMap.get("nn2");
        Assert.assertEquals((long)1L, (long)nn2Map.size());
        addr = nn2Map.get(null);
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9001L, (long)addr.getPort());
        this.checkNameServiceId(conf, "localhost:9000", "nn1");
        this.checkNameServiceId(conf, "localhost:9001", "nn2");
        this.checkNameServiceId(conf, "localhost:9002", null);
        Assert.assertFalse((boolean)HAUtil.isHAEnabled(conf, "nn1"));
        Assert.assertFalse((boolean)HAUtil.isHAEnabled(conf, "nn2"));
    }

    public void checkNameServiceId(Configuration conf, String addr, String expectedNameServiceId) {
        InetSocketAddress s = NetUtils.createSocketAddr(addr);
        String nameserviceId = DFSUtil.getNameServiceIdFromAddress(conf, s, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        Assert.assertEquals((Object)expectedNameServiceId, (Object)nameserviceId);
    }

    @Test
    public void testDefaultNamenode() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String hdfs_default = "hdfs://localhost:9999/";
        conf.set("fs.defaultFS", "hdfs://localhost:9999/");
        Map<String, Map<String, InetSocketAddress>> addrMap = DFSUtil.getNNServiceRpcAddresses(conf);
        Assert.assertEquals((long)1L, (long)addrMap.size());
        Map<String, InetSocketAddress> defaultNsMap = addrMap.get(null);
        Assert.assertEquals((long)1L, (long)defaultNsMap.size());
        Assert.assertEquals((long)9999L, (long)defaultNsMap.get(null).getPort());
    }

    @Test
    public void testConfModificationFederationOnly() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = "ns1";
        conf.set("dfs.nameservices", nsId);
        conf.set("dfs.nameservice.id", nsId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            conf.set(DFSUtil.addKeySuffixes(key, nsId), key);
        }
        NameNode.initializeGenericKeys(conf, nsId, null);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            Assert.assertEquals((Object)key, (Object)conf.get(key));
        }
    }

    @Test
    public void testConfModificationFederationAndHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = "ns1";
        String nnId = "nn1";
        conf.set("dfs.nameservices", nsId);
        conf.set("dfs.nameservice.id", nsId);
        conf.set("dfs.ha.namenodes." + nsId, nnId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            conf.set(DFSUtil.addKeySuffixes(key, nsId, nnId), key);
        }
        NameNode.initializeGenericKeys(conf, nsId, nnId);
        for (String key : NameNode.NAMENODE_SPECIFIC_KEYS) {
            Assert.assertEquals((Object)key, (Object)conf.get(key));
        }
    }

    @Test
    public void testConfModificationNoFederationOrHa() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String nsId = null;
        String nnId = null;
        conf.set("dfs.namenode.rpc-address", "localhost:1234");
        Assert.assertFalse((boolean)"hdfs://localhost:1234".equals(conf.get("fs.defaultFS")));
        NameNode.initializeGenericKeys(conf, nsId, nnId);
        Assert.assertEquals((Object)"hdfs://localhost:1234", (Object)conf.get("fs.defaultFS"));
    }

    @Test
    public void testSomeConfsNNSpecificSomeNSSpecific() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String key = "dfs.namenode.shared.edits.dir";
        conf.set(key, "global-default");
        conf.set(key + ".ns1", "ns1-override");
        conf.set(key + ".ns1.nn1", "nn1-override");
        Configuration newConf = new Configuration(conf);
        NameNode.initializeGenericKeys(newConf, "ns2", "nn1");
        Assert.assertEquals((Object)"global-default", (Object)newConf.get(key));
        newConf = new Configuration(conf);
        NameNode.initializeGenericKeys(newConf, "ns2", null);
        Assert.assertEquals((Object)"global-default", (Object)newConf.get(key));
        newConf = new Configuration(conf);
        NameNode.initializeGenericKeys(newConf, "ns1", "nn2");
        Assert.assertEquals((Object)"ns1-override", (Object)newConf.get(key));
        newConf = new Configuration(conf);
        NameNode.initializeGenericKeys(newConf, "ns1", "nn1");
        Assert.assertEquals((Object)"nn1-override", (Object)newConf.get(key));
    }

    @Test
    public void testEmptyConf() {
        Map<String, Map<String, InetSocketAddress>> map;
        HdfsConfiguration conf = new HdfsConfiguration(false);
        try {
            map = DFSUtil.getNNServiceRpcAddresses(conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString(map)));
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            map = DFSUtil.getBackupNodeAddresses(conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString(map)));
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            map = DFSUtil.getSecondaryNameNodeAddresses(conf);
            Assert.fail((String)("Expected IOException is not thrown, result was: " + DFSUtil.addressMapToString(map)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetInfoServer() throws IOException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        URI httpsport = DFSUtil.getInfoServer(null, conf, "https");
        Assert.assertEquals((Object)new URI("https", null, "0.0.0.0", 50470, null, null, null), (Object)httpsport);
        URI httpport = DFSUtil.getInfoServer(null, conf, "http");
        Assert.assertEquals((Object)new URI("http", null, "0.0.0.0", 50070, null, null, null), (Object)httpport);
        URI httpAddress = DFSUtil.getInfoServer(new InetSocketAddress("localhost", 8020), conf, "http");
        Assert.assertEquals((Object)URI.create("http://localhost:50070"), (Object)httpAddress);
    }

    @Test
    public void testHANameNodesWithFederation() throws URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS1_NN1_HOST = "ns1-nn1.example.com:8020";
        String NS1_NN2_HOST = "ns1-nn2.example.com:8020";
        String NS2_NN1_HOST = "ns2-nn1.example.com:8020";
        String NS2_NN2_HOST = "ns2-nn2.example.com:8020";
        conf.set("fs.defaultFS", "hdfs://ns1");
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", "ns1"), "ns1-nn1,ns1-nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", "ns2"), "ns2-nn1,ns2-nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "ns1-nn1"), "ns1-nn1.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "ns1-nn2"), "ns1-nn2.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns2", "ns2-nn1"), "ns2-nn1.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns2", "ns2-nn2"), "ns2-nn2.example.com:8020");
        Map<String, Map<String, InetSocketAddress>> map = DFSUtil.getHaNnRpcAddresses(conf);
        Assert.assertTrue((boolean)HAUtil.isHAEnabled(conf, "ns1"));
        Assert.assertTrue((boolean)HAUtil.isHAEnabled(conf, "ns2"));
        Assert.assertFalse((boolean)HAUtil.isHAEnabled(conf, "ns3"));
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)map.get("ns1").get("ns1-nn1").toString());
        Assert.assertEquals((Object)"ns1-nn2.example.com:8020", (Object)map.get("ns1").get("ns1-nn2").toString());
        Assert.assertEquals((Object)"ns2-nn1.example.com:8020", (Object)map.get("ns2").get("ns2-nn1").toString());
        Assert.assertEquals((Object)"ns2-nn2.example.com:8020", (Object)map.get("ns2").get("ns2-nn2").toString());
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, "ns1", "ns1-nn1"));
        Assert.assertEquals((Object)"ns1-nn2.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, "ns1", "ns1-nn2"));
        Assert.assertEquals((Object)"ns2-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, "ns2", "ns2-nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeServiceAddr(conf, null, "ns1-nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeNameServiceId(conf));
        Assert.assertEquals(null, (Object)DFSUtil.getSecondaryNameServiceId(conf));
        Collection<URI> uris = DFSUtil.getNameServiceUris(conf, "dfs.namenode.rpc-address");
        Assert.assertEquals((long)2L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns2")));
    }

    @Test
    public void getNameNodeServiceAddr() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS1_NN1_HOST = "ns1-nn1.example.com:8020";
        String NS1_NN1_HOST_SVC = "ns1-nn2.example.com:8021";
        String NS1_NN2_HOST = "ns1-nn1.example.com:8020";
        String NS1_NN2_HOST_SVC = "ns1-nn2.example.com:8021";
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", "ns1"), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "nn1"), "ns1-nn1.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "nn2"), "ns1-nn1.example.com:8020");
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, null, "nn1"));
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, null, "nn2"));
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)DFSUtil.getNamenodeServiceAddr(conf, "ns1", "nn1"));
        Assert.assertEquals(null, (Object)DFSUtil.getNamenodeServiceAddr(conf, "invalid", "nn1"));
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.servicerpc-address", "ns1", "nn1"), "ns1-nn2.example.com:8021");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.servicerpc-address", "ns1", "nn2"), "ns1-nn2.example.com:8021");
        Assert.assertEquals((Object)"ns1-nn2.example.com:8021", (Object)DFSUtil.getNamenodeServiceAddr(conf, null, "nn1"));
        Assert.assertEquals((Object)"ns1-nn2.example.com:8021", (Object)DFSUtil.getNamenodeServiceAddr(conf, null, "nn2"));
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getNamenodeNameServiceId(conf));
        Assert.assertEquals((Object)"ns1", (Object)DFSUtil.getSecondaryNameServiceId(conf));
    }

    @Test
    public void testGetHaNnHttpAddresses() throws IOException {
        String LOGICAL_HOST_NAME = "ns1";
        String NS1_NN1_ADDR = "ns1-nn1.example.com:8020";
        String NS1_NN2_ADDR = "ns1-nn2.example.com:8020";
        Configuration conf = TestDFSUtil.createWebHDFSHAConfiguration("ns1", "ns1-nn1.example.com:8020", "ns1-nn2.example.com:8020");
        Map<String, Map<String, InetSocketAddress>> map = DFSUtil.getHaNnWebHdfsAddresses(conf, "webhdfs");
        Assert.assertEquals((Object)"ns1-nn1.example.com:8020", (Object)map.get("ns1").get("nn1").toString());
        Assert.assertEquals((Object)"ns1-nn2.example.com:8020", (Object)map.get("ns1").get("nn2").toString());
    }

    @Test
    public void testResolve() throws IOException, URISyntaxException {
        String LOGICAL_HOST_NAME = "ns1";
        String NS1_NN1_HOST = "ns1-nn1.example.com";
        String NS1_NN2_HOST = "ns1-nn2.example.com";
        String NS1_NN1_ADDR = "ns1-nn1.example.com:8020";
        String NS1_NN2_ADDR = "ns1-nn2.example.com:8020";
        int DEFAULT_PORT = 8020;
        Configuration conf = TestDFSUtil.createWebHDFSHAConfiguration("ns1", "ns1-nn1.example.com:8020", "ns1-nn2.example.com:8020");
        URI uri = new URI("webhdfs://ns1");
        Assert.assertTrue((boolean)HAUtil.isLogicalUri(conf, uri));
        Object[] addrs = DFSUtil.resolveWebHdfsUri(uri, conf);
        Assert.assertArrayEquals((Object[])new InetSocketAddress[]{new InetSocketAddress("ns1-nn1.example.com", 8020), new InetSocketAddress("ns1-nn2.example.com", 8020)}, (Object[])addrs);
    }

    private static Configuration createWebHDFSHAConfiguration(String logicalHostName, String nnaddr1, String nnaddr2) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", "ns1"), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.http-address", "ns1", "nn1"), nnaddr1);
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.http-address", "ns1", "nn2"), nnaddr2);
        conf.set("dfs.client.failover.proxy.provider." + logicalHostName, ConfiguredFailoverProxyProvider.class.getName());
        return conf;
    }

    @Test
    public void testSubstituteForWildcardAddress() throws IOException {
        Assert.assertEquals((Object)"foo:12345", (Object)DFSUtil.substituteForWildcardAddress("0.0.0.0:12345", "foo"));
        Assert.assertEquals((Object)"127.0.0.1:12345", (Object)DFSUtil.substituteForWildcardAddress("127.0.0.1:12345", "foo"));
    }

    @Test
    public void testGetNNUris() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String NS1_NN1_ADDR = "ns1-nn1.example.com:8020";
        String NS1_NN2_ADDR = "ns1-nn2.example.com:8020";
        String NS2_NN_ADDR = "ns2-nn.example.com:8020";
        String NN1_ADDR = "nn.example.com:8020";
        String NN1_SRVC_ADDR = "nn.example.com:8021";
        String NN2_ADDR = "nn2.example.com:8020";
        conf.set("dfs.nameservices", "ns1,ns2");
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", "ns1"), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "nn1"), "ns1-nn1.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", "ns1", "nn2"), "ns1-nn2.example.com:8020");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.servicerpc-address", "ns2"), "ns2-nn.example.com:8020");
        conf.set("dfs.namenode.rpc-address", "hdfs://nn.example.com:8020");
        conf.set("fs.defaultFS", "hdfs://nn2.example.com:8020");
        Collection<URI> uris = DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        Assert.assertEquals((long)4L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://nn2.example.com:8020")));
        conf.set("fs.defaultFS", "viewfs://vfs-name.example.com");
        uris = DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        Assert.assertEquals((long)3L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf.set("fs.defaultFS", "hdfs://ns1");
        uris = DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        Assert.assertEquals((long)3L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns1")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://ns2-nn.example.com:8020")));
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://nn.example.com:8020")));
        conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://nn.example.com:8020");
        conf.set("dfs.namenode.rpc-address", "nn.example.com:8020");
        conf.set("dfs.namenode.servicerpc-address", "nn.example.com:8021");
        uris = DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        Assert.assertEquals((long)1L, (long)uris.size());
        Assert.assertTrue((boolean)uris.contains(new URI("hdfs://nn.example.com:8021")));
    }

    @Test(timeout=15000L)
    public void testLocalhostReverseLookup() {
        Assume.assumeTrue((!Shell.WINDOWS ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "hdfs://127.0.0.1:8020");
        Collection<URI> uris = DFSUtil.getNameServiceUris(conf, new String[0]);
        Assert.assertEquals((long)1L, (long)uris.size());
        for (URI uri : uris) {
            Assert.assertThat((Object)uri.getHost(), (Matcher)CoreMatchers.not((Object)"127.0.0.1"));
        }
    }

    @Test(timeout=15000L)
    public void testIsValidName() {
        Assert.assertFalse((boolean)DFSUtil.isValidName("/foo/../bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName("/foo/./bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName("/foo//bar"));
        Assert.assertTrue((boolean)DFSUtil.isValidName("/"));
        Assert.assertTrue((boolean)DFSUtil.isValidName("/bar/"));
        Assert.assertFalse((boolean)DFSUtil.isValidName("/foo/:/bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName("/foo:bar"));
    }

    @Test(timeout=5000L)
    public void testGetSpnegoKeytabKey() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultKey = "default.spengo.key";
        conf.unset("dfs.web.authentication.kerberos.keytab");
        Assert.assertEquals((String)"Test spnego key in config is null", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey(conf, defaultKey));
        conf.set("dfs.web.authentication.kerberos.keytab", "");
        Assert.assertEquals((String)"Test spnego key is empty", (Object)defaultKey, (Object)DFSUtil.getSpnegoKeytabKey(conf, defaultKey));
        String spengoKey = "spengo.key";
        conf.set("dfs.web.authentication.kerberos.keytab", spengoKey);
        Assert.assertEquals((String)"Test spnego key is NOT null", (Object)"dfs.web.authentication.kerberos.keytab", (Object)DFSUtil.getSpnegoKeytabKey(conf, defaultKey));
    }

    @Test(timeout=1000L)
    public void testDurationToString() throws Exception {
        Assert.assertEquals((Object)"000:00:00:00.000", (Object)DFSUtil.durationToString(0L));
        Assert.assertEquals((Object)"001:01:01:01.000", (Object)DFSUtil.durationToString(90061000L));
        Assert.assertEquals((Object)"000:23:59:59.999", (Object)DFSUtil.durationToString(86399999L));
        Assert.assertEquals((Object)"-001:01:01:01.000", (Object)DFSUtil.durationToString(-90061000L));
        Assert.assertEquals((Object)"-000:23:59:59.574", (Object)DFSUtil.durationToString(-86399574L));
    }

    @Test(timeout=5000L)
    public void testRelativeTimeConversion() throws Exception {
        try {
            DFSUtil.parseRelativeTime("1");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("too short", e);
        }
        try {
            DFSUtil.parseRelativeTime("1z");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("unknown time unit", e);
        }
        try {
            DFSUtil.parseRelativeTime("yyz");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("is not a number", e);
        }
        Assert.assertEquals((long)61000L, (long)DFSUtil.parseRelativeTime("61s"));
        Assert.assertEquals((long)3660000L, (long)DFSUtil.parseRelativeTime("61m"));
        Assert.assertEquals((long)0L, (long)DFSUtil.parseRelativeTime("0s"));
        Assert.assertEquals((long)90000000L, (long)DFSUtil.parseRelativeTime("25h"));
        Assert.assertEquals((long)345600000L, (long)DFSUtil.parseRelativeTime("4d"));
        Assert.assertEquals((long)86313600000L, (long)DFSUtil.parseRelativeTime("999d"));
    }

    @Test
    public void testAssertAllResultsEqual() {
        TestDFSUtil.checkAllResults(new Long[0], true);
        TestDFSUtil.checkAllResults(new Long[]{1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L, 1L}, true);
        TestDFSUtil.checkAllResults(new Long[]{new Long(1L), new Long(1L)}, true);
        TestDFSUtil.checkAllResults(new Long[]{null, null, null}, true);
        TestDFSUtil.checkAllResults(new Long[]{1L, 2L}, false);
        TestDFSUtil.checkAllResults(new Long[]{2L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, 2L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{2L, 1L, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, 1L, 2L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, null}, false);
        TestDFSUtil.checkAllResults(new Long[]{null, 1L}, false);
        TestDFSUtil.checkAllResults(new Long[]{1L, null, 1L}, false);
    }

    private static void checkAllResults(Long[] toCheck, boolean shouldSucceed) {
        if (shouldSucceed) {
            DFSUtil.assertAllResultsEqual(Arrays.asList(toCheck));
        } else {
            try {
                DFSUtil.assertAllResultsEqual(Arrays.asList(toCheck));
                Assert.fail((String)("Should not have succeeded with input: " + Arrays.toString((Object[])toCheck)));
            }
            catch (AssertionError ae) {
                GenericTestUtils.assertExceptionContains("Not all elements match", (Throwable)((Object)ae));
            }
        }
    }
}

