/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFileAppendRestart {
    private static final int BLOCK_SIZE = 4096;
    private static final String HADOOP_23_BROKEN_APPEND_TGZ = "image-with-buggy-append.tgz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndAppend(FileSystem fs, Path p, int lengthForCreate, int lengthForAppend) throws IOException {
        FSDataOutputStream stream = fs.create(p, true, 4096, (short)1, 4096L);
        try {
            AppendTestUtil.write(stream, 0, lengthForCreate);
            stream.close();
            stream = fs.append(p);
            AppendTestUtil.write(stream, lengthForCreate, lengthForAppend);
            stream.close();
        }
        finally {
            IOUtils.closeStream(stream);
        }
        int totalLength = lengthForCreate + lengthForAppend;
        Assert.assertEquals((long)totalLength, (long)fs.getFileStatus(p).getLen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendRestart() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        MiniDFSCluster cluster = null;
        Closeable stream = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            File editLog = new File(FSImageTestUtil.getNameNodeCurrentDirs(cluster, 0).get(0), NNStorage.getInProgressEditsFileName(1L));
            Path p1 = new Path("/block-boundaries");
            this.writeAndAppend(fs, p1, 4096, 4096);
            EnumMap<FSEditLogOpCodes, Holder<Integer>> counts = FSImageTestUtil.countEditLogOpTypes(editLog);
            Assert.assertEquals((long)2L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_ADD)).held).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_ADD_BLOCK)).held).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_CLOSE)).held).intValue());
            Path p2 = new Path("/not-block-boundaries");
            this.writeAndAppend(fs, p2, 2048, 4096);
            counts = FSImageTestUtil.countEditLogOpTypes(editLog);
            Assert.assertEquals((long)4L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_ADD)).held).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_UPDATE_BLOCKS)).held).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_ADD_BLOCK)).held).intValue());
            Assert.assertEquals((long)4L, (long)((Integer)counts.get((Object)((Object)FSEditLogOpCodes.OP_CLOSE)).held).intValue());
            cluster.restartNameNode(new String[0]);
            AppendTestUtil.check(fs, p1, 8192L);
            AppendTestUtil.check(fs, p2, 6144L);
        }
        finally {
            IOUtils.closeStream(stream);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadLogsFromBuggyEarlierVersions() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String tarFile = System.getProperty("test.cache.data", "build/test/cache") + "/" + HADOOP_23_BROKEN_APPEND_TGZ;
        String testDir = PathUtils.getTestDirName(this.getClass());
        File dfsDir = new File(testDir, "image-with-buggy-append");
        if (dfsDir.exists() && !FileUtil.fullyDelete(dfsDir)) {
            throw new IOException("Could not delete dfs directory '" + dfsDir + "'");
        }
        FileUtil.unTar(new File(tarFile), new File(testDir));
        File nameDir = new File(dfsDir, "name");
        GenericTestUtils.assertExists(nameDir);
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).numDataNodes(0).waitSafeMode(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/tmp/io_data/test_io_0");
            Assert.assertEquals((long)0x200000L, (long)((FileSystem)fs).getFileStatus(testPath).getLen());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithPipelineRecovery() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSDataOutputStream out = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).manageDataDfsDirs(true).manageNameDfsDirs(true).numDataNodes(4).racks(new String[]{"/rack1", "/rack1", "/rack1", "/rack2"}).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path("/test1");
            out = fs.create(path, true, 4096, (short)3, 4096L);
            AppendTestUtil.write(out, 0, 1024);
            out.close();
            cluster.stopDataNode(3);
            out = fs.append(path);
            AppendTestUtil.write(out, 1024, 1024);
            out.close();
            cluster.restartNameNode(true);
            AppendTestUtil.check(fs, path, 2048L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            if (null != cluster) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.closeStream(out);
        if (null != cluster) {
            cluster.shutdown();
        }
    }
}

