/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.CRC32;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.hadoop.shaded.com.google.common.io.Files;
import org.apache.flink.hadoop.shaded.com.google.common.primitives.Bytes;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;

public class UpgradeUtilities {
    private static final File TEST_ROOT_DIR = new File(MiniDFSCluster.getBaseDirectory());
    private static final File namenodeStorage = new File(TEST_ROOT_DIR, "namenodeMaster");
    private static long namenodeStorageChecksum;
    private static int namenodeStorageNamespaceID;
    private static String namenodeStorageClusterID;
    private static String namenodeStorageBlockPoolID;
    private static long namenodeStorageFsscTime;
    private static final File datanodeStorage;
    private static long datanodeStorageChecksum;
    private static long blockPoolStorageChecksum;
    private static long blockPoolFinalizedStorageChecksum;
    private static long blockPoolRbwStorageChecksum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws Exception {
        UpgradeUtilities.createEmptyDirs(new String[]{TEST_ROOT_DIR.toString()});
        HdfsConfiguration config = new HdfsConfiguration();
        config.set("dfs.namenode.name.dir", namenodeStorage.toString());
        config.set("dfs.namenode.edits.dir", namenodeStorage.toString());
        config.set("dfs.datanode.data.dir", datanodeStorage.toString());
        MiniDFSCluster cluster = null;
        String bpid = null;
        try {
            UpgradeUtilities.createEmptyDirs(new String[]{datanodeStorage.toString()});
            DFSTestUtil.formatNameNode(config);
            cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).startupOption(HdfsServerConstants.StartupOption.REGULAR).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            namenodeStorageNamespaceID = namenode.versionRequest().getNamespaceID();
            namenodeStorageFsscTime = namenode.versionRequest().getCTime();
            namenodeStorageClusterID = namenode.versionRequest().getClusterID();
            namenodeStorageBlockPoolID = namenode.versionRequest().getBlockPoolID();
            FileSystem fs = FileSystem.get(config);
            Path baseDir = new Path("/TestUpgrade");
            fs.mkdirs(baseDir);
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            for (int i = 0; i < bufferSize; ++i) {
                buffer[i] = (byte)(48 + i % 50);
            }
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file1"), buffer, bufferSize);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file2"), buffer, bufferSize);
            namenode.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            namenode.saveNamespace();
            namenode.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file3"), buffer, bufferSize);
            UpgradeUtilities.writeFile(fs, new Path(baseDir, "file4"), buffer, bufferSize);
            bpid = cluster.getNamesystem(0).getBlockPoolId();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            FileUtil.fullyDelete(new File(namenodeStorage, "in_use.lock"));
            FileUtil.fullyDelete(new File(datanodeStorage, "in_use.lock"));
        }
        namenodeStorageChecksum = UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.NAME_NODE, new File(namenodeStorage, "current"));
        File dnCurDir = new File(datanodeStorage, "current");
        datanodeStorageChecksum = UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, dnCurDir);
        File bpCurDir = new File(BlockPoolSliceStorage.getBpRoot(bpid, dnCurDir), "current");
        blockPoolStorageChecksum = UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpCurDir);
        File bpCurFinalizeDir = new File(BlockPoolSliceStorage.getBpRoot(bpid, dnCurDir), "current/finalized");
        blockPoolFinalizedStorageChecksum = UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpCurFinalizeDir);
        File bpCurRbwDir = new File(BlockPoolSliceStorage.getBpRoot(bpid, dnCurDir), "current/rbw");
        blockPoolRbwStorageChecksum = UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpCurRbwDir);
    }

    private static void writeFile(FileSystem fs, Path path, byte[] buffer, int bufferSize) throws IOException {
        FSDataOutputStream out = fs.create(path, true, bufferSize, (short)1, 1024L);
        ((OutputStream)out).write(buffer, 0, bufferSize);
        ((OutputStream)out).close();
    }

    public static Configuration initializeStorageStateConf(int numDirs, Configuration conf) {
        StringBuffer nameNodeDirs = new StringBuffer(new File(TEST_ROOT_DIR, "name1").toString());
        StringBuffer dataNodeDirs = new StringBuffer(new File(TEST_ROOT_DIR, "data1").toString());
        for (int i = 2; i <= numDirs; ++i) {
            nameNodeDirs.append("," + new File(TEST_ROOT_DIR, "name" + i));
            dataNodeDirs.append("," + new File(TEST_ROOT_DIR, "data" + i));
        }
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        conf.set("dfs.namenode.name.dir", nameNodeDirs.toString());
        conf.set("dfs.namenode.edits.dir", nameNodeDirs.toString());
        conf.set("dfs.datanode.data.dir", dataNodeDirs.toString());
        conf.setInt("dfs.blockreport.intervalMsec", 10000);
        return conf;
    }

    public static void createEmptyDirs(String[] dirs) throws IOException {
        for (String d : dirs) {
            File dir = new File(d);
            if (dir.exists()) {
                FileUtil.fullyDelete(dir);
            }
            dir.mkdirs();
        }
    }

    public static long checksumMasterNameNodeContents() {
        return namenodeStorageChecksum;
    }

    public static long checksumMasterDataNodeContents() {
        return datanodeStorageChecksum;
    }

    public static long checksumMasterBlockPoolContents() {
        return blockPoolStorageChecksum;
    }

    public static long checksumMasterBlockPoolFinalizedContents() {
        return blockPoolFinalizedStorageChecksum;
    }

    public static long checksumMasterBlockPoolRbwContents() {
        return blockPoolRbwStorageChecksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checksumContents(HdfsServerConstants.NodeType nodeType, File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Given argument is not a directory:" + dir);
        }
        Object[] list = dir.listFiles();
        Arrays.sort(list);
        CRC32 checksum = new CRC32();
        for (int i = 0; i < list.length; ++i) {
            if (!((File)list[i]).isFile() || nodeType == HdfsServerConstants.NodeType.DATA_NODE && (((File)list[i]).getName().equals("VERSION") || ((File)list[i]).getName().equals("dfsUsed"))) continue;
            FileInputStream fis = null;
            try {
                int bytesRead;
                fis = new FileInputStream((File)list[i]);
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    checksum.update(buffer, 0, bytesRead);
                }
                continue;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return checksum.getValue();
    }

    public static File[] createNameNodeStorageDirs(String[] parents, String dirName) throws Exception {
        File[] retVal = new File[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            File newDir = new File(parents[i], dirName);
            UpgradeUtilities.createEmptyDirs(new String[]{newDir.toString()});
            LocalFileSystem localFS = FileSystem.getLocal(new HdfsConfiguration());
            localFS.copyToLocalFile(new Path(namenodeStorage.toString(), "current"), new Path(newDir.toString()), false);
            retVal[i] = newDir;
        }
        return retVal;
    }

    public static File[] createDataNodeStorageDirs(String[] parents, String dirName) throws Exception {
        File[] retVal = new File[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            File newDir = new File(parents[i], dirName);
            UpgradeUtilities.createEmptyDirs(new String[]{newDir.toString()});
            LocalFileSystem localFS = FileSystem.getLocal(new HdfsConfiguration());
            localFS.copyToLocalFile(new Path(datanodeStorage.toString(), "current"), new Path(newDir.toString()), false);
            retVal[i] = newDir;
        }
        return retVal;
    }

    public static File[] createBlockPoolStorageDirs(String[] parents, String dirName, String bpid) throws Exception {
        File[] retVal = new File[parents.length];
        Path bpCurDir = new Path(MiniDFSCluster.getBPDir(datanodeStorage, bpid, "current"));
        for (int i = 0; i < parents.length; ++i) {
            File newDir = new File(parents[i] + "/current/" + bpid, dirName);
            UpgradeUtilities.createEmptyDirs(new String[]{newDir.toString()});
            LocalFileSystem localFS = FileSystem.getLocal(new HdfsConfiguration());
            localFS.copyToLocalFile(bpCurDir, new Path(newDir.toString()), false);
            retVal[i] = newDir;
        }
        return retVal;
    }

    public static File[] createNameNodeVersionFile(Configuration conf, File[] parent, StorageInfo version, String bpid) throws IOException {
        NNStorage storage = new NNStorage(conf, Collections.<URI>emptyList(), Collections.<URI>emptyList());
        storage.setStorageInfo(version);
        File[] versionFiles = new File[parent.length];
        for (int i = 0; i < parent.length; ++i) {
            versionFiles[i] = new File(parent[i], "VERSION");
            Storage.StorageDirectory sd = new Storage.StorageDirectory(parent[i].getParentFile());
            storage.writeProperties(versionFiles[i], sd);
        }
        return versionFiles;
    }

    public static void createDataNodeVersionFile(File[] parent, StorageInfo version, String bpid) throws IOException {
        UpgradeUtilities.createDataNodeVersionFile(parent, version, bpid, bpid);
    }

    public static void createDataNodeVersionFile(File[] parent, StorageInfo version, String bpid, String bpidToWrite) throws IOException {
        DataStorage storage = new DataStorage(version);
        storage.setDatanodeUuid("FixedDatanodeUuid");
        File[] versionFiles = new File[parent.length];
        for (int i = 0; i < parent.length; ++i) {
            File versionFile = new File(parent[i], "VERSION");
            Storage.StorageDirectory sd = new Storage.StorageDirectory(parent[i].getParentFile());
            storage.createStorageID(sd);
            storage.writeProperties(versionFile, sd);
            versionFiles[i] = versionFile;
            File bpDir = BlockPoolSliceStorage.getBpRoot(bpid, parent[i]);
            UpgradeUtilities.createBlockPoolVersionFile(bpDir, version, bpidToWrite);
        }
    }

    public static void createBlockPoolVersionFile(File bpDir, StorageInfo version, String bpid) throws IOException {
        if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, version.layoutVersion)) {
            File bpCurDir = new File(bpDir, "current");
            BlockPoolSliceStorage bpStorage = new BlockPoolSliceStorage(version, bpid);
            File versionFile = new File(bpCurDir, "VERSION");
            Storage.StorageDirectory sd = new Storage.StorageDirectory(bpDir);
            bpStorage.writeProperties(versionFile, sd);
        }
    }

    public static void corruptFile(File file, byte[] stringToCorrupt, byte[] replacement) throws IOException {
        Preconditions.checkArgument(replacement.length == stringToCorrupt.length);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Given argument is not a file:" + file);
        }
        byte[] data = Files.toByteArray(file);
        int index = Bytes.indexOf(data, stringToCorrupt);
        if (index == -1) {
            throw new IOException("File " + file + " does not contain string " + new String(stringToCorrupt));
        }
        for (int i = 0; i < stringToCorrupt.length; ++i) {
            data[index + i] = replacement[i];
        }
        Files.write(data, file);
    }

    public static int getCurrentNameNodeLayoutVersion() {
        return HdfsConstants.NAMENODE_LAYOUT_VERSION;
    }

    public static int getCurrentNamespaceID(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNodeRpc().versionRequest().getNamespaceID();
        }
        return namenodeStorageNamespaceID;
    }

    public static String getCurrentClusterID(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNodeRpc().versionRequest().getClusterID();
        }
        return namenodeStorageClusterID;
    }

    public static String getCurrentBlockPoolID(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNodeRpc().versionRequest().getBlockPoolID();
        }
        return namenodeStorageBlockPoolID;
    }

    public static long getCurrentFsscTime(MiniDFSCluster cluster) throws IOException {
        if (cluster != null) {
            return cluster.getNameNodeRpc().versionRequest().getCTime();
        }
        return namenodeStorageFsscTime;
    }

    public static String[] createEmptyBPDirs(String[] baseDirs, String bpid) throws IOException {
        String[] bpDirs = new String[baseDirs.length];
        for (int i = 0; i < baseDirs.length; ++i) {
            bpDirs[i] = MiniDFSCluster.getBPDir(new File(baseDirs[i]), bpid);
        }
        UpgradeUtilities.createEmptyDirs(bpDirs);
        return bpDirs;
    }

    static {
        datanodeStorage = new File(TEST_ROOT_DIR, "datanodeMaster");
    }
}

