/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Mockito;

public class TestClientProtocolWithDelegationToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestClientProtocolWithDelegationToken.class);
    private static final Configuration conf = new Configuration();

    @Test
    public void testDelegationTokenRpc() throws Exception {
        ClientProtocol mockNN = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        FSNamesystem mockNameSys = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DelegationTokenSecretManager sm = new DelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, mockNameSys);
        sm.startThreads();
        final RPC.Server server = new RPC.Builder(conf).setProtocol(ClientProtocol.class).setInstance(mockNN).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager(sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress(server);
        String user = current.getUserName();
        Text owner = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, owner, null);
        Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>(dtId, sm);
        SecurityUtil.setTokenService(token, addr);
        LOG.info((Object)("Service for token is " + token.getService()));
        current.addToken(token);
        current.doAs(new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                ClientProtocol proxy = null;
                try {
                    proxy = RPC.getProxy(ClientProtocol.class, 69L, addr, conf);
                    proxy.getServerDefaults();
                }
                finally {
                    server.stop();
                    if (proxy != null) {
                        RPC.stopProxy(proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }
}

