/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestReplicationPolicy {
    private final Random random;
    private static final int BLOCK_SIZE = 1024;
    private static final int NUM_OF_DATANODES = 6;
    private static NetworkTopology cluster;
    private static NameNode namenode;
    private static BlockPlacementPolicy replicator;
    private static final String filename = "/dummyfile.txt";
    private static DatanodeDescriptor[] dataNodes;
    private static DatanodeStorageInfo[] storages;
    private static final long staleInterval = 30000L;
    @Rule
    public ExpectedException exception;

    public TestReplicationPolicy() {
        ((Log4JLogger)BlockPlacementPolicy.LOG).getLogger().setLevel(Level.ALL);
        this.random = DFSUtil.getRandom();
        this.exception = ExpectedException.none();
    }

    private static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, "hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(TestReplicationPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        DFSTestUtil.formatNameNode(conf);
        namenode = new NameNode(conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        replicator = bm.getBlockPlacementPolicy();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (i = 0; i < 6; ++i) {
            cluster.add(dataNodes[i]);
            bm.getDatanodeManager().getHeartbeatManager().addDatanode(dataNodes[i]);
        }
        for (i = 0; i < 6; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[i], 10240L, 0L, 10240L, 0L, 0L, 0L, 0, 0);
        }
    }

    private static boolean isOnSameRack(DatanodeStorageInfo left, DatanodeStorageInfo right) {
        return TestReplicationPolicy.isOnSameRack(left, right.getDatanodeDescriptor());
    }

    private static boolean isOnSameRack(DatanodeStorageInfo left, DatanodeDescriptor right) {
        return cluster.isOnSameRack(left.getDatanodeDescriptor(), right);
    }

    @Test
    public void testChooseTarget1() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[0], 10240L, 0L, 5120L, 0L, 0L, 0L, 4, 0);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        targets = TestReplicationPolicy.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[2]));
        targets = TestReplicationPolicy.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        Assert.assertTrue((TestReplicationPolicy.isOnSameRack(targets[1], targets[2]) || TestReplicationPolicy.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[2]));
        TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[0], 10240L, 0L, 5120L, 0L, 0L, 0L, 0, 0);
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas) {
        return TestReplicationPolicy.chooseTarget(numOfReplicas, dataNodes[0]);
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer) {
        return TestReplicationPolicy.chooseTarget(numOfReplicas, writer, new ArrayList<DatanodeStorageInfo>());
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas, List<DatanodeStorageInfo> chosenNodes) {
        return TestReplicationPolicy.chooseTarget(numOfReplicas, dataNodes[0], chosenNodes);
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes) {
        return TestReplicationPolicy.chooseTarget(numOfReplicas, writer, chosenNodes, null);
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas, List<DatanodeStorageInfo> chosenNodes, Set<Node> excludedNodes) {
        return TestReplicationPolicy.chooseTarget(numOfReplicas, dataNodes[0], chosenNodes, excludedNodes);
    }

    private static DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, List<DatanodeStorageInfo> chosenNodes, Set<Node> excludedNodes) {
        return replicator.chooseTarget(filename, numOfReplicas, writer, chosenNodes, false, excludedNodes, 1024L, StorageType.DEFAULT);
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add(dataNodes[1]);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(1, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(2, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(3, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[2]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(dataNodes[1]);
        targets = TestReplicationPolicy.chooseTarget(4, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)storages[0], (Object)targets[0]);
        for (i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[i]));
        }
        Assert.assertTrue((TestReplicationPolicy.isOnSameRack(targets[1], targets[2]) || TestReplicationPolicy.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add(dataNodes[1]);
        chosenNodes.add(storages[2]);
        targets = replicator.chooseTarget(filename, 1, dataNodes[0], chosenNodes, true, excludedNodes, 1024L, StorageType.DEFAULT);
        System.out.println("targets=" + Arrays.asList(targets));
        Assert.assertEquals((long)2L, (long)targets.length);
        for (i = 0; i < targets.length && !storages[2].equals(targets[i]); ++i) {
        }
        Assert.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[0], 10240L, 0L, 4096L, 0L, 0L, 0L, 0, 0);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)storages[1], (Object)targets[0]);
        targets = TestReplicationPolicy.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)storages[1], (Object)targets[0]);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)storages[1], (Object)targets[0]);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)storages[1], (Object)targets[0]);
        for (int i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[i]));
        }
        Assert.assertTrue((TestReplicationPolicy.isOnSameRack(targets[1], targets[2]) || TestReplicationPolicy.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[3]));
        TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[0], 10240L, 0L, 5120L, 0L, 0L, 0L, 0, 0);
    }

    @Test
    public void testChoooseTarget4() throws Exception {
        int i;
        for (int i2 = 0; i2 < 2; ++i2) {
            TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[i2], 10240L, 0L, 4096L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        targets = TestReplicationPolicy.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[i], dataNodes[0]));
        }
        Assert.assertTrue((TestReplicationPolicy.isOnSameRack(targets[0], targets[1]) || TestReplicationPolicy.isOnSameRack(targets[1], targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[2]));
        for (i = 0; i < 2; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[i], 10240L, 0L, 5120L, 0L, 0L, 0L, 0, 0);
        }
    }

    @Test
    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor writerDesc = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r4");
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0, writerDesc);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1, writerDesc);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = TestReplicationPolicy.chooseTarget(2, writerDesc);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(3, writerDesc);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithMoreThanAvailableNodesWithStaleness() throws Exception {
        try {
            namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(6);
            this.testChooseTargetWithMoreThanAvailableNodes();
        }
        finally {
            namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(0);
        }
    }

    @Test
    public void testChooseTargetWithMoreThanAvailableNodes() throws Exception {
        for (int i = 0; i < 2; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[i], 10240L, 0L, 4096L, 0L, 0L, 0L, 0, 0);
        }
        LogVerificationAppender appender = new LogVerificationAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(6);
        Assert.assertEquals((long)targets.length, (long)4L);
        List<LoggingEvent> log = appender.getLog();
        Assert.assertNotNull(log);
        Assert.assertFalse((log.size() == 0 ? 1 : 0) != 0);
        LoggingEvent lastLogEntry = log.get(log.size() - 1);
        Assert.assertTrue((boolean)Level.WARN.isGreaterOrEqual((Priority)lastLogEntry.getLevel()));
        Assert.assertTrue((boolean)((String)lastLogEntry.getMessage()).contains("in need of 2"));
        for (int i = 0; i < 2; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(dataNodes[i], 10240L, 0L, 5120L, 0L, 0L, 0L, 0, 0);
        }
    }

    private boolean containsWithinRange(DatanodeStorageInfo target, DatanodeDescriptor[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].equals(target.getDatanodeDescriptor())) continue;
            return true;
        }
        return false;
    }

    private boolean containsWithinRange(DatanodeDescriptor target, DatanodeStorageInfo[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].getDatanodeDescriptor().equals(target)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testChooseTargetWithStaleNodes() throws Exception {
        dataNodes[0].setLastUpdate(Time.now() - 30000L - 1L);
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        Assert.assertTrue((boolean)namenode.getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)storages[1], (Object)targets[0]);
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add(dataNodes[1]);
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        targets = TestReplicationPolicy.chooseTarget(1, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        dataNodes[0].setLastUpdate(Time.now());
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    @Test
    public void testChooseTargetWithHalfStaleNodes() throws Exception {
        for (int i = 0; i < 3; ++i) {
            dataNodes[i].setLastUpdate(Time.now() - 30000L - 1L);
        }
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        targets = TestReplicationPolicy.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], dataNodes, 0, 2));
        Assert.assertFalse((boolean)this.containsWithinRange(targets[1], dataNodes, 0, 2));
        targets = TestReplicationPolicy.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.containsWithinRange(targets[0], dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[1], dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[2], dataNodes, 3, 5));
        targets = TestReplicationPolicy.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[3], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[4], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(dataNodes[5], targets, 0, 3));
        for (int i = 0; i < dataNodes.length; ++i) {
            dataNodes[i].setLastUpdate(Time.now());
        }
        namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithMoreThanHalfStaleNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6"};
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        MiniDFSCluster miniCluster = new MiniDFSCluster.Builder(conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).build();
        miniCluster.waitActive();
        try {
            DataNode dn;
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                DataNode dn2 = miniCluster.getDataNodes().get(i2);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn2, true);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn2.getDatanodeId()).setLastUpdate(Time.now() - 30000L - 1L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            int numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            DatanodeDescriptor staleNodeInfo = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(miniCluster.getDataNodes().get(0).getDatanodeId());
            BlockPlacementPolicy replicator = miniCluster.getNameNode().getNamesystem().getBlockManager().getBlockPlacementPolicy();
            DatanodeStorageInfo[] targets = replicator.chooseTarget(filename, 3, staleNodeInfo, new ArrayList<DatanodeStorageInfo>(), false, null, 1024L, StorageType.DEFAULT);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], staleNodeInfo));
            for (i = 0; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).setLastUpdate(Time.now() - 30000L - 1L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)4L);
            Assert.assertFalse((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = replicator.chooseTarget(filename, 3, staleNodeInfo, new ArrayList<DatanodeStorageInfo>(), false, null, 1024L, StorageType.DEFAULT);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], staleNodeInfo));
            for (i = 2; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
                miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId()).setLastUpdate(Time.now());
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = TestReplicationPolicy.chooseTarget(3, staleNodeInfo);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], staleNodeInfo));
        }
        finally {
            miniCluster.shutdown();
        }
    }

    @Test
    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(storages[0]);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        targets = TestReplicationPolicy.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[1]));
        targets = TestReplicationPolicy.chooseTarget(3, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(storages[0]);
        chosenNodes.add(storages[1]);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        targets = TestReplicationPolicy.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[1], dataNodes[0]));
    }

    @Test
    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(storages[0]);
        chosenNodes.add(storages[2]);
        DatanodeStorageInfo[] targets = TestReplicationPolicy.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = TestReplicationPolicy.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[2]));
        targets = TestReplicationPolicy.chooseTarget(1, dataNodes[2], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[2]));
        Assert.assertFalse((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        targets = TestReplicationPolicy.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[0]));
        targets = TestReplicationPolicy.chooseTarget(2, dataNodes[2], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)TestReplicationPolicy.isOnSameRack(targets[0], dataNodes[2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReplicationWithPriority() throws Exception {
        int DFS_NAMENODE_REPLICATION_INTERVAL = 1000;
        int HIGH_PRIORITY = 0;
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.replication.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).build();
        try {
            cluster.waitActive();
            UnderReplicatedBlocks neededReplications = cluster.getNameNode().getNamesystem().getBlockManager().neededReplications;
            for (int i = 0; i < 100; ++i) {
                neededReplications.add(new Block(this.random.nextLong()), 2, 0, 3);
            }
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            neededReplications.add(new Block(this.random.nextLong()), 1, 0, 3);
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            Assert.assertFalse((String)"Not able to clear the element from high priority list", (boolean)neededReplications.iterator(HIGH_PRIORITY).hasNext());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseUnderReplicatedBlocks() throws Exception {
        UnderReplicatedBlocks underReplicatedBlocks = new UnderReplicatedBlocks();
        for (int i = 0; i < 5; ++i) {
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 2, 0, 7);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 6, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 5, 0, 6);
            underReplicatedBlocks.add(new Block(this.random.nextLong()), 0, 0, 3);
        }
        List<List<Block>> chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(6);
        this.assertTheChosenBlocks(chosenBlocks, 5, 1, 0, 0, 0);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 0, 4, 5, 1, 0);
        underReplicatedBlocks.add(new Block(this.random.nextLong()), 1, 0, 3);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 4, 5);
        chosenBlocks = underReplicatedBlocks.chooseUnderReplicatedBlocks(7);
        this.assertTheChosenBlocks(chosenBlocks, 6, 1, 0, 0, 0);
    }

    private void assertTheChosenBlocks(List<List<Block>> chosenBlocks, int firstPrioritySize, int secondPrioritySize, int thirdPrioritySize, int fourthPrioritySize, int fifthPrioritySize) {
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_HIGHEST_PRIORITY blocks", (long)firstPrioritySize, (long)chosenBlocks.get(0).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_VERY_UNDER_REPLICATED blocks", (long)secondPrioritySize, (long)chosenBlocks.get(1).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_UNDER_REPLICATED blocks", (long)thirdPrioritySize, (long)chosenBlocks.get(2).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_REPLICAS_BADLY_DISTRIBUTED blocks", (long)fourthPrioritySize, (long)chosenBlocks.get(3).size());
        Assert.assertEquals((String)"Not returned the expected number of QUEUE_WITH_CORRUPT_BLOCKS blocks", (long)fifthPrioritySize, (long)chosenBlocks.get(4).size());
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.5f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)0.5, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.0f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)1.0, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.0f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_NegativeValue() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "-0.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_GreaterThanOne() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
    }

    @Test
    public void testGetReplWorkMultiplier() {
        Configuration conf = new Configuration();
        int blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        Assert.assertTrue((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "3");
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        Assert.assertEquals((long)blocksReplWorkMultiplier, (long)3L);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "-1");
        this.exception.expect(IllegalArgumentException.class);
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeDescriptor> replicaNodeList = new ArrayList<DatanodeDescriptor>();
        HashMap<String, List<DatanodeDescriptor>> rackMap = new HashMap<String, List<DatanodeDescriptor>>();
        dataNodes[0].setRemaining(0x400000L);
        replicaNodeList.add(dataNodes[0]);
        dataNodes[1].setRemaining(0x300000L);
        replicaNodeList.add(dataNodes[1]);
        dataNodes[2].setRemaining(0x200000L);
        replicaNodeList.add(dataNodes[2]);
        dataNodes[5].setRemaining(0x100000L);
        replicaNodeList.add(dataNodes[5]);
        ArrayList<DatanodeDescriptor> first = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> second = new ArrayList<DatanodeDescriptor>();
        replicator.splitNodesWithRack(replicaNodeList, rackMap, first, second);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        DatanodeDescriptor chosenNode = replicator.chooseReplicaToDelete(null, null, (short)3, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[1]);
        replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosenNode);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)3L, (long)second.size());
        chosenNode = replicator.chooseReplicaToDelete(null, null, (short)2, first, second);
        Assert.assertEquals((Object)chosenNode, (Object)dataNodes[5]);
    }
}

