/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetFactory;
import org.apache.hadoop.util.DataChecksum;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSimulatedFSDataset {
    Configuration conf = null;
    static final String bpid = "BP-TEST";
    static final int NUMBLOCKS = 20;
    static final int BLOCK_LENGTH_MULTIPLIER = 79;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory(this.conf);
    }

    long blockIdToLen(long blkid) {
        return blkid * 79L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addSomeBlocks(SimulatedFSDataset fsdataset, int startingBlockId) throws IOException {
        int bytesAdded = 0;
        for (int i = startingBlockId; i < startingBlockId + 20; ++i) {
            ExtendedBlock b = new ExtendedBlock(bpid, i, 0L, 0L);
            ReplicaInPipelineInterface bInfo = fsdataset.createRbw(b);
            ReplicaOutputStreams out = bInfo.createStreams(true, DataChecksum.newDataChecksum(DataChecksum.Type.CRC32, 512));
            try {
                OutputStream dataOut = out.getDataOut();
                Assert.assertEquals((long)0L, (long)fsdataset.getLength(b));
                int j = 1;
                while ((long)j <= this.blockIdToLen(i)) {
                    dataOut.write(j);
                    Assert.assertEquals((long)j, (long)bInfo.getBytesOnDisk());
                    ++bytesAdded;
                    ++j;
                }
            }
            finally {
                out.close();
            }
            b.setNumBytes(this.blockIdToLen(i));
            fsdataset.finalizeBlock(b);
            Assert.assertEquals((long)this.blockIdToLen(i), (long)fsdataset.getLength(b));
        }
        return bytesAdded;
    }

    int addSomeBlocks(SimulatedFSDataset fsdataset) throws IOException {
        return this.addSomeBlocks(fsdataset, 1);
    }

    @Test
    public void testFSDatasetFactory() {
        Configuration conf = new Configuration();
        FsDatasetSpi.Factory<?> f = FsDatasetSpi.Factory.getFactory(conf);
        Assert.assertEquals(FsDatasetFactory.class, f.getClass());
        Assert.assertFalse((boolean)f.isSimulated());
        SimulatedFSDataset.setFactory(conf);
        FsDatasetSpi.Factory<?> s = FsDatasetSpi.Factory.getFactory(conf);
        Assert.assertEquals(SimulatedFSDataset.Factory.class, s.getClass());
        Assert.assertTrue((boolean)s.isSimulated());
    }

    @Test
    public void testGetMetaData() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        try {
            Assert.assertTrue((fsdataset.getMetaDataInputStream(b) == null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 1L, 0L, 0L);
        LengthInputStream metaInput = fsdataset.getMetaDataInputStream(b);
        DataInputStream metaDataInput = new DataInputStream(metaInput);
        short version = metaDataInput.readShort();
        Assert.assertEquals((long)1L, (long)version);
        DataChecksum checksum = DataChecksum.newDataChecksum(metaDataInput);
        Assert.assertEquals((Object)((Object)DataChecksum.Type.NULL), (Object)((Object)checksum.getChecksumType()));
        Assert.assertEquals((long)0L, (long)checksum.getChecksumSize());
    }

    @Test
    public void testStorageUsage() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        Assert.assertEquals((long)fsdataset.getDfsUsed(), (long)0L);
        Assert.assertEquals((long)fsdataset.getRemaining(), (long)fsdataset.getCapacity());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        Assert.assertEquals((long)bytesAdded, (long)fsdataset.getDfsUsed());
        Assert.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded), (long)fsdataset.getRemaining());
    }

    void checkBlockDataAndSize(SimulatedFSDataset fsdataset, ExtendedBlock b, long expectedLen) throws IOException {
        int data;
        InputStream input = fsdataset.getBlockInputStream(b);
        long lengthRead = 0L;
        while ((data = input.read()) != -1) {
            Assert.assertEquals((long)9L, (long)data);
            ++lengthRead;
        }
        Assert.assertEquals((long)expectedLen, (long)lengthRead);
    }

    @Test
    public void testWriteRead() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        this.addSomeBlocks(fsdataset);
        for (int i = 1; i <= 20; ++i) {
            ExtendedBlock b = new ExtendedBlock(bpid, i, 0L, 0L);
            Assert.assertTrue((boolean)fsdataset.isValidBlock(b));
            Assert.assertEquals((long)this.blockIdToLen(i), (long)fsdataset.getLength(b));
            this.checkBlockDataAndSize(fsdataset, b, this.blockIdToLen(i));
        }
    }

    @Test
    public void testGetBlockReport() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)0L, (long)blockReport.getNumberOfBlocks());
        this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
    }

    @Test
    public void testInjectionEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)0L, (long)blockReport.getNumberOfBlocks());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        sfsdataset.injectBlocks(bpid, blockReport);
        blockReport = sfsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)sfsdataset.getLength(new ExtendedBlock(bpid, b)));
        }
        Assert.assertEquals((long)bytesAdded, (long)sfsdataset.getDfsUsed());
        Assert.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
    }

    @Test
    public void testInjectionNonEmpty() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        BlockListAsLongs blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)0L, (long)blockReport.getNumberOfBlocks());
        int bytesAdded = this.addSomeBlocks(fsdataset);
        blockReport = fsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
        }
        fsdataset = null;
        SimulatedFSDataset sfsdataset = this.getSimulatedFSDataset();
        bytesAdded += this.addSomeBlocks(sfsdataset, 21);
        sfsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        sfsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)20L, (long)blockReport.getNumberOfBlocks());
        sfsdataset.injectBlocks(bpid, blockReport);
        blockReport = sfsdataset.getBlockReport(bpid);
        Assert.assertEquals((long)40L, (long)blockReport.getNumberOfBlocks());
        for (Block b : blockReport) {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)b.getNumBytes());
            Assert.assertEquals((long)this.blockIdToLen(b.getBlockId()), (long)sfsdataset.getLength(new ExtendedBlock(bpid, b)));
        }
        Assert.assertEquals((long)bytesAdded, (long)sfsdataset.getDfsUsed());
        Assert.assertEquals((long)(sfsdataset.getCapacity() - (long)bytesAdded), (long)sfsdataset.getRemaining());
        this.conf.setLong("dfs.datanode.simulateddatastorage.capacity", 10L);
        try {
            sfsdataset = this.getSimulatedFSDataset();
            sfsdataset.addBlockPool(bpid, this.conf);
            sfsdataset.injectBlocks(bpid, blockReport);
            Assert.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void checkInvalidBlock(ExtendedBlock b) {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        Assert.assertFalse((boolean)fsdataset.isValidBlock(b));
        try {
            fsdataset.getLength(b);
            Assert.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            fsdataset.getBlockInputStream(b);
            Assert.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            fsdataset.finalizeBlock(b);
            Assert.assertTrue((String)"Expected an IO exception", (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInValidBlocks() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        ExtendedBlock b = new ExtendedBlock(bpid, 1L, 5L, 0L);
        this.checkInvalidBlock(b);
        this.addSomeBlocks(fsdataset);
        b = new ExtendedBlock(bpid, 119L, 5L, 0L);
        this.checkInvalidBlock(b);
    }

    @Test
    public void testInvalidate() throws IOException {
        SimulatedFSDataset fsdataset = this.getSimulatedFSDataset();
        int bytesAdded = this.addSomeBlocks(fsdataset);
        Block[] deleteBlocks = new Block[]{new Block(1L, 0L, 0L), new Block(2L, 0L, 0L)};
        fsdataset.invalidate(bpid, deleteBlocks);
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[0]));
        this.checkInvalidBlock(new ExtendedBlock(bpid, deleteBlocks[1]));
        long sizeDeleted = this.blockIdToLen(1L) + this.blockIdToLen(2L);
        Assert.assertEquals((long)((long)bytesAdded - sizeDeleted), (long)fsdataset.getDfsUsed());
        Assert.assertEquals((long)(fsdataset.getCapacity() - (long)bytesAdded + sizeDeleted), (long)fsdataset.getRemaining());
        for (int i = 3; i <= 20; ++i) {
            Block b = new Block(i, 0L, 0L);
            Assert.assertTrue((boolean)fsdataset.isValidBlock(new ExtendedBlock(bpid, b)));
        }
    }

    private SimulatedFSDataset getSimulatedFSDataset() {
        SimulatedFSDataset fsdataset = new SimulatedFSDataset(null, this.conf);
        fsdataset.addBlockPool(bpid, this.conf);
        return fsdataset;
    }
}

