/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizedReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            String TopDir = "/test";
            DFSTestUtil util = new DFSTestUtil.Builder().setName("TestDatanodeRestart").setNumFiles(2).build();
            util.createFiles(fs, "/test", (short)3);
            util.waitReplication(fs, "/test", (short)3);
            util.checkFiles(fs, "/test");
            cluster.restartDataNodes();
            cluster.waitActive();
            util.checkFiles(fs, "/test");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRbwReplicas() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            this.testRbwReplicas(cluster, false);
            this.testRbwReplicas(cluster, true);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRbwReplicas(MiniDFSCluster cluster, boolean isCorrupt) throws IOException {
        FSDataOutputStream out = null;
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src = new Path("/test.txt");
        try {
            int fileLen = 515;
            byte[] writeBuf = new byte[515];
            new Random().nextBytes(writeBuf);
            out = fs.create(src);
            out.write(writeBuf);
            out.hflush();
            DataNode dn = cluster.getDataNodes().get(0);
            Iterator<FsVolumeImpl> i$ = TestDatanodeRestart.dataset(dn).getVolumes().iterator();
            while (i$.hasNext()) {
                FsVolumeImpl v;
                FsVolumeImpl volume = v = i$.next();
                File currentDir = volume.getCurrentDir().getParentFile().getParentFile();
                File rbwDir = new File(currentDir, "rbw");
                for (File file : rbwDir.listFiles()) {
                    if (!isCorrupt || !Block.isBlockFilename(file)) continue;
                    new RandomAccessFile(file, "rw").setLength(514L);
                }
            }
            cluster.restartDataNodes();
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ReplicaMap replicas = TestDatanodeRestart.dataset((DataNode)dn).volumeMap;
            Assert.assertEquals((long)1L, (long)replicas.size(bpid));
            ReplicaInfo replica = replicas.replicas(bpid).iterator().next();
            Assert.assertEquals((Object)((Object)HdfsServerConstants.ReplicaState.RWR), (Object)((Object)replica.getState()));
            if (isCorrupt) {
                Assert.assertEquals((long)512L, (long)replica.getNumBytes());
            } else {
                Assert.assertEquals((long)515L, (long)replica.getNumBytes());
            }
            TestDatanodeRestart.dataset(dn).invalidate(bpid, new Block[]{replica});
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            if (fs.exists(src)) {
                ((FileSystem)fs).delete(src, false);
            }
            ((FileSystem)fs).close();
            throw throwable;
        }
        IOUtils.closeStream(out);
        if (fs.exists(src)) {
            ((FileSystem)fs).delete(src, false);
        }
        ((FileSystem)fs).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecoverReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            for (int i = 0; i < 4; ++i) {
                Path fileName = new Path("/test" + i);
                DFSTestUtil.createFile(fs, fileName, 1L, (short)1, 0L);
                DFSTestUtil.waitReplication(fs, fileName, (short)1);
            }
            String bpid = cluster.getNamesystem().getBlockPoolId();
            DataNode dn = cluster.getDataNodes().get(0);
            Iterator<ReplicaInfo> replicasItor = TestDatanodeRestart.dataset((DataNode)dn).volumeMap.replicas(bpid).iterator();
            ReplicaInfo replica = replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, true);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, true);
            replica = replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, false);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, false);
            replica = replicasItor.next();
            TestDatanodeRestart.createUnlinkTmpFile(replica, true, true);
            TestDatanodeRestart.createUnlinkTmpFile(replica, false, false);
            cluster.restartDataNodes();
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            Collection<ReplicaInfo> replicas = TestDatanodeRestart.dataset((DataNode)dn).volumeMap.replicas(bpid);
            Assert.assertEquals((long)4L, (long)replicas.size());
            replicasItor = replicas.iterator();
            while (replicasItor.hasNext()) {
                Assert.assertEquals((Object)((Object)HdfsServerConstants.ReplicaState.FINALIZED), (Object)((Object)replicasItor.next().getState()));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private static FsDatasetImpl dataset(DataNode dn) {
        return (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createUnlinkTmpFile(ReplicaInfo replicaInfo, boolean changeBlockFile, boolean isRename) throws IOException {
        File src = changeBlockFile ? replicaInfo.getBlockFile() : replicaInfo.getMetaFile();
        File dst = DatanodeUtil.getUnlinkTmpFile(src);
        if (isRename) {
            src.renameTo(dst);
        } else {
            FileInputStream in = new FileInputStream(src);
            try {
                FileOutputStream out = new FileOutputStream(dst);
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, 1);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

