/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDeleteRace {
    private static final Log LOG = LogFactory.getLog(TestDeleteRace.class);
    private static final Configuration conf = new HdfsConfiguration();
    private MiniDFSCluster cluster;

    @Test
    public void testDeleteAddBlockRace() throws Exception {
        this.testDeleteAddBlockRace(false);
    }

    @Test
    public void testDeleteAddBlockRaceWithSnapshot() throws Exception {
        this.testDeleteAddBlockRace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAddBlockRace(boolean hasSnapshot) throws Exception {
        try {
            conf.setClass("dfs.block.replicator.classname", SlowBlockPlacementPolicy.class, BlockPlacementPolicy.class);
            this.cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            String fileName = "/testDeleteAddBlockRace";
            Path filePath = new Path("/testDeleteAddBlockRace");
            FSDataOutputStream out = null;
            out = fs.create(filePath);
            if (hasSnapshot) {
                SnapshotTestHelper.createSnapshot(fs, new Path("/"), "s1");
            }
            DeleteThread deleteThread = new DeleteThread(fs, filePath);
            deleteThread.start();
            try {
                out.write(new byte[32], 0, 32);
                out.hsync();
                Assert.fail((String)"Should have failed.");
            }
            catch (Exception e) {
                GenericTestUtils.assertExceptionContains(filePath.getName(), e);
            }
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    private class DeleteThread
    extends Thread {
        private FileSystem fs;
        private Path path;

        DeleteThread(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                LOG.info((Object)("Deleting" + this.path));
                FSDirectory fsdir = ((TestDeleteRace)TestDeleteRace.this).cluster.getNamesystem().dir;
                INode fileINode = fsdir.getINode4Write(this.path.toString());
                INodeMap inodeMap = (INodeMap)Whitebox.getInternalState((Object)fsdir, (String)"inodeMap");
                this.fs.delete(this.path, false);
                inodeMap.put(fileINode);
                LOG.info((Object)("Deleted" + this.path));
            }
            catch (Exception e) {
                LOG.info((Object)e);
            }
        }
    }

    private static class SlowBlockPlacementPolicy
    extends BlockPlacementPolicyDefault {
        private SlowBlockPlacementPolicy() {
        }

        @Override
        public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, StorageType storageType) {
            DatanodeStorageInfo[] results = super.chooseTarget(srcPath, numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storageType);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return results;
        }
    }
}

