/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFSImageWithAcl {
    private static Configuration conf;
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void setUp() throws IOException {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    private void testAcl(boolean persistNamespace) throws IOException {
        Path p = new Path("/p");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.create(p).close();
        fs.mkdirs(new Path("/23"));
        AclEntry e = new AclEntry.Builder().setName("foo").setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).build();
        fs.modifyAclEntries(p, Lists.newArrayList(e));
        this.restart(fs, persistNamespace);
        AclStatus s = cluster.getNamesystem().getAclStatus(p.toString());
        Object[] returned = Lists.newArrayList(s.getEntries()).toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
        fs.removeAcl(p);
        if (persistNamespace) {
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
        s = cluster.getNamesystem().getAclStatus(p.toString());
        returned = Lists.newArrayList(s.getEntries()).toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        fs.modifyAclEntries(p, Lists.newArrayList(e));
        s = cluster.getNamesystem().getAclStatus(p.toString());
        returned = Lists.newArrayList(s.getEntries()).toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)}, (Object[])returned);
    }

    @Test
    public void testPersistAcl() throws IOException {
        this.testAcl(true);
    }

    @Test
    public void testAclEditLog() throws IOException {
        this.testAcl(false);
    }

    private void doTestDefaultAclNewChildren(boolean persistNamespace) throws IOException {
        Path dirPath = new Path("/dir");
        Path filePath = new Path(dirPath, "file1");
        Path subdirPath = new Path(dirPath, "subdir1");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.mkdirs(dirPath);
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL));
        fs.setAcl(dirPath, aclSpec);
        fs.create(filePath).close();
        fs.mkdirs(subdirPath);
        Object[] fileExpected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        Object[] subdirExpected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE)};
        Object[] fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        Object[] subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
        this.restart(fs, persistNamespace);
        fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
        aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_WRITE));
        fs.modifyAclEntries(dirPath, aclSpec);
        fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
        this.restart(fs, persistNamespace);
        fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
        fs.removeAcl(dirPath);
        fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
        this.restart(fs, persistNamespace);
        fileReturned = fs.getAclStatus(filePath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])fileExpected, (Object[])fileReturned);
        subdirReturned = fs.getAclStatus(subdirPath).getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])subdirExpected, (Object[])subdirReturned);
        AclTestHelpers.assertPermission(fs, subdirPath, (short)4589);
    }

    @Test
    public void testFsImageDefaultAclNewChildren() throws IOException {
        this.doTestDefaultAclNewChildren(true);
    }

    @Test
    public void testEditLogDefaultAclNewChildren() throws IOException {
        this.doTestDefaultAclNewChildren(false);
    }

    private void restart(DistributedFileSystem fs, boolean persistNamespace) throws IOException {
        if (persistNamespace) {
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
    }
}

