/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSPermissionChecker {
    private static final long PREFERRED_BLOCK_SIZE = 0x8000000L;
    private static final short REPLICATION = 3;
    private static final String SUPERGROUP = "supergroup";
    private static final String SUPERUSER = "superuser";
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting("bruce", new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting("diana", new String[]{"sales"});
    private static final UserGroupInformation CLARK = UserGroupInformation.createUserForTesting("clark", new String[]{"execs"});
    private INodeDirectory inodeRoot;

    @Before
    public void setUp() {
        PermissionStatus permStatus = PermissionStatus.createImmutable(SUPERUSER, SUPERGROUP, FsPermission.createImmutable((short)493));
        this.inodeRoot = new INodeDirectory(16385L, INodeDirectory.ROOT_NAME, permStatus, 0L);
    }

    @Test
    public void testAclOwner() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)416);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ);
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.WRITE);
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(BRUCE, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
    }

    @Test
    public void testAclNamedUser() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)416);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedUserDeny() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
    }

    @Test
    public void testAclNamedUserTraverseDeny() throws IOException {
        INodeDirectory inodeDir = TestFSPermissionChecker.createINodeDirectory(this.inodeRoot, "dir1", "bruce", "execs", (short)493);
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(inodeDir, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeDir, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedUserMask() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)400);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroup() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)416);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupDeny() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "sales", (short)388);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupTraverseDeny() throws IOException {
        INodeDirectory inodeDir = TestFSPermissionChecker.createINodeDirectory(this.inodeRoot, "dir1", "bruce", "execs", (short)493);
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(inodeDir, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeDir, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupTraverseDenyOnlyDefaultEntries() throws IOException {
        INodeDirectory inodeDir = TestFSPermissionChecker.createINodeDirectory(this.inodeRoot, "dir1", "bruce", "execs", (short)493);
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(inodeDir, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeDir, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "sales", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclGroupMask() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroup() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)416);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupDeny() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "sales", (short)420);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "execs", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupTraverseDeny() throws IOException {
        INodeDirectory inodeDir = TestFSPermissionChecker.createINodeDirectory(this.inodeRoot, "dir1", "bruce", "execs", (short)493);
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(inodeDir, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeDir, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        this.assertPermissionGranted(BRUCE, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/dir1/file1", FsAction.ALL);
    }

    @Test
    public void testAclNamedGroupMask() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "execs", (short)420);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "sales", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.READ_WRITE);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.READ);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(DIANA, "/file1", FsAction.ALL);
    }

    @Test
    public void testAclOther() throws IOException {
        INodeFile inodeFile = TestFSPermissionChecker.createINodeFile(this.inodeRoot, "file1", "bruce", "sales", (short)508);
        this.addAcl(inodeFile, AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ));
        this.assertPermissionGranted(BRUCE, "/file1", FsAction.ALL);
        this.assertPermissionGranted(DIANA, "/file1", FsAction.ALL);
        this.assertPermissionGranted(CLARK, "/file1", FsAction.READ);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_WRITE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.READ_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.WRITE_EXECUTE);
        this.assertPermissionDenied(CLARK, "/file1", FsAction.ALL);
    }

    private void addAcl(INodeWithAdditionalFields inode, AclEntry ... acl) throws IOException {
        AclStorage.updateINodeAcl(inode, Arrays.asList(acl), 0x7FFFFFFE);
    }

    private void assertPermissionGranted(UserGroupInformation user, String path, FsAction access) throws IOException {
        new FSPermissionChecker(SUPERUSER, SUPERGROUP, user).checkPermission(path, this.inodeRoot, false, null, null, access, null, true);
    }

    private void assertPermissionDenied(UserGroupInformation user, String path, FsAction access) throws IOException {
        try {
            new FSPermissionChecker(SUPERUSER, SUPERGROUP, user).checkPermission(path, this.inodeRoot, false, null, null, access, null, true);
            Assert.fail((String)("expected AccessControlException for user + " + user + ", path = " + path + ", access = " + (Object)((Object)access)));
        }
        catch (AccessControlException e) {
            // empty catch block
        }
    }

    private static INodeDirectory createINodeDirectory(INodeDirectory parent, String name, String owner, String group, short perm) throws IOException {
        PermissionStatus permStatus = PermissionStatus.createImmutable(owner, group, FsPermission.createImmutable(perm));
        INodeDirectory inodeDirectory = new INodeDirectory(0L, name.getBytes("UTF-8"), permStatus, 0L);
        parent.addChild(inodeDirectory);
        return inodeDirectory;
    }

    private static INodeFile createINodeFile(INodeDirectory parent, String name, String owner, String group, short perm) throws IOException {
        PermissionStatus permStatus = PermissionStatus.createImmutable(owner, group, FsPermission.createImmutable(perm));
        INodeFile inodeFile = new INodeFile(0L, name.getBytes("UTF-8"), permStatus, 0L, 0L, null, 3, 0x8000000L);
        parent.addChild(inodeFile);
        return inodeFile;
    }
}

