/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileJournalManager {
    static final Log LOG = LogFactory.getLog(TestFileJournalManager.class);
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = new Configuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getNumberOfTransactions(FileJournalManager jm, long fromTxId, boolean inProgressOk, boolean abortOnGap) throws IOException {
        numTransactions = 0L;
        txId = fromTxId;
        allStreams = new PriorityQueue<EditLogInputStream>(64, JournalSet.EDIT_LOG_INPUT_STREAM_COMPARATOR);
        jm.selectInputStreams(allStreams, fromTxId, inProgressOk);
        elis = null;
        try {
            while ((elis = allStreams.poll()) != null) {
                block11: {
                    block10: {
                        try {
                            elis.skipUntil(txId);
lbl11:
                            // 2 sources

                            while ((op = elis.readOp()) != null) {
                                if (abortOnGap && op.getTransactionId() != txId) {
                                    TestFileJournalManager.LOG.info((Object)("getNumberOfTransactions: detected gap at txId " + fromTxId));
                                    var12_9 = numTransactions;
                                    break block10;
                                }
                                ** GOTO lbl-1000
                            }
                            break block11;
                        }
                        catch (Throwable var14_10) {
                            IOUtils.cleanup(TestFileJournalManager.LOG, new Closeable[]{elis});
                            throw var14_10;
                        }
                    }
                    IOUtils.cleanup(TestFileJournalManager.LOG, new Closeable[]{elis});
                    return var12_9;
lbl-1000:
                    // 1 sources

                    {
                        txId = op.getTransactionId() + 1L;
                        ++numTransactions;
                        ** GOTO lbl11
                    }
                }
                IOUtils.cleanup(TestFileJournalManager.LOG, new Closeable[]{elis});
            }
            return numTransactions;
        }
        finally {
            IOUtils.cleanup(TestFileJournalManager.LOG, allStreams.toArray(new EditLogInputStream[0]));
        }
    }

    @Test
    public void testNormalOperation() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/normtest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/normtest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/normtest2");
        ImmutableList<URI> editUris = ImmutableList.of(f1.toURI(), f2.toURI(), f3.toURI());
        NNStorage storage = TestEditLog.setupEdits(editUris, 5, new TestEditLog.AbortSpec[0]);
        long numJournals = 0L;
        for (Storage.StorageDirectory sd : storage.dirIterable(NNStorage.NameNodeDirType.EDITS)) {
            FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
            Assert.assertEquals((long)60L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
            ++numJournals;
        }
        Assert.assertEquals((long)3L, (long)numJournals);
    }

    @Test
    public void testInprogressRecovery() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/inprogressrecovery");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 5, new TestEditLog.AbortSpec(5, 0));
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)52L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
    }

    @Test
    public void testInprogressRecoveryMixed() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/mixtest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/mixtest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/mixtest2");
        ImmutableList<URI> editUris = ImmutableList.of(f1.toURI(), f2.toURI(), f3.toURI());
        NNStorage storage = TestEditLog.setupEdits(editUris, 5, new TestEditLog.AbortSpec(5, 1));
        Iterator<Storage.StorageDirectory> dirs = storage.dirIterator(NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = dirs.next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)60L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
        sd = dirs.next();
        jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)52L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
        sd = dirs.next();
        jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)60L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
    }

    @Test
    public void testInprogressRecoveryAll() throws IOException {
        File f1 = new File(TestEditLog.TEST_DIR + "/failalltest0");
        File f2 = new File(TestEditLog.TEST_DIR + "/failalltest1");
        File f3 = new File(TestEditLog.TEST_DIR + "/failalltest2");
        ImmutableList<URI> editUris = ImmutableList.of(f1.toURI(), f2.toURI(), f3.toURI());
        NNStorage storage = TestEditLog.setupEdits(editUris, 5, new TestEditLog.AbortSpec(5, 0), new TestEditLog.AbortSpec(5, 1), new TestEditLog.AbortSpec(5, 2));
        Iterator<Storage.StorageDirectory> dirs = storage.dirIterator(NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = dirs.next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)52L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
        sd = dirs.next();
        jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)52L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
        sd = dirs.next();
        jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)52L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
    }

    private void corruptAfterStartSegment(File f) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        raf.seek(32L);
        for (int i = 0; i < 1000; ++i) {
            raf.writeInt(-559038737);
        }
        raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testFinalizeErrorReportedToNNStorage() throws IOException, InterruptedException {
        File f = new File(TestEditLog.TEST_DIR + "/filejournaltestError");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec(10, 0));
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        String sdRootPath = sd.getRoot().getAbsolutePath();
        FileUtil.chmod(sdRootPath, "-w", true);
        try {
            jm.finalizeLogSegment(0L, 1L);
        }
        finally {
            FileUtil.chmod(sdRootPath, "+w", true);
            Assert.assertTrue((boolean)storage.getRemovedStorageDirs().contains(sd));
        }
    }

    @Test
    public void testReadFromStream() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/readfromstream");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec(10, 0));
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        long expectedTotalTxnCount = 102L;
        Assert.assertEquals((long)expectedTotalTxnCount, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
        long skippedTxns = 30L;
        long startingTxId = skippedTxns + 1L;
        long numLoadable = TestFileJournalManager.getNumberOfTransactions(jm, startingTxId, true, false);
        Assert.assertEquals((long)(expectedTotalTxnCount - skippedTxns), (long)numLoadable);
    }

    @Test
    public void testAskForTransactionsMidfile() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/askfortransactionsmidfile");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        int TOTAL_TXIDS = 110;
        for (int txid = 1; txid <= 110; ++txid) {
            Assert.assertEquals((long)(110 - txid + 1), (long)TestFileJournalManager.getNumberOfTransactions(jm, txid, true, false));
        }
    }

    @Test
    public void testManyLogsWithGaps() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/manylogswithgaps");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        long startGapTxId = 31L;
        long endGapTxId = 40L;
        File[] files = new File(f, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName(31L, 40L));
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertTrue((boolean)files[0].delete());
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)30L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, true));
        Assert.assertEquals((long)0L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 31L, true, true));
        Assert.assertEquals((long)70L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 41L, true, true));
    }

    @Test
    public void testManyLogsWithCorruptInprogress() throws IOException {
        File f = new File(TestEditLog.TEST_DIR + "/manylogswithcorruptinprogress");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec(10, 0));
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        File[] files = new File(f, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("edits_inprogress");
            }
        });
        Assert.assertEquals((long)files.length, (long)1L);
        this.corruptAfterStartSegment(files[0]);
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)101L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, true, false));
    }

    @Test
    public void testGetRemoteEditLog() throws IOException {
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory(NNStorage.NameNodeDirType.EDITS, false, NNStorage.getFinalizedEditsFileName(1L, 100L), NNStorage.getFinalizedEditsFileName(101L, 200L), NNStorage.getInProgressEditsFileName(201L), NNStorage.getFinalizedEditsFileName(1001L, 1100L));
        FileJournalManager fjm = new FileJournalManager(this.conf, sd, null);
        Assert.assertEquals((Object)"[1,100],[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 1L));
        Assert.assertEquals((Object)"[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 101L));
        Assert.assertEquals((Object)"[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 150L));
        Assert.assertEquals((Object)"[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 201L));
        Assert.assertEquals((String)"Asking for a newer log than exists should return empty list", (Object)"", (Object)TestFileJournalManager.getLogsAsString(fjm, 9999L));
    }

    @Test(expected=IOException.class)
    public void testMatchEditLogInvalidDirThrowsIOException() throws IOException {
        File badDir = new File("does not exist");
        FileJournalManager.matchEditLogs(badDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditLogInputStream getJournalInputStream(JournalManager jm, long txId, boolean inProgressOk) throws IOException {
        EditLogInputStream editLogInputStream;
        PriorityQueue<EditLogInputStream> allStreams = new PriorityQueue<EditLogInputStream>(64, JournalSet.EDIT_LOG_INPUT_STREAM_COMPARATOR);
        jm.selectInputStreams(allStreams, txId, inProgressOk);
        EditLogInputStream elis = null;
        try {
            while ((elis = allStreams.poll()) != null && elis.getFirstTxId() <= txId) {
                if (elis.getLastTxId() < txId) {
                    elis.close();
                    continue;
                }
                elis.skipUntil(txId);
                EditLogInputStream ret = elis;
                elis = null;
                editLogInputStream = ret;
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, allStreams.toArray(new EditLogInputStream[0]));
            IOUtils.cleanup(LOG, elis);
            throw throwable;
        }
        {
            IOUtils.cleanup(LOG, allStreams.toArray(new EditLogInputStream[0]));
            IOUtils.cleanup(LOG, elis);
            return editLogInputStream;
        }
        IOUtils.cleanup(LOG, allStreams.toArray(new EditLogInputStream[0]));
        IOUtils.cleanup(LOG, elis);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFromMiddleOfEditLog() throws JournalManager.CorruptionException, IOException {
        File f = new File(TestEditLog.TEST_DIR + "/readfrommiddleofeditlog");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        EditLogInputStream elis = TestFileJournalManager.getJournalInputStream(jm, 5L, true);
        try {
            FSEditLogOp op = elis.readOp();
            Assert.assertEquals((String)"read unexpected op", (long)op.getTransactionId(), (long)5L);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, elis);
            throw throwable;
        }
        IOUtils.cleanup(LOG, elis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeInProgressStreams() throws JournalManager.CorruptionException, IOException {
        File f = new File(TestEditLog.TEST_DIR + "/excludeinprogressstreams");
        NNStorage storage = TestEditLog.setupEdits(Collections.singletonList(f.toURI()), 10, false, new TestEditLog.AbortSpec[0]);
        Storage.StorageDirectory sd = storage.dirIterator(NNStorage.NameNodeDirType.EDITS).next();
        FileJournalManager jm = new FileJournalManager(this.conf, sd, storage);
        Assert.assertEquals((long)100L, (long)TestFileJournalManager.getNumberOfTransactions(jm, 1L, false, false));
        EditLogInputStream elis = TestFileJournalManager.getJournalInputStream(jm, 90L, false);
        try {
            FSEditLogOp lastReadOp = null;
            while ((lastReadOp = elis.readOp()) != null) {
                Assert.assertTrue((lastReadOp.getTransactionId() <= 100L ? 1 : 0) != 0);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, elis);
            throw throwable;
        }
        IOUtils.cleanup(LOG, elis);
    }

    private static String getLogsAsString(FileJournalManager fjm, long firstTxId) throws IOException {
        return Joiner.on(",").join(fjm.getRemoteEditLogs(firstTxId, false));
    }

    static {
        EditLogFileOutputStream.setShouldSkipFsyncForTesting(true);
    }
}

