/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestHostsFiles {
    private static final Log LOG = LogFactory.getLog((String)TestHostsFiles.class.getName());

    private Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.namenode.replication.interval", 1);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 1);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("net.topology.script.file.name", "xyz");
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostsExcludeDfshealthJsp() throws Exception {
        Configuration conf = this.getConf();
        short REPLICATION_FACTOR = 2;
        Path filePath = new Path("/testFile");
        LocalFileSystem localFileSys = FileSystem.getLocal(conf);
        Path workingDir = ((FileSystem)localFileSys).getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/temp/decommission");
        Path excludeFile = new Path(dir, "exclude");
        Path includeFile = new Path(dir, "include");
        Assert.assertTrue((boolean)((FileSystem)localFileSys).mkdirs(dir));
        DFSTestUtil.writeFile(localFileSys, excludeFile, "");
        DFSTestUtil.writeFile(localFileSys, includeFile, "");
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        conf.set("dfs.hosts", includeFile.toUri().getPath());
        String[] racks = new String[]{"/rack1", "/rack1", "/rack2", "/rack2"};
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(racks.length).racks(racks).build();
        FSNamesystem ns = cluster.getNameNode().getNamesystem();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile(fs, filePath, 1L, REPLICATION_FACTOR, 1L);
            ExtendedBlock b = DFSTestUtil.getFirstBlock(fs, filePath);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            BlockLocation[] locs = ((FileSystem)fs).getFileBlockLocations(((FileSystem)fs).getFileStatus(filePath), 0L, Long.MAX_VALUE);
            String name = locs[0].getNames()[0];
            String names = name + "\n" + "localhost:42\n";
            LOG.info((Object)("adding '" + names + "' to exclude file " + excludeFile.toUri().getPath()));
            DFSTestUtil.writeFile(localFileSys, excludeFile, name);
            ns.getBlockManager().getDatanodeManager().refreshNodes(conf);
            DFSTestUtil.waitForDecommission(fs, name);
            DFSTestUtil.waitForReplication(cluster, b, 2, REPLICATION_FACTOR, 0);
            InetSocketAddress nnHttpAddress = cluster.getNameNode().getHttpAddress();
            LOG.info((Object)("nnaddr = '" + nnHttpAddress + "'"));
            String nnHostName = nnHttpAddress.getHostName();
            URL nnjsp = new URL("http://" + nnHostName + ":" + nnHttpAddress.getPort() + "/dfshealth.jsp");
            LOG.info((Object)("fetching " + nnjsp));
            String dfshealthPage = StringEscapeUtils.unescapeHtml((String)DFSTestUtil.urlGet(nnjsp));
            LOG.info((Object)("got " + dfshealthPage));
            Assert.assertTrue((String)("dfshealth should contain " + nnHostName + ", got:" + dfshealthPage), (boolean)dfshealthPage.contains(nnHostName));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostsIncludeForDeadCount() throws Exception {
        Configuration conf = this.getConf();
        LocalFileSystem localFileSys = FileSystem.getLocal(conf);
        Path workingDir = ((FileSystem)localFileSys).getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/temp/decommission");
        Path excludeFile = new Path(dir, "exclude");
        Path includeFile = new Path(dir, "include");
        Assert.assertTrue((boolean)((FileSystem)localFileSys).mkdirs(dir));
        StringBuilder includeHosts = new StringBuilder();
        includeHosts.append("localhost:52").append("\n").append("127.0.0.1:7777").append("\n");
        DFSTestUtil.writeFile(localFileSys, excludeFile, "");
        DFSTestUtil.writeFile(localFileSys, includeFile, includeHosts.toString());
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        conf.set("dfs.hosts", includeFile.toUri().getPath());
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            FSNamesystem ns = cluster.getNameNode().getNamesystem();
            Assert.assertTrue((ns.getNumDeadDataNodes() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((ns.getNumLiveDataNodes() == 0 ? 1 : 0) != 0);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String nodes = mbs.getAttribute(mxbeanName, "NumDeadDataNodes") + "";
            Assert.assertTrue(((Integer)mbs.getAttribute(mxbeanName, "NumDeadDataNodes") == 2 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)mbs.getAttribute(mxbeanName, "NumLiveDataNodes") == 0 ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

