/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNNStorageRetentionFunctional {
    private static final File TEST_ROOT_DIR = new File(MiniDFSCluster.getBaseDirectory());
    private static final Log LOG = LogFactory.getLog(TestNNStorageRetentionFunctional.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgingWithNameEditsDirAfterFailure() throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.num.extra.edits.retained", 0L);
        File sd0 = new File(TEST_ROOT_DIR, "nn0");
        File sd1 = new File(TEST_ROOT_DIR, "nn1");
        File cd0 = new File(sd0, "current");
        File cd1 = new File(sd1, "current");
        conf.set("dfs.namenode.name.dir", Joiner.on(",").join(sd0, sd1, new Object[0]));
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).manageNameDfsDirs(false).format(true).build();
            NameNode nn = cluster.getNameNode();
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info((Object)"After first save, images 0 and 2 should exist in both dirs");
            GenericTestUtils.assertGlobEquals(cd0, "fsimage_\\d*", NNStorage.getImageFileName(0L), NNStorage.getImageFileName(2L));
            GenericTestUtils.assertGlobEquals(cd1, "fsimage_\\d*", NNStorage.getImageFileName(0L), NNStorage.getImageFileName(2L));
            GenericTestUtils.assertGlobEquals(cd0, "edits_.*", NNStorage.getFinalizedEditsFileName(1L, 2L), NNStorage.getInProgressEditsFileName(3L));
            GenericTestUtils.assertGlobEquals(cd1, "edits_.*", NNStorage.getFinalizedEditsFileName(1L, 2L), NNStorage.getInProgressEditsFileName(3L));
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info((Object)"After second save, image 0 should be purged, and image 4 should exist in both.");
            GenericTestUtils.assertGlobEquals(cd0, "fsimage_\\d*", NNStorage.getImageFileName(2L), NNStorage.getImageFileName(4L));
            GenericTestUtils.assertGlobEquals(cd1, "fsimage_\\d*", NNStorage.getImageFileName(2L), NNStorage.getImageFileName(4L));
            GenericTestUtils.assertGlobEquals(cd0, "edits_.*", NNStorage.getFinalizedEditsFileName(3L, 4L), NNStorage.getInProgressEditsFileName(5L));
            GenericTestUtils.assertGlobEquals(cd1, "edits_.*", NNStorage.getFinalizedEditsFileName(3L, 4L), NNStorage.getInProgressEditsFileName(5L));
            LOG.info((Object)"Failing first storage dir by chmodding it");
            Assert.assertEquals((long)0L, (long)FileUtil.chmod(cd0.getAbsolutePath(), "000"));
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info((Object)"Restoring accessibility of first storage dir");
            Assert.assertEquals((long)0L, (long)FileUtil.chmod(cd0.getAbsolutePath(), "755"));
            LOG.info((Object)"nothing should have been purged in first storage dir");
            GenericTestUtils.assertGlobEquals(cd0, "fsimage_\\d*", NNStorage.getImageFileName(2L), NNStorage.getImageFileName(4L));
            GenericTestUtils.assertGlobEquals(cd0, "edits_.*", NNStorage.getFinalizedEditsFileName(3L, 4L), NNStorage.getInProgressEditsFileName(5L));
            LOG.info((Object)"fsimage_2 should be purged in second storage dir");
            GenericTestUtils.assertGlobEquals(cd1, "fsimage_\\d*", NNStorage.getImageFileName(4L), NNStorage.getImageFileName(6L));
            GenericTestUtils.assertGlobEquals(cd1, "edits_.*", NNStorage.getFinalizedEditsFileName(5L, 6L), NNStorage.getInProgressEditsFileName(7L));
            LOG.info((Object)"On next save, we should purge logs from the failed dir, but not images, since the image directory is in failed state.");
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            GenericTestUtils.assertGlobEquals(cd1, "fsimage_\\d*", NNStorage.getImageFileName(6L), NNStorage.getImageFileName(8L));
            GenericTestUtils.assertGlobEquals(cd1, "edits_.*", NNStorage.getFinalizedEditsFileName(7L, 8L), NNStorage.getInProgressEditsFileName(9L));
            GenericTestUtils.assertGlobEquals(cd0, "fsimage_\\d*", NNStorage.getImageFileName(2L), NNStorage.getImageFileName(4L));
            GenericTestUtils.assertGlobEquals(cd0, "edits_.*", NNStorage.getInProgressEditsFileName(9L));
        }
        finally {
            FileUtil.chmod(cd0.getAbsolutePath(), "755");
            LOG.info((Object)"Shutting down...");
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void doSaveNamespace(NameNode nn) throws IOException {
        LOG.info((Object)"Saving namespace...");
        nn.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        nn.getRpcServer().saveNamespace();
        nn.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
    }
}

