/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestNNStorageRetentionManager {
    final Configuration conf = new Configuration();

    @Before
    public void setNoExtraEditRetention() {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 0L);
    }

    @Test
    public void testPurgeEasyCase() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(101L, 200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        tc.addLog("/foo1/current/VERSION", false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeMultipleDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo2/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(101L, 200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeLessThanRetention() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(101L, 200L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        this.runTest(tc);
    }

    @Test
    public void testNoLogs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        this.runTest(tc);
    }

    @Test
    public void testEmptyDir() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        this.runTest(tc);
    }

    @Test
    public void testOldInProgress() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName(101L), true);
        this.runTest(tc);
    }

    @Test
    public void testSeparateEditDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(101L, 200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        this.runTest(tc);
    }

    @Test
    public void testRetainExtraLogs() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 50L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(101L, 200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(201L, 300L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(301L, 400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        this.runTest(tc);
    }

    @Test
    public void testRetainExtraLogsLimitedSegments() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 150L);
        this.conf.setLong("dfs.namenode.max.extra.edits.segments.retained", 2L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName(400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(1L, 100L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(101L, 175L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(176L, 200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(201L, 225L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(226L, 240L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(241L, 275L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(276L, 300L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(301L, 350L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName(351L, 400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName(401L), false);
        this.runTest(tc);
    }

    private void runTest(TestCaseDescription tc) throws IOException {
        NNStorageRetentionManager.StoragePurger mockPurger = (NNStorageRetentionManager.StoragePurger)Mockito.mock(NNStorageRetentionManager.StoragePurger.class);
        ArgumentCaptor imagesPurgedCaptor = ArgumentCaptor.forClass(FSImageStorageInspector.FSImageFile.class);
        ArgumentCaptor logsPurgedCaptor = ArgumentCaptor.forClass(FileJournalManager.EditLogFile.class);
        new NNStorageRetentionManager(this.conf, tc.mockStorage(), tc.mockEditLog(mockPurger), mockPurger).purgeOldStorage(NNStorage.NameNodeFile.IMAGE);
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeImage((FSImageStorageInspector.FSImageFile)imagesPurgedCaptor.capture());
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeLog((FileJournalManager.EditLogFile)logsPurgedCaptor.capture());
        LinkedHashSet<String> purgedPaths = Sets.newLinkedHashSet();
        for (Object purged : imagesPurgedCaptor.getAllValues()) {
            purgedPaths.add(TestNNStorageRetentionManager.fileToPath(((FSImageStorageInspector.FSImageFile)purged).getFile()));
        }
        Assert.assertEquals((Object)Joiner.on(",").join(TestNNStorageRetentionManager.filesToPaths(tc.expectedPurgedImages)), (Object)Joiner.on(",").join(purgedPaths));
        purgedPaths.clear();
        for (Object purged : logsPurgedCaptor.getAllValues()) {
            purgedPaths.add(TestNNStorageRetentionManager.fileToPath(((FileJournalManager.EditLogFile)purged).getFile()));
        }
        Assert.assertEquals((Object)Joiner.on(",").join(TestNNStorageRetentionManager.filesToPaths(tc.expectedPurgedLogs)), (Object)Joiner.on(",").join(purgedPaths));
    }

    private static String fileToPath(File file) {
        return file.toURI().getPath();
    }

    private static Collection<String> filesToPaths(Collection<File> files) {
        ArrayList<String> paths = Lists.newArrayList();
        for (File file : files) {
            paths.add(TestNNStorageRetentionManager.fileToPath(file));
        }
        return paths;
    }

    private static NNStorage mockStorageForDirs(final Storage.StorageDirectory ... mockDirs) throws IOException {
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        ((NNStorage)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                FSImageStorageInspector inspector = (FSImageStorageInspector)invocation.getArguments()[0];
                for (Storage.StorageDirectory sd : mockDirs) {
                    inspector.inspectDirectory(sd);
                }
                return null;
            }
        }).when((Object)mockStorage)).inspectStorageDirs((FSImageStorageInspector)Mockito.anyObject());
        return mockStorage;
    }

    private class TestCaseDescription {
        private final Map<File, FakeRoot> dirRoots = Maps.newLinkedHashMap();
        private final Set<File> expectedPurgedLogs = Sets.newLinkedHashSet();
        private final Set<File> expectedPurgedImages = Sets.newLinkedHashSet();

        private TestCaseDescription() {
        }

        void addRoot(String root, NNStorage.NameNodeDirType dir) {
            this.dirRoots.put(new File(root), new FakeRoot(dir));
        }

        private void addFile(File file) {
            for (Map.Entry<File, FakeRoot> entry : this.dirRoots.entrySet()) {
                if (!TestNNStorageRetentionManager.fileToPath(file).startsWith(TestNNStorageRetentionManager.fileToPath(entry.getKey()))) continue;
                entry.getValue().files.add(file);
            }
        }

        void addLog(String path, boolean expectPurge) {
            File file = new File(path);
            this.addFile(file);
            if (expectPurge) {
                this.expectedPurgedLogs.add(file);
            }
        }

        void addImage(String path, boolean expectPurge) {
            File file = new File(path);
            this.addFile(file);
            if (expectPurge) {
                this.expectedPurgedImages.add(file);
            }
        }

        NNStorage mockStorage() throws IOException {
            ArrayList<Storage.StorageDirectory> sds = Lists.newArrayList();
            for (FakeRoot root : this.dirRoots.values()) {
                sds.add(root.mockStorageDir());
            }
            return TestNNStorageRetentionManager.mockStorageForDirs(sds.toArray(new Storage.StorageDirectory[0]));
        }

        public FSEditLog mockEditLog(NNStorageRetentionManager.StoragePurger purger) throws IOException {
            final ArrayList<FileJournalManager> jms = Lists.newArrayList();
            final JournalSet journalSet = new JournalSet(0);
            for (FakeRoot root : this.dirRoots.values()) {
                if (!root.type.isOfType(NNStorage.NameNodeDirType.EDITS)) continue;
                FileJournalManager fjm = new FileJournalManager(TestNNStorageRetentionManager.this.conf, root.mockStorageDir(), null);
                fjm.purger = purger;
                jms.add(fjm);
                journalSet.add(fjm, false);
            }
            FSEditLog mockLog = (FSEditLog)Mockito.mock(FSEditLog.class);
            ((FSEditLog)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Object[] args = invocation.getArguments();
                    assert (args.length == 1);
                    long txId = (Long)args[0];
                    for (JournalManager jm : jms) {
                        jm.purgeLogsOlderThan(txId);
                    }
                    return null;
                }
            }).when((Object)mockLog)).purgeLogsOlderThan(Mockito.anyLong());
            ((FSEditLog)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Object[] args = invocation.getArguments();
                    journalSet.selectInputStreams((Collection)args[0], (Long)args[1], (Boolean)args[2]);
                    return null;
                }
            }).when((Object)mockLog)).selectInputStreams(Mockito.anyCollection(), Mockito.anyLong(), Mockito.anyBoolean());
            return mockLog;
        }

        private class FakeRoot {
            final NNStorage.NameNodeDirType type;
            final List<File> files;

            FakeRoot(NNStorage.NameNodeDirType type) {
                this.type = type;
                this.files = Lists.newArrayList();
            }

            Storage.StorageDirectory mockStorageDir() {
                return FSImageTestUtil.mockStorageDirectory(this.type, false, TestNNStorageRetentionManager.filesToPaths(this.files).toArray(new String[0]));
            }
        }
    }
}

