/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.base.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;

public abstract class HATestUtil {
    private static final Log LOG = LogFactory.getLog(HATestUtil.class);
    private static final String LOGICAL_HOSTNAME = "ha-nn-uri-%d";

    public static void waitForStandbyToCatchUp(NameNode active, NameNode standby) throws InterruptedException, IOException, CouldNotCatchUpException {
        long activeTxId = active.getNamesystem().getFSImage().getEditLog().getLastWrittenTxId();
        active.getRpcServer().rollEditLog();
        long start = Time.now();
        while (Time.now() - start < 10000L) {
            long nn2HighestTxId = standby.getNamesystem().getFSImage().getLastAppliedTxId();
            if (nn2HighestTxId >= activeTxId) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new CouldNotCatchUpException("Standby did not catch up to txid " + activeTxId + " (currently at " + standby.getNamesystem().getFSImage().getLastAppliedTxId() + ")");
    }

    public static void waitForDNDeletions(final MiniDFSCluster cluster) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                for (DataNode dn : cluster.getDataNodes()) {
                    if (DataNodeTestUtils.getPendingAsyncDeletions(dn) <= 0L) continue;
                    return false;
                }
                return true;
            }
        }, 1000, 10000);
    }

    public static void waitForNNToIssueDeletions(final NameNode nn) throws Exception {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LOG.info((Object)"Waiting for NN to issue block deletions to DNs");
                return nn.getNamesystem().getBlockManager().getPendingDeletionBlocksCount() == 0L;
            }
        }, 250, 10000);
    }

    public static FileSystem configureFailoverFs(MiniDFSCluster cluster, Configuration conf) throws IOException, URISyntaxException {
        return HATestUtil.configureFailoverFs(cluster, conf, 0);
    }

    public static FileSystem configureFailoverFs(MiniDFSCluster cluster, Configuration conf, int nsIndex) throws IOException, URISyntaxException {
        conf = new Configuration(conf);
        String logicalName = HATestUtil.getLogicalHostname(cluster);
        HATestUtil.setFailoverConfigurations(cluster, conf, logicalName, nsIndex);
        FileSystem fs = FileSystem.get(new URI("hdfs://" + logicalName), conf);
        return fs;
    }

    public static void setFailoverConfigurations(MiniDFSCluster cluster, Configuration conf) {
        HATestUtil.setFailoverConfigurations(cluster, conf, HATestUtil.getLogicalHostname(cluster));
    }

    public static void setFailoverConfigurations(MiniDFSCluster cluster, Configuration conf, String logicalName) {
        HATestUtil.setFailoverConfigurations(cluster, conf, logicalName, 0);
    }

    public static void setFailoverConfigurations(MiniDFSCluster cluster, Configuration conf, String logicalName, int nsIndex) {
        InetSocketAddress nnAddr1 = cluster.getNameNode(2 * nsIndex).getNameNodeAddress();
        InetSocketAddress nnAddr2 = cluster.getNameNode(2 * nsIndex + 1).getNameNodeAddress();
        HATestUtil.setFailoverConfigurations(conf, logicalName, nnAddr1, nnAddr2);
    }

    public static void setFailoverConfigurations(Configuration conf, String logicalName, InetSocketAddress nnAddr1, InetSocketAddress nnAddr2) {
        String nameNodeId1 = "nn1";
        String nameNodeId2 = "nn2";
        String address1 = "hdfs://" + nnAddr1.getHostName() + ":" + nnAddr1.getPort();
        String address2 = "hdfs://" + nnAddr2.getHostName() + ":" + nnAddr2.getPort();
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", logicalName, nameNodeId1), address1);
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", logicalName, nameNodeId2), address2);
        conf.set("dfs.nameservices", logicalName);
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", logicalName), nameNodeId1 + "," + nameNodeId2);
        conf.set("dfs.client.failover.proxy.provider." + logicalName, ConfiguredFailoverProxyProvider.class.getName());
        conf.set("fs.defaultFS", "hdfs://" + logicalName);
    }

    public static String getLogicalHostname(MiniDFSCluster cluster) {
        return String.format(LOGICAL_HOSTNAME, cluster.getInstanceId());
    }

    public static URI getLogicalUri(MiniDFSCluster cluster) throws URISyntaxException {
        return new URI("hdfs://" + HATestUtil.getLogicalHostname(cluster));
    }

    public static void waitForCheckpoint(MiniDFSCluster cluster, int nnIdx, List<Integer> txids) throws InterruptedException {
        long start = Time.now();
        while (true) {
            try {
                FSImageTestUtil.assertNNHasCheckpoints(cluster, nnIdx, txids);
                return;
            }
            catch (AssertionError err) {
                if (Time.now() - start > 10000L) {
                    throw err;
                }
                Thread.sleep(300L);
                continue;
            }
            break;
        }
    }

    public static class CouldNotCatchUpException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public CouldNotCatchUpException(String message) {
            super(message);
        }
    }
}

