/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyCheckpointer;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHAConfiguration {
    private final FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);

    @Test
    public void testCheckpointerValidityChecks() throws Exception {
        try {
            Configuration conf = new Configuration();
            new StandbyCheckpointer(conf, this.fsn);
            Assert.fail((String)"Bad config did not throw an error");
        }
        catch (IllegalArgumentException iae) {
            GenericTestUtils.assertExceptionContains("Invalid URI for NameNode address", iae);
        }
    }

    private Configuration getHAConf(String nsId, String host1, String host2) {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", nsId);
        conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", nsId), "nn1,nn2");
        conf.set("dfs.ha.namenode.id", "nn1");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", nsId, "nn1"), host1 + ":12345");
        conf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", nsId, "nn2"), host2 + ":12345");
        return conf;
    }

    @Test
    public void testGetOtherNNHttpAddress() throws IOException {
        Configuration conf = this.getHAConf("ns1", "1.2.3.1", "1.2.3.2");
        conf.set("dfs.nameservice.id", "ns1");
        NameNode.initializeGenericKeys(conf, "ns1", "nn1");
        StandbyCheckpointer checkpointer = new StandbyCheckpointer(conf, this.fsn);
        Assert.assertEquals((Object)new URL("http", "1.2.3.2", 50070, ""), (Object)checkpointer.getActiveNNAddress());
    }

    @Test
    public void testHAUniqueEditDirs() throws IOException {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/shared/dir");
        conf.set("dfs.namenode.shared.edits.dir", "file://edits/shared/dir");
        List<URI> editsDirs = FSNamesystem.getNamespaceEditsDirs(conf);
        Assert.assertEquals((long)2L, (long)editsDirs.size());
    }

    @Test
    public void testSecondaryNameNodeDoesNotStart() throws IOException {
        Configuration conf = this.getHAConf("ns1", "1.2.3.1", "1.2.3.2");
        try {
            new SecondaryNameNode(conf);
            Assert.fail((String)"Created a 2NN with an HA config");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains("Cannot use SecondaryNameNode in an HA cluster", ioe);
        }
    }
}

