/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestWebHdfsDataLocality {
    static final Log LOG = LogFactory.getLog(TestWebHdfsDataLocality.class);
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String RACK2 = "/rack2";

    public TestWebHdfsDataLocality() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.OFF);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.OFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataLocality() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1, RACK2, RACK2};
        int nDataNodes = racks.length;
        LOG.info((Object)("nDataNodes=" + nDataNodes + ", racks=" + Arrays.asList(racks)));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            NameNode namenode = cluster.getNameNode();
            DatanodeManager dm = namenode.getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info((Object)("dm=" + dm));
            long blocksize = 0x8000000L;
            String f = "/foo";
            for (int i = 0; i < nDataNodes; ++i) {
                DataNode dn = cluster.getDataNodes().get(i);
                String ipAddr = dm.getDatanode(dn.getDatanodeId()).getIpAddr();
                DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode(namenode, "/foo", PutOpParam.Op.CREATE, -1L, 0x8000000L);
                Assert.assertEquals((Object)ipAddr, (Object)chosen.getIpAddr());
            }
            Path p = new Path("/foo");
            FSDataOutputStream out = dfs.create(p, (short)1);
            out.write(1);
            out.close();
            LocatedBlocks locatedblocks = NameNodeAdapter.getBlockLocations(namenode, "/foo", 0L, 1L);
            List<LocatedBlock> lb = locatedblocks.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lb.size());
            DatanodeInfo[] locations = lb.get(0).getLocations();
            Assert.assertEquals((long)1L, (long)locations.length);
            DatanodeInfo expected = locations[0];
            DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode(namenode, "/foo", GetOpParam.Op.GETFILECHECKSUM, -1L, 0x8000000L);
            Assert.assertEquals((Object)expected, (Object)chosen);
            chosen = NamenodeWebHdfsMethods.chooseDatanode(namenode, "/foo", GetOpParam.Op.OPEN, 0L, 0x8000000L);
            Assert.assertEquals((Object)expected, (Object)chosen);
            chosen = NamenodeWebHdfsMethods.chooseDatanode(namenode, "/foo", PostOpParam.Op.APPEND, -1L, 0x8000000L);
            Assert.assertEquals((Object)expected, (Object)chosen);
        }
        finally {
            cluster.shutdown();
        }
    }
}

