/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.LsrPBImage;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestOfflineImageViewer {
    private static final Log LOG = LogFactory.getLog(OfflineImageViewer.class);
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    private static final String TEST_RENEWER = "JobTracker";
    private static File originalFsimage = null;
    static final HashMap<String, FileStatus> writtenFiles = Maps.newHashMap();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Token<?>[] delegationTokens;
            Configuration conf = new Configuration();
            conf.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
            conf.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            for (int i = 0; i < 3; ++i) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                writtenFiles.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry(hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(23);
                    o.close();
                    writtenFiles.put(file.toString(), TestOfflineImageViewer.pathToFileEntry(hdfs, file.toString()));
                }
            }
            for (Token<?> t : delegationTokens = hdfs.addDelegationTokens(TEST_RENEWER, null)) {
                LOG.debug((Object)("got token " + t));
            }
            Path snapshot = new Path("/snapshot");
            hdfs.mkdirs(snapshot);
            hdfs.allowSnapshot(snapshot);
            hdfs.mkdirs(new Path("/snapshot/1"));
            hdfs.delete(snapshot, true);
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    private static FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    @Test
    public void outputOfLSVisitor() throws IOException {
        StringWriter output = new StringWriter();
        PrintWriter out = new PrintWriter(output);
        LsrPBImage v = new LsrPBImage(new Configuration(), out);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        out.close();
        Pattern pattern = Pattern.compile("([d\\-])([rwx\\-]{9})\\s*(-|\\d+)\\s*(\\w+)\\s*(\\w+)\\s*(\\d+)\\s*(\\d+)\\s*([\b/]+)");
        int count = 0;
        for (String s : output.toString().split("\n")) {
            Matcher m = pattern.matcher(s);
            Assert.assertTrue((boolean)m.find());
            LsElements e = new LsElements();
            e.isDir = m.group(1).equals("d");
            e.perms = m.group(2);
            e.replication = m.group(3).equals("-") ? 0 : Integer.parseInt(m.group(3));
            e.username = m.group(4);
            e.groupname = m.group(5);
            e.filesize = Long.parseLong(m.group(7));
            String path = m.group(8);
            if (!path.equals("/")) {
                this.compareFiles(writtenFiles.get(path), e);
            }
            ++count;
        }
        Assert.assertEquals((long)(writtenFiles.size() + 1), (long)count);
    }

    @Test(expected=IOException.class)
    public void testTruncatedFSImage() throws IOException {
        File truncatedFile = this.folder.newFile();
        StringWriter output = new StringWriter();
        this.copyPartOfFile(originalFsimage, truncatedFile);
        new FileDistributionCalculator(new Configuration(), 0L, 0, new PrintWriter(output)).visit(new RandomAccessFile(truncatedFile, "r"));
    }

    private void compareFiles(FileStatus fs, LsElements elements) {
        Assert.assertEquals((String)"directory listed as such", (Object)fs.isDirectory(), (Object)elements.isDir);
        Assert.assertEquals((String)"perms string equal", (Object)fs.getPermission().toString(), (Object)elements.perms);
        Assert.assertEquals((String)"replication equal", (long)fs.getReplication(), (long)elements.replication);
        Assert.assertEquals((String)"owner equal", (Object)fs.getOwner(), (Object)elements.username);
        Assert.assertEquals((String)"group equal", (Object)fs.getGroup(), (Object)elements.groupname);
        Assert.assertEquals((String)"lengths equal", (long)fs.getLen(), (long)elements.filesize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        int MAX_BYTES = 700;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            in.getChannel().transferTo(0L, 700L, out.getChannel());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, in);
            IOUtils.cleanup(null, out);
            throw throwable;
        }
        IOUtils.cleanup(null, in);
        IOUtils.cleanup(null, out);
    }

    @Test
    public void testFileDistributionCalculator() throws IOException {
        StringWriter output = new StringWriter();
        PrintWriter o = new PrintWriter(output);
        new FileDistributionCalculator(new Configuration(), 0L, 0, o).visit(new RandomAccessFile(originalFsimage, "r"));
        o.close();
        Pattern p = Pattern.compile("totalFiles = (\\d+)\n");
        Matcher matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalFiles = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)12L, (long)totalFiles);
        p = Pattern.compile("totalDirectories = (\\d+)\n");
        matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalDirs = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)4L, (long)totalDirs);
        FileStatus maxFile = Collections.max(writtenFiles.values(), new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus first, FileStatus second) {
                return first.getLen() < second.getLen() ? -1 : (first.getLen() == second.getLen() ? 0 : 1);
            }
        });
        p = Pattern.compile("maxFileSize = (\\d+)\n");
        matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)maxFile.getLen(), (long)Long.parseLong(matcher.group(1)));
    }

    @Test
    public void testFileDistributionCalculatorWithOptions() throws IOException {
        int status = OfflineImageViewerPB.run(new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testPBImageXmlWriter() throws IOException, SAXException, ParserConfigurationException {
        StringWriter output = new StringWriter();
        PrintWriter o = new PrintWriter(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = spf.newSAXParser();
        String xml = output.getBuffer().toString();
        parser.parse(new InputSource(new StringReader(xml)), new DefaultHandler());
    }

    private static final class LsElements {
        private String perms;
        private int replication;
        private String username;
        private String groupname;
        private long filesize;
        private boolean isDir;

        private LsElements() {
        }
    }
}

