/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.util.CyclicIteration;
import org.junit.Assert;
import org.junit.Test;

public class TestCyclicIteration {
    @Test
    public void testCyclicIteration() throws Exception {
        for (int n = 0; n < 5; ++n) {
            TestCyclicIteration.checkCyclicIteration(n);
        }
    }

    private static void checkCyclicIteration(int numOfElements) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        Integer[] integers = new Integer[numOfElements];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = 2 * i;
            map.put(integers[i], integers[i]);
        }
        System.out.println("\n\nintegers=" + Arrays.asList(integers));
        System.out.println("map=" + map);
        for (int start = -1; start <= 2 * integers.length - 1; ++start) {
            ArrayList<Integer> iteration = new ArrayList<Integer>();
            for (Map.Entry entry : new CyclicIteration(map, start)) {
                iteration.add(entry.getKey());
            }
            System.out.println("start=" + start + ", iteration=" + iteration);
            for (int i = 0; i < integers.length; ++i) {
                int n = ((start + 2) / 2 + i) % integers.length;
                Assert.assertEquals((String)("i=" + i + ", j=" + n), iteration.get(i), (Object)integers[n]);
            }
        }
    }
}

