/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import org.apache.hadoop.hdfs.util.XMLUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestXMLUtils {
    private static void testRoundTrip(String str, String expectedMangled) {
        String mangled = XMLUtils.mangleXmlString(str);
        Assert.assertEquals((Object)mangled, (Object)expectedMangled);
        String unmangled = XMLUtils.unmangleXmlString(mangled);
        Assert.assertEquals((Object)unmangled, (Object)str);
    }

    @Test
    public void testMangleEmptyString() throws Exception {
        TestXMLUtils.testRoundTrip("", "");
    }

    @Test
    public void testMangleVanillaString() throws Exception {
        TestXMLUtils.testRoundTrip("abcdef", "abcdef");
    }

    @Test
    public void testMangleStringWithBackSlash() throws Exception {
        TestXMLUtils.testRoundTrip("a\\bcdef", "a\\005c;bcdef");
        TestXMLUtils.testRoundTrip("\\\\", "\\005c;\\005c;");
    }

    @Test
    public void testMangleStringWithForbiddenCodePoint() throws Exception {
        TestXMLUtils.testRoundTrip("a\u0001bcdef", "a\\0001;bcdef");
        TestXMLUtils.testRoundTrip("a\u0002\ud800bcdef", "a\\0002;\\d800;bcdef");
    }

    @Test
    public void testInvalidSequence() throws Exception {
        try {
            XMLUtils.unmangleXmlString("\\000g;foo");
            Assert.fail((String)"expected an unmangling error");
        }
        catch (XMLUtils.UnmanglingError e) {
            // empty catch block
        }
        try {
            XMLUtils.unmangleXmlString("\\0");
            Assert.fail((String)"expected an unmangling error");
        }
        catch (XMLUtils.UnmanglingError unmanglingError) {
            // empty catch block
        }
    }
}

