/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpsFileSystem {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestHttpsFileSystem.class.getSimpleName();
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static String keystoresDir;
    private static String sslConfDir;
    private static String nnAddr;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete(base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestHttpsFileSystem.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        FSDataOutputStream os = cluster.getFileSystem().create(new Path("/test"));
        ((OutputStream)os).write(23);
        ((OutputStream)os).close();
        InetSocketAddress addr = cluster.getNameNode().getHttpsAddress();
        nnAddr = NetUtils.getHostPortString(addr);
        conf.set("dfs.namenode.https-address", nnAddr);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        cluster.shutdown();
        FileUtil.fullyDelete(new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
    }

    @Test
    public void testHsftpFileSystem() throws Exception {
        FileSystem fs = FileSystem.get(new URI("hsftp://" + nnAddr), conf);
        Assert.assertTrue((boolean)fs.exists(new Path("/test")));
        FSDataInputStream is = fs.open(new Path("/test"));
        Assert.assertEquals((long)23L, (long)((InputStream)is).read());
        ((InputStream)is).close();
        fs.close();
    }

    @Test
    public void testSWebHdfsFileSystem() throws Exception {
        WebHdfsFileSystem fs = WebHdfsTestUtil.getWebHdfsFileSystem(conf, "swebhdfs");
        Path f = new Path("/testswebhdfs");
        FSDataOutputStream os = fs.create(f);
        os.write(23);
        os.close();
        Assert.assertTrue((boolean)fs.exists(f));
        FSDataInputStream is = fs.open(f);
        Assert.assertEquals((long)23L, (long)((InputStream)is).read());
        ((InputStream)is).close();
        ((FileSystem)fs).close();
    }
}

