/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestJsonUtil {
    static FileStatus toFileStatus(HdfsFileStatus f, String parent) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, new Path(f.getFullName(parent)));
    }

    @Test
    public void testHdfsFileStatus() {
        long now = Time.now();
        String parent = "/dir";
        HdfsFileStatus status = new HdfsFileStatus(1001L, false, 3, 0x4000000L, now, now + 10L, new FsPermission(420), "user", "group", DFSUtil.string2Bytes("bar"), DFSUtil.string2Bytes("foo"), 0L, 0);
        FileStatus fstatus = TestJsonUtil.toFileStatus(status, "/dir");
        System.out.println("status  = " + status);
        System.out.println("fstatus = " + fstatus);
        String json = JsonUtil.toJsonString(status, true);
        System.out.println("json    = " + json.replace(",", ",\n  "));
        HdfsFileStatus s2 = JsonUtil.toFileStatus((Map)JSON.parse((String)json), true);
        FileStatus fs2 = TestJsonUtil.toFileStatus(s2, "/dir");
        System.out.println("s2      = " + s2);
        System.out.println("fs2     = " + fs2);
        Assert.assertEquals((Object)fstatus, (Object)fs2);
    }

    @Test
    public void testToDatanodeInfoWithoutSecurePort() throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("ipAddr", "127.0.0.1");
        response.put("hostName", "localhost");
        response.put("storageID", "fake-id");
        response.put("xferPort", 1337L);
        response.put("infoPort", 1338L);
        response.put("ipcPort", 1339L);
        response.put("capacity", 1024L);
        response.put("dfsUsed", 512L);
        response.put("remaining", 512L);
        response.put("blockPoolUsed", 512L);
        response.put("lastUpdate", 0L);
        response.put("xceiverCount", 4096L);
        response.put("networkLocation", "foo.bar.baz");
        response.put("adminState", "NORMAL");
        response.put("cacheCapacity", 123L);
        response.put("cacheUsed", 321L);
        JsonUtil.toDatanodeInfo(response);
    }

    @Test
    public void testToDatanodeInfoWithName() throws Exception {
        String[] badNames;
        HashMap<String, Object> response = new HashMap<String, Object>();
        String name = "127.0.0.1:1004";
        response.put("name", name);
        response.put("hostName", "localhost");
        response.put("storageID", "fake-id");
        response.put("infoPort", 1338L);
        response.put("ipcPort", 1339L);
        response.put("capacity", 1024L);
        response.put("dfsUsed", 512L);
        response.put("remaining", 512L);
        response.put("blockPoolUsed", 512L);
        response.put("lastUpdate", 0L);
        response.put("xceiverCount", 4096L);
        response.put("networkLocation", "foo.bar.baz");
        response.put("adminState", "NORMAL");
        response.put("cacheCapacity", 123L);
        response.put("cacheUsed", 321L);
        DatanodeInfo di = JsonUtil.toDatanodeInfo(response);
        Assert.assertEquals((Object)name, (Object)di.getXferAddr());
        Map<String, Object> r = JsonUtil.toJsonMap(di);
        Assert.assertEquals((Object)name, (Object)((String)r.get("name")));
        Assert.assertEquals((Object)"127.0.0.1", (Object)((String)r.get("ipAddr")));
        Assert.assertEquals((long)1004L, (long)((Integer)r.get("xferPort")).intValue());
        for (String badName : badNames = new String[]{"127.0.0.1", "127.0.0.1:", ":", "127.0.0.1:sweet", ":123"}) {
            response.put("name", badName);
            this.checkDecodeFailure(response);
        }
        response.remove("name");
        this.checkDecodeFailure(response);
        response.put("ipAddr", "127.0.0.1");
        this.checkDecodeFailure(response);
    }

    @Test
    public void testToAclStatus() {
        String jsonString = "{\"AclStatus\":{\"entries\":[\"user::rwx\",\"user:user1:rw-\",\"group::rw-\",\"other::r-x\"],\"group\":\"supergroup\",\"owner\":\"testuser\",\"stickyBit\":false}}";
        Map json = (Map)JSON.parse((String)jsonString);
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.READ_EXECUTE));
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner("testuser");
        aclStatusBuilder.group("supergroup");
        aclStatusBuilder.addEntries(aclSpec);
        aclStatusBuilder.stickyBit(false);
        Assert.assertEquals((String)"Should be equal", (Object)aclStatusBuilder.build(), (Object)JsonUtil.toAclStatus(json));
    }

    @Test
    public void testToJsonFromAclStatus() {
        String jsonString = "{\"AclStatus\":{\"entries\":[\"user:user1:rwx\",\"group::rw-\"],\"group\":\"supergroup\",\"owner\":\"testuser\",\"stickyBit\":false}}";
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner("testuser");
        aclStatusBuilder.group("supergroup");
        aclStatusBuilder.stickyBit(false);
        ArrayList<AclEntry> aclSpec = Lists.newArrayList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "user1", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_WRITE));
        aclStatusBuilder.addEntries(aclSpec);
        Assert.assertEquals((Object)jsonString, (Object)JsonUtil.toJsonString(aclStatusBuilder.build()));
    }

    private void checkDecodeFailure(Map<String, Object> map) {
        try {
            JsonUtil.toDatanodeInfo(map);
            Assert.fail((String)"Exception not thrown against bad input.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

