/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;

public class TestArrayWritable
extends TestCase {
    public TestArrayWritable(String name) {
        super(name);
    }

    public void testThrowUndefinedValueException() throws IOException {
        Writable[] elements = new Text[]{new Text("zero"), new Text("one"), new Text("two")};
        TextArrayWritable sourceArray = new TextArrayWritable();
        sourceArray.set(elements);
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        sourceArray.write(out);
        TextArrayWritable destArray = new TextArrayWritable();
        in.reset(out.getData(), out.getLength());
        destArray.readFields(in);
        Writable[] destElements = destArray.get();
        TestArrayWritable.assertTrue((destElements.length == elements.length ? 1 : 0) != 0);
        for (int i = 0; i < elements.length; ++i) {
            TestArrayWritable.assertEquals((Object)destElements[i], (Object)elements[i]);
        }
    }

    public void testArrayWritableToArray() {
        Writable[] elements = new Text[]{new Text("zero"), new Text("one"), new Text("two")};
        TextArrayWritable arrayWritable = new TextArrayWritable();
        arrayWritable.set(elements);
        Object array = arrayWritable.toArray();
        TestArrayWritable.assertTrue((String)"TestArrayWritable testArrayWritableToArray error!!! ", (boolean)(array instanceof Text[]));
        Text[] destElements = (Text[])array;
        for (int i = 0; i < elements.length; ++i) {
            TestArrayWritable.assertEquals((Object)destElements[i], (Object)elements[i]);
        }
    }

    public void testNullArgument() {
        try {
            Class<? extends Writable> valueClass = null;
            new ArrayWritable(valueClass);
            TestArrayWritable.fail((String)"testNullArgument error !!!");
        }
        catch (IllegalArgumentException exp) {
        }
        catch (Exception e) {
            TestArrayWritable.fail((String)"testNullArgument error !!!");
        }
    }

    public void testArrayWritableStringConstructor() {
        Object[] original = new String[]{"test1", "test2", "test3"};
        ArrayWritable arrayWritable = new ArrayWritable((String[])original);
        TestArrayWritable.assertEquals((String)"testArrayWritableStringConstructor class error!!!", UTF8.class, (Object)arrayWritable.getValueClass());
        Assert.assertArrayEquals((String)"testArrayWritableStringConstructor toString error!!!", (Object[])original, (Object[])arrayWritable.toStrings());
    }

    static class TextArrayWritable
    extends ArrayWritable {
        public TextArrayWritable() {
            super(Text.class);
        }
    }
}

