/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.ObjectWritable;

public class TestEnumSetWritable
extends TestCase {
    EnumSet<TestEnumSet> nonEmptyFlag = EnumSet.of(TestEnumSet.APPEND);
    EnumSetWritable<TestEnumSet> nonEmptyFlagWritable = new EnumSetWritable<TestEnumSet>(this.nonEmptyFlag);
    EnumSet<TestEnumSet> emptyFlag = EnumSet.noneOf(TestEnumSet.class);
    public EnumSetWritable<TestEnumSet> testField;

    public void testSerializeAndDeserializeNonEmpty() throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject(out, this.nonEmptyFlagWritable, this.nonEmptyFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject(in, null)).get();
        TestEnumSetWritable.assertEquals(read, this.nonEmptyFlag);
    }

    public void testSerializeAndDeserializeEmpty() throws IOException {
        boolean gotException = false;
        try {
            new EnumSetWritable<TestEnumSet>(this.emptyFlag);
        }
        catch (RuntimeException e) {
            gotException = true;
        }
        TestEnumSetWritable.assertTrue((String)"Instantiation of empty EnumSetWritable with no element type class provided should throw exception.", (boolean)gotException);
        EnumSetWritable<TestEnumSet> emptyFlagWritable = new EnumSetWritable<TestEnumSet>(this.emptyFlag, TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject(out, emptyFlagWritable, emptyFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject(in, null)).get();
        TestEnumSetWritable.assertEquals(read, this.emptyFlag);
    }

    public void testSerializeAndDeserializeNull() throws IOException {
        boolean gotException = false;
        try {
            new EnumSetWritable(null);
        }
        catch (RuntimeException e) {
            gotException = true;
        }
        TestEnumSetWritable.assertTrue((String)"Instantiation of empty EnumSetWritable with no element type class provided should throw exception", (boolean)gotException);
        EnumSetWritable<TestEnumSet> nullFlagWritable = new EnumSetWritable<TestEnumSet>(null, TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject(out, nullFlagWritable, nullFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject(in, null)).get();
        TestEnumSetWritable.assertEquals(read, null);
    }

    public void testAvroReflect() throws Exception {
        String schema = "{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"TestEnumSet\",\"namespace\":\"org.apache.hadoop.io.TestEnumSetWritable$\",\"symbols\":[\"CREATE\",\"OVERWRITE\",\"APPEND\"]},\"java-class\":\"org.apache.hadoop.io.EnumSetWritable\"}";
        Type type = TestEnumSetWritable.class.getField("testField").getGenericType();
        AvroTestUtil.testReflect(this.nonEmptyFlagWritable, type, schema);
    }

    public void testEnumSetWritableEquals() {
        EnumSetWritable<TestEnumSet> eset1 = new EnumSetWritable<TestEnumSet>(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        EnumSetWritable<TestEnumSet> eset2 = new EnumSetWritable<TestEnumSet>(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        TestEnumSetWritable.assertTrue((String)"testEnumSetWritableEquals error !!!", (boolean)eset1.equals(eset2));
        TestEnumSetWritable.assertFalse((String)"testEnumSetWritableEquals error !!!", (boolean)eset1.equals(new EnumSetWritable<TestEnumSet>(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE, TestEnumSet.OVERWRITE), TestEnumSet.class)));
        TestEnumSetWritable.assertTrue((String)"testEnumSetWritableEquals getElementType error !!!", (boolean)eset1.getElementType().equals(TestEnumSet.class));
    }

    public void testEnumSetWritableWriteRead() throws Exception {
        EnumSetWritable<TestEnumSet> srcSet = new EnumSetWritable<TestEnumSet>(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        srcSet.write(out);
        EnumSetWritable dstSet = new EnumSetWritable();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        dstSet.readFields(in);
        EnumSet result = dstSet.get();
        Iterator dstIter = result.iterator();
        Iterator<TestEnumSet> srcIter = srcSet.iterator();
        while (dstIter.hasNext() && srcIter.hasNext()) {
            TestEnumSetWritable.assertEquals((String)"testEnumSetWritableWriteRead error !!!", dstIter.next(), (Object)((Object)srcIter.next()));
        }
    }

    static enum TestEnumSet {
        CREATE,
        OVERWRITE,
        APPEND;

    }
}

