/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCodecPool {
    private final String LEASE_COUNT_ERR = "Incorrect number of leased (de)compressors";
    DefaultCodec codec;

    @Before
    public void setup() {
        this.codec = new DefaultCodec();
        this.codec.setConf(new Configuration());
    }

    @Test(timeout=1000L)
    public void testCompressorPoolCounts() {
        Compressor comp1 = CodecPool.getCompressor(this.codec);
        Compressor comp2 = CodecPool.getCompressor(this.codec);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)2L, (long)CodecPool.getLeasedCompressorsCount(this.codec));
        CodecPool.returnCompressor(comp2);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)1L, (long)CodecPool.getLeasedCompressorsCount(this.codec));
        CodecPool.returnCompressor(comp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedCompressorsCount(this.codec));
    }

    @Test(timeout=1000L)
    public void testDecompressorPoolCounts() {
        Decompressor decomp1 = CodecPool.getDecompressor(this.codec);
        Decompressor decomp2 = CodecPool.getDecompressor(this.codec);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)2L, (long)CodecPool.getLeasedDecompressorsCount(this.codec));
        CodecPool.returnDecompressor(decomp2);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)1L, (long)CodecPool.getLeasedDecompressorsCount(this.codec));
        CodecPool.returnDecompressor(decomp1);
        Assert.assertEquals((String)"Incorrect number of leased (de)compressors", (long)0L, (long)CodecPool.getLeasedDecompressorsCount(this.codec));
    }
}

