/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.util.Random;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.io.compress.CompressDecompressTester;
import org.apache.hadoop.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.io.compress.lz4.Lz4Decompressor;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.junit.Assert;
import org.junit.Test;

public class TestCompressorDecompressor {
    private static final Random rnd = new Random(12345L);

    @Test
    public void testCompressorDecompressor() {
        int SIZE = 45056;
        byte[] rawData = TestCompressorDecompressor.generate(SIZE);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new SnappyCompressor(), new SnappyDecompressor()).withCompressDecompressPair((SnappyCompressor)((Object)new Lz4Compressor()), (SnappyDecompressor)((Object)new Lz4Decompressor())).withCompressDecompressPair((SnappyCompressor)((Object)new BuiltInZlibDeflater()), (SnappyDecompressor)((Object)new BuiltInZlibInflater())).withTestCases(ImmutableSet.of(CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM)).test();
        }
        catch (Exception ex) {
            Assert.fail((String)("testCompressorDecompressor error !!!" + ex));
        }
    }

    @Test
    public void testCompressorDecompressorWithExeedBufferLimit() {
        int BYTE_SIZE = 102400;
        byte[] rawData = TestCompressorDecompressor.generate(BYTE_SIZE);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new SnappyCompressor(BYTE_SIZE + BYTE_SIZE / 2), new SnappyDecompressor(BYTE_SIZE + BYTE_SIZE / 2)).withCompressDecompressPair((SnappyCompressor)((Object)new Lz4Compressor(BYTE_SIZE)), (SnappyDecompressor)((Object)new Lz4Decompressor(BYTE_SIZE))).withTestCases(ImmutableSet.of(CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM)).test();
        }
        catch (Exception ex) {
            Assert.fail((String)("testCompressorDecompressorWithExeedBufferLimit error !!!" + ex));
        }
    }

    public static byte[] generate(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)rnd.nextInt(16);
        }
        return array;
    }
}

