/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import org.apache.flink.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.compress.CompressDecompressTester;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestZlibCompressorDecompressor {
    private static final Random random = new Random(12345L);

    @Before
    public void before() {
        Assume.assumeTrue((boolean)ZlibFactory.isNativeZlibLoaded(new Configuration()));
    }

    @Test
    public void testZlibCompressorDecompressor() {
        try {
            int SIZE = 45056;
            byte[] rawData = TestZlibCompressorDecompressor.generate(SIZE);
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new ZlibCompressor(), new ZlibDecompressor()).withTestCases(ImmutableSet.of(CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM)).test();
        }
        catch (Exception ex) {
            Assert.fail((String)("testCompressorDecompressor error !!!" + ex));
        }
    }

    @Test
    public void testCompressorDecompressorWithExeedBufferLimit() {
        int BYTE_SIZE = 102400;
        byte[] rawData = TestZlibCompressorDecompressor.generate(BYTE_SIZE);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new ZlibCompressor(ZlibCompressor.CompressionLevel.BEST_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.DEFAULT_HEADER, BYTE_SIZE), new ZlibDecompressor(ZlibDecompressor.CompressionHeader.DEFAULT_HEADER, BYTE_SIZE)).withTestCases(ImmutableSet.of(CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS, CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM)).test();
        }
        catch (Exception ex) {
            Assert.fail((String)("testCompressorDecompressorWithExeedBufferLimit error !!!" + ex));
        }
    }

    @Test
    public void testZlibCompressorDecompressorWithConfiguration() {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (ZlibFactory.isNativeZlibLoaded(conf)) {
            int tryNumber = 5;
            int BYTE_SIZE = 10240;
            Compressor zlibCompressor = ZlibFactory.getZlibCompressor(conf);
            Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor(conf);
            byte[] rawData = TestZlibCompressorDecompressor.generate(BYTE_SIZE);
            try {
                for (int i = 0; i < tryNumber; ++i) {
                    this.compressDecompressZlib(rawData, (ZlibCompressor)zlibCompressor, (ZlibDecompressor)zlibDecompressor);
                }
                zlibCompressor.reinit(conf);
            }
            catch (Exception ex) {
                Assert.fail((String)("testZlibCompressorDecompressorWithConfiguration ex error " + ex));
            }
        } else {
            Assert.assertTrue((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded(conf));
        }
    }

    @Test
    public void testZlibCompressDecompress() {
        byte[] rawData = null;
        int rawDataSize = 0;
        rawDataSize = 65536;
        rawData = TestZlibCompressorDecompressor.generate(rawDataSize);
        try {
            ZlibCompressor compressor = new ZlibCompressor();
            ZlibDecompressor decompressor = new ZlibDecompressor();
            Assert.assertFalse((String)"testZlibCompressDecompress finished error", (boolean)compressor.finished());
            compressor.setInput(rawData, 0, rawData.length);
            Assert.assertTrue((String)"testZlibCompressDecompress getBytesRead before error", (compressor.getBytesRead() == 0L ? 1 : 0) != 0);
            compressor.finish();
            byte[] compressedResult = new byte[rawDataSize];
            int cSize = compressor.compress(compressedResult, 0, rawDataSize);
            Assert.assertTrue((String)"testZlibCompressDecompress getBytesRead ather error", (compressor.getBytesRead() == (long)rawDataSize ? 1 : 0) != 0);
            Assert.assertTrue((String)"testZlibCompressDecompress compressed size no less then original size", (cSize < rawDataSize ? 1 : 0) != 0);
            decompressor.setInput(compressedResult, 0, cSize);
            byte[] decompressedBytes = new byte[rawDataSize];
            decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
            Assert.assertArrayEquals((String)"testZlibCompressDecompress arrays not equals ", (byte[])rawData, (byte[])decompressedBytes);
            compressor.reset();
            decompressor.reset();
        }
        catch (IOException ex) {
            Assert.fail((String)("testZlibCompressDecompress ex !!!" + ex));
        }
    }

    private void compressDecompressLoop(int rawDataSize) throws IOException {
        byte[] rawData = null;
        rawData = TestZlibCompressorDecompressor.generate(rawDataSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(rawDataSize + 12);
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        dos.write(rawData);
        dos.flush();
        dos.close();
        byte[] compressedResult = baos.toByteArray();
        int compressedSize = compressedResult.length;
        ZlibDecompressor.ZlibDirectDecompressor decompressor = new ZlibDecompressor.ZlibDirectDecompressor();
        ByteBuffer inBuf = ByteBuffer.allocateDirect(compressedSize);
        ByteBuffer outBuf = ByteBuffer.allocateDirect(rawDataSize);
        inBuf.put(compressedResult, 0, compressedSize);
        inBuf.flip();
        ByteBuffer expected = ByteBuffer.wrap(rawData);
        outBuf.clear();
        while (!decompressor.finished()) {
            decompressor.decompress(inBuf, outBuf);
            if (outBuf.remaining() != 0) continue;
            outBuf.flip();
            while (outBuf.remaining() > 0) {
                Assert.assertEquals((long)expected.get(), (long)outBuf.get());
            }
            outBuf.clear();
        }
        outBuf.flip();
        while (outBuf.remaining() > 0) {
            Assert.assertEquals((long)expected.get(), (long)outBuf.get());
        }
        outBuf.clear();
        Assert.assertEquals((long)0L, (long)expected.remaining());
    }

    @Test
    public void testZlibDirectCompressDecompress() {
        int[] size = new int[]{1, 4, 16, 4096, 65536, 131072, 0x100000};
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        try {
            for (int i = 0; i < size.length; ++i) {
                this.compressDecompressLoop(size[i]);
            }
        }
        catch (IOException ex) {
            Assert.fail((String)("testZlibDirectCompressDecompress ex !!!" + ex));
        }
    }

    @Test
    public void testZlibCompressorDecompressorSetDictionary() {
        Configuration conf = new Configuration();
        conf.setBoolean("io.native.lib.available", true);
        if (ZlibFactory.isNativeZlibLoaded(conf)) {
            Compressor zlibCompressor = ZlibFactory.getZlibCompressor(conf);
            Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor(conf);
            this.checkSetDictionaryNullPointerException(zlibCompressor);
            this.checkSetDictionaryNullPointerException(zlibDecompressor);
            this.checkSetDictionaryArrayIndexOutOfBoundsException(zlibDecompressor);
            this.checkSetDictionaryArrayIndexOutOfBoundsException(zlibCompressor);
        } else {
            Assert.assertTrue((String)"ZlibFactory is using native libs against request", (boolean)ZlibFactory.isNativeZlibLoaded(conf));
        }
    }

    @Test
    public void testZlibFactory() {
        Configuration cfg = new Configuration();
        Assert.assertTrue((String)"testZlibFactory compression level error !!!", (ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION == ZlibFactory.getCompressionLevel(cfg) ? 1 : 0) != 0);
        Assert.assertTrue((String)"testZlibFactory compression strategy error !!!", (ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY == ZlibFactory.getCompressionStrategy(cfg) ? 1 : 0) != 0);
        ZlibFactory.setCompressionLevel(cfg, ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        Assert.assertTrue((String)"testZlibFactory compression strategy error !!!", (ZlibCompressor.CompressionLevel.BEST_COMPRESSION == ZlibFactory.getCompressionLevel(cfg) ? 1 : 0) != 0);
        ZlibFactory.setCompressionStrategy(cfg, ZlibCompressor.CompressionStrategy.FILTERED);
        Assert.assertTrue((String)"testZlibFactory compression strategy error !!!", (ZlibCompressor.CompressionStrategy.FILTERED == ZlibFactory.getCompressionStrategy(cfg) ? 1 : 0) != 0);
    }

    private boolean checkSetDictionaryNullPointerException(Decompressor decompressor) {
        try {
            decompressor.setDictionary(null, 0, 1);
        }
        catch (NullPointerException ex) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryNullPointerException(Compressor compressor) {
        try {
            compressor.setDictionary(null, 0, 1);
        }
        catch (NullPointerException ex) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryArrayIndexOutOfBoundsException(Compressor compressor) {
        try {
            compressor.setDictionary(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryArrayIndexOutOfBoundsException(Decompressor decompressor) {
        try {
            decompressor.setDictionary(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private byte[] compressDecompressZlib(byte[] rawData, ZlibCompressor zlibCompressor, ZlibDecompressor zlibDecompressor) throws IOException {
        int cSize = 0;
        byte[] compressedByte = new byte[rawData.length];
        byte[] decompressedRawData = new byte[rawData.length];
        zlibCompressor.setInput(rawData, 0, rawData.length);
        zlibCompressor.finish();
        while (!zlibCompressor.finished()) {
            cSize = zlibCompressor.compress(compressedByte, 0, compressedByte.length);
        }
        zlibCompressor.reset();
        Assert.assertTrue((zlibDecompressor.getBytesWritten() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((zlibDecompressor.getBytesRead() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)zlibDecompressor.needsInput());
        zlibDecompressor.setInput(compressedByte, 0, cSize);
        Assert.assertFalse((boolean)zlibDecompressor.needsInput());
        while (!zlibDecompressor.finished()) {
            zlibDecompressor.decompress(decompressedRawData, 0, decompressedRawData.length);
        }
        Assert.assertTrue((zlibDecompressor.getBytesWritten() == (long)rawData.length ? 1 : 0) != 0);
        Assert.assertTrue((zlibDecompressor.getBytesRead() == (long)cSize ? 1 : 0) != 0);
        zlibDecompressor.reset();
        Assert.assertTrue((zlibDecompressor.getRemaining() == 0 ? 1 : 0) != 0);
        Assert.assertArrayEquals((String)"testZlibCompressorDecompressorWithConfiguration array equals error", (byte[])rawData, (byte[])decompressedRawData);
        return decompressedRawData;
    }

    @Test
    public void testBuiltInGzipDecompressorExceptions() {
        DataInputBuffer gzbuf;
        BuiltInGzipDecompressor decompressor;
        byte[] buffer;
        int buffSize;
        BuiltInGzipDecompressor decompresser = new BuiltInGzipDecompressor();
        try {
            decompresser.setInput(null, 0, 1);
        }
        catch (NullPointerException ex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("testBuiltInGzipDecompressorExceptions npe error " + ex));
        }
        try {
            decompresser.setInput(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("testBuiltInGzipDecompressorExceptions aioob error" + ex));
        }
        Assert.assertTrue((String)"decompresser.getBytesRead error", (decompresser.getBytesRead() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"decompresser.getRemaining error", (decompresser.getRemaining() == 0 ? 1 : 0) != 0);
        decompresser.reset();
        decompresser.end();
        DecompressorStream decompStream = null;
        try {
            buffSize = 1024;
            buffer = new byte[buffSize];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream(gzbuf, decompressor);
            gzbuf.reset(new byte[]{0, 0, 1, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException ioex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("invalid 0 and 1 byte in gzip stream" + ex));
        }
        try {
            buffSize = 1024;
            buffer = new byte[buffSize];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream(gzbuf, decompressor);
            gzbuf.reset(new byte[]{31, -117, 7, 1, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException ioex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("invalid 2 byte in gzip stream" + ex));
        }
        try {
            int buffSize2 = 1024;
            buffer = new byte[buffSize2];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream(gzbuf, decompressor);
            gzbuf.reset(new byte[]{31, -117, 8, -32, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException ioex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("invalid 3 byte in gzip stream" + ex));
        }
        try {
            int buffSize3 = 1024;
            buffer = new byte[buffSize3];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream(gzbuf, decompressor);
            gzbuf.reset(new byte[]{31, -117, 8, 4, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException ioex) {
        }
        catch (Exception ex) {
            Assert.fail((String)("invalid 3 byte make hasExtraField" + ex));
        }
    }

    public static byte[] generate(int size) {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)random.nextInt(16);
        }
        return data;
    }
}

