/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.JsonNode;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.MappingJsonFactory;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.flink.hadoop.shaded.org.codehaus.jackson.node.ContainerNode;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4Json
extends Layout {
    private static final JsonFactory factory = new MappingJsonFactory();
    public static final String DATE = "date";
    public static final String EXCEPTION_CLASS = "exceptionclass";
    public static final String LEVEL = "level";
    public static final String MESSAGE = "message";
    public static final String NAME = "name";
    public static final String STACK = "stack";
    public static final String THREAD = "thread";
    public static final String TIME = "time";
    public static final String JSON_TYPE = "application/json";
    private final DateFormat dateFormat = new ISO8601DateFormat();

    public String getContentType() {
        return JSON_TYPE;
    }

    public String format(LoggingEvent event) {
        try {
            return this.toJson(event);
        }
        catch (IOException e) {
            return "{ \"logfailure\":\"" + e.getClass().toString() + "\"}";
        }
    }

    public String toJson(LoggingEvent event) throws IOException {
        StringWriter writer = new StringWriter();
        this.toJson(writer, event);
        return writer.toString();
    }

    public Writer toJson(Writer writer, LoggingEvent event) throws IOException {
        ThrowableInformation ti = event.getThrowableInformation();
        this.toJson(writer, event.getLoggerName(), event.getTimeStamp(), event.getLevel().toString(), event.getThreadName(), event.getRenderedMessage(), ti);
        return writer;
    }

    public Writer toJson(Writer writer, String loggerName, long timeStamp, String level, String threadName, String message, ThrowableInformation ti) throws IOException {
        JsonGenerator json = factory.createJsonGenerator(writer);
        json.writeStartObject();
        json.writeStringField(NAME, loggerName);
        json.writeNumberField(TIME, timeStamp);
        Date date = new Date(timeStamp);
        json.writeStringField(DATE, this.dateFormat.format(date));
        json.writeStringField(LEVEL, level);
        json.writeStringField(THREAD, threadName);
        json.writeStringField(MESSAGE, message);
        if (ti != null) {
            Throwable thrown = ti.getThrowable();
            String eclass = thrown != null ? thrown.getClass().getName() : "";
            json.writeStringField(EXCEPTION_CLASS, eclass);
            String[] stackTrace = ti.getThrowableStrRep();
            json.writeArrayFieldStart(STACK);
            for (String row : stackTrace) {
                json.writeString(row);
            }
            json.writeEndArray();
        }
        json.writeEndObject();
        json.flush();
        json.close();
        return writer;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    public static ContainerNode parse(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper(factory);
        JsonNode jsonNode = mapper.readTree(json);
        if (!(jsonNode instanceof ContainerNode)) {
            throw new IOException("Wrong JSON data: " + json);
        }
        return (ContainerNode)jsonNode;
    }
}

