/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.org.jboss.netty.channel.DefaultFileRegion;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.nativeio.NativeIO;

public class FadvisedFileRegion
extends DefaultFileRegion {
    private static final Log LOG = LogFactory.getLog(FadvisedFileRegion.class);
    private final boolean manageOsCache;
    private final int readaheadLength;
    private final ReadaheadPool readaheadPool;
    private final FileDescriptor fd;
    private final String identifier;
    private final long count;
    private final long position;
    private final int shuffleBufferSize;
    private final boolean shuffleTransferToAllowed;
    private final FileChannel fileChannel;
    private ReadaheadPool.ReadaheadRequest readaheadRequest;

    public FadvisedFileRegion(RandomAccessFile file, long position, long count, boolean manageOsCache, int readaheadLength, ReadaheadPool readaheadPool, String identifier, int shuffleBufferSize, boolean shuffleTransferToAllowed) throws IOException {
        super(file.getChannel(), position, count);
        this.manageOsCache = manageOsCache;
        this.readaheadLength = readaheadLength;
        this.readaheadPool = readaheadPool;
        this.fd = file.getFD();
        this.identifier = identifier;
        this.fileChannel = file.getChannel();
        this.count = count;
        this.position = position;
        this.shuffleBufferSize = shuffleBufferSize;
        this.shuffleTransferToAllowed = shuffleTransferToAllowed;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        if (this.manageOsCache && this.readaheadPool != null) {
            this.readaheadRequest = this.readaheadPool.readaheadStream(this.identifier, this.fd, this.getPosition() + position, this.readaheadLength, this.getPosition() + this.getCount(), this.readaheadRequest);
        }
        if (this.shuffleTransferToAllowed) {
            return super.transferTo(target, position);
        }
        return this.customShuffleTransfer(target, position);
    }

    @VisibleForTesting
    long customShuffleTransfer(WritableByteChannel target, long position) throws IOException {
        int readSize;
        long actualCount = this.count - position;
        if (actualCount < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (actualCount == 0L) {
            return 0L;
        }
        long trans = actualCount;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.shuffleBufferSize);
        while (trans > 0L && (readSize = this.fileChannel.read(byteBuffer, this.position + position)) > 0) {
            if ((long)readSize < trans) {
                trans -= (long)readSize;
                position += (long)readSize;
                byteBuffer.flip();
            } else {
                byteBuffer.limit((int)trans);
                byteBuffer.position(0);
                position += trans;
                trans = 0L;
            }
            while (byteBuffer.hasRemaining()) {
                target.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return actualCount - trans;
    }

    @Override
    public void releaseExternalResources() {
        if (this.readaheadRequest != null) {
            this.readaheadRequest.cancel();
        }
        super.releaseExternalResources();
    }

    public void transferSuccessful() {
        if (this.manageOsCache && this.getCount() > 0L) {
            try {
                NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.identifier, this.fd, this.getPosition(), this.getCount(), 4);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Failed to manage OS cache for " + this.identifier), t);
            }
        }
    }
}

