/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ResourceMgrDelegate
extends YarnClient {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private YarnConfiguration conf;
    private ApplicationSubmissionContext application;
    private ApplicationId applicationId;
    @InterfaceAudience.Private
    @VisibleForTesting
    protected YarnClient client;
    private Text rmDTService;

    public ResourceMgrDelegate(YarnConfiguration conf) {
        super(ResourceMgrDelegate.class.getName());
        this.conf = conf;
        this.client = YarnClient.createYarnClient();
        this.init(conf);
        this.start();
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.client.init(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.client.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.client.stop();
        super.serviceStop();
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnNodes(this.client.getNodeReports(NodeState.RUNNING));
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        try {
            HashSet<String> appTypes = new HashSet<String>(1);
            appTypes.add("MAPREDUCE");
            EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
            return TypeConverter.fromYarnApps(this.client.getApplications(appTypes, appStates), this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        try {
            YarnClusterMetrics metrics = this.client.getYarnClusterMetrics();
            ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
            return oldMetrics;
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public Text getRMDelegationTokenService() {
        if (this.rmDTService == null) {
            this.rmDTService = ClientRMProxy.getRMDelegationTokenService(this.conf);
        }
        return this.rmDTService;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        try {
            return ConverterUtils.convertFromYarn(this.client.getRMDelegationToken(renewer), this.getRMDelegationTokenService());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get(this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        try {
            this.application = this.client.createApplication().getApplicationSubmissionContext();
            this.applicationId = this.application.getApplicationId();
            return TypeConverter.fromYarn(this.applicationId);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        try {
            org.apache.hadoop.yarn.api.records.QueueInfo queueInfo = this.client.getQueueInfo(queueName);
            return queueInfo == null ? null : TypeConverter.fromYarn(queueInfo, this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueUserAclsInfo(this.client.getQueueAclsInfo());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo(this.client.getAllQueues(), this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo(this.client.getRootQueueInfos(), this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        try {
            return TypeConverter.fromYarnQueueInfo(this.client.getChildQueueInfos(parent), this.conf);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir(this.conf, user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        return this.client.createApplication();
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        return this.client.submitApplication(appContext);
    }

    @Override
    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        this.client.killApplication(applicationId);
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return this.client.getApplicationReport(appId);
    }

    @Override
    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.client.getApplications();
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        return this.client.getApplications(applicationTypes);
    }

    @Override
    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.client.getApplications(applicationStates);
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        return this.client.getApplications(applicationTypes, applicationStates);
    }

    @Override
    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        return this.client.getYarnClusterMetrics();
    }

    @Override
    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        return this.client.getNodeReports(states);
    }

    @Override
    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        return this.client.getRMDelegationToken(renewer);
    }

    @Override
    public org.apache.hadoop.yarn.api.records.QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        return this.client.getQueueInfo(queueName);
    }

    @Override
    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getAllQueues() throws YarnException, IOException {
        return this.client.getAllQueues();
    }

    @Override
    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        return this.client.getRootQueueInfos();
    }

    @Override
    public List<org.apache.hadoop.yarn.api.records.QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        return this.client.getChildQueueInfos(parent);
    }

    @Override
    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        return this.client.getQueueAclsInfo();
    }

    @Override
    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        return this.client.getApplicationAttemptReport(appAttemptId);
    }

    @Override
    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        return this.client.getApplicationAttempts(appId);
    }

    @Override
    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        return this.client.getContainerReport(containerId);
    }

    @Override
    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        return this.client.getContainers(applicationAttemptId);
    }

    @Override
    public void moveApplicationAcrossQueues(ApplicationId appId, String queue) throws YarnException, IOException {
        this.client.moveApplicationAcrossQueues(appId, queue);
    }
}

