/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.junit.Test;

public class TestClientRedirect {
    private static final Log LOG;
    private static final String RMADDRESS = "0.0.0.0:8054";
    private static final RecordFactory recordFactory;
    private static final String AMHOSTADDRESS = "0.0.0.0:10020";
    private static final String HSHOSTADDRESS = "0.0.0.0:10021";
    private volatile boolean amContact = false;
    private volatile boolean hsContact = false;
    private volatile boolean amRunning = false;
    private volatile boolean amRestarting = false;

    @Test
    public void testRedirect() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.set("yarn.resourcemanager.address", RMADDRESS);
        conf.set("mapreduce.jobhistory.address", HSHOSTADDRESS);
        RMService rmService = new RMService("test");
        rmService.init(conf);
        rmService.start();
        AMService amService = new AMService();
        amService.init(conf);
        amService.start(conf);
        HistoryService historyService = new HistoryService();
        historyService.init(conf);
        historyService.start(conf);
        LOG.info((Object)"services started");
        Cluster cluster = new Cluster(conf);
        JobID jobID = new JobID("201103121733", 1);
        Counters counters = cluster.getJob(jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.amContact);
        LOG.info((Object)"Sleeping for 5 seconds before stop for the client socket to not get EOF immediately..");
        Thread.sleep(5000L);
        amService.stop();
        LOG.info((Object)"Sleeping for 5 seconds after stop for the server to exit cleanly..");
        Thread.sleep(5000L);
        this.amRestarting = true;
        counters = cluster.getJob(jobID).getCounters();
        Assert.assertEquals((int)0, (int)counters.countCounters());
        Job job = cluster.getJob(jobID);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobID, TaskType.MAP, 0);
        TaskAttemptID tId = new TaskAttemptID(taskId, 0);
        job.killJob();
        job.killTask(tId);
        job.failTask(tId);
        job.getTaskCompletionEvents(0, 100);
        job.getStatus();
        job.getTaskDiagnostics(tId);
        job.getTaskReports(TaskType.MAP);
        job.getTrackingURL();
        this.amRestarting = false;
        amService = new AMService();
        amService.init(conf);
        amService.start(conf);
        this.amContact = false;
        counters = cluster.getJob(jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.amContact);
        amService.stop();
        counters = cluster.getJob(jobID).getCounters();
        this.validateCounters(counters);
        Assert.assertTrue((boolean)this.hsContact);
        rmService.stop();
        historyService.stop();
    }

    private void validateCounters(Counters counters) {
        for (CounterGroup group : counters) {
            LOG.info((Object)("Group " + group.getDisplayName()));
            Iterator itc = group.iterator();
            while (itc.hasNext()) {
                LOG.info((Object)("Counter is " + ((Counter)itc.next()).getDisplayName()));
            }
        }
        Assert.assertEquals((int)1, (int)counters.countCounters());
    }

    static org.apache.hadoop.mapreduce.v2.api.records.Counters getMyCounters() {
        org.apache.hadoop.mapreduce.v2.api.records.Counter counter = recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counter.class);
        counter.setName("Mycounter");
        counter.setDisplayName("My counter display name");
        counter.setValue(12345L);
        org.apache.hadoop.mapreduce.v2.api.records.CounterGroup group = recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.CounterGroup.class);
        group.setName("MyGroup");
        group.setDisplayName("My groupd display name");
        group.setCounter("myCounter", counter);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = recordFactory.newRecordInstance(org.apache.hadoop.mapreduce.v2.api.records.Counters.class);
        counters.setCounterGroup("myGroupd", group);
        return counters;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode(true);
        LOG = LogFactory.getLog(TestClientRedirect.class);
        recordFactory = RecordFactoryProvider.getRecordFactory(null);
    }

    class AMService
    extends AbstractService
    implements MRClientProtocol {
        protected Class<?> protocol;
        private InetSocketAddress bindAddress;
        private Server server;
        private final String hostAddress;

        public AMService() {
            this(TestClientRedirect.AMHOSTADDRESS);
        }

        @Override
        public InetSocketAddress getConnectAddress() {
            return this.bindAddress;
        }

        public AMService(String hostAddress) {
            super("AMService");
            this.protocol = MRClientProtocol.class;
            this.hostAddress = hostAddress;
        }

        public void start(Configuration conf) {
            YarnRPC rpc = YarnRPC.create(conf);
            InetSocketAddress address = NetUtils.createSocketAddr(this.hostAddress);
            InetAddress hostNameResolved = null;
            try {
                address.getAddress();
                hostNameResolved = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new YarnRuntimeException(e);
            }
            this.server = rpc.getServer(this.protocol, this, address, conf, null, 1);
            this.server.start();
            this.bindAddress = NetUtils.getConnectAddress(this.server);
            super.start();
            TestClientRedirect.this.amRunning = true;
        }

        @Override
        protected void serviceStop() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
            super.serviceStop();
            TestClientRedirect.this.amRunning = false;
        }

        @Override
        public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
            JobId jobID = request.getJobId();
            TestClientRedirect.this.amContact = true;
            org.apache.hadoop.mapreduce.v2.api.records.Counters counters = TestClientRedirect.getMyCounters();
            GetCountersResponse response = recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(counters);
            return response;
        }

        @Override
        public GetJobReportResponse getJobReport(GetJobReportRequest request) throws IOException {
            TestClientRedirect.this.amContact = true;
            JobReport jobReport = recordFactory.newRecordInstance(JobReport.class);
            jobReport.setJobId(request.getJobId());
            jobReport.setJobState(JobState.RUNNING);
            jobReport.setJobName("TestClientRedirect-jobname");
            jobReport.setUser("TestClientRedirect-user");
            jobReport.setStartTime(0L);
            jobReport.setFinishTime(1L);
            GetJobReportResponse response = recordFactory.newRecordInstance(GetJobReportResponse.class);
            response.setJobReport(jobReport);
            return response;
        }

        @Override
        public GetTaskReportResponse getTaskReport(GetTaskReportRequest request) throws IOException {
            return null;
        }

        @Override
        public GetTaskAttemptReportResponse getTaskAttemptReport(GetTaskAttemptReportRequest request) throws IOException {
            return null;
        }

        @Override
        public GetTaskAttemptCompletionEventsResponse getTaskAttemptCompletionEvents(GetTaskAttemptCompletionEventsRequest request) throws IOException {
            return null;
        }

        @Override
        public GetTaskReportsResponse getTaskReports(GetTaskReportsRequest request) throws IOException {
            return null;
        }

        @Override
        public GetDiagnosticsResponse getDiagnostics(GetDiagnosticsRequest request) throws IOException {
            return null;
        }

        @Override
        public KillJobResponse killJob(KillJobRequest request) throws IOException {
            return recordFactory.newRecordInstance(KillJobResponse.class);
        }

        @Override
        public KillTaskResponse killTask(KillTaskRequest request) throws IOException {
            return null;
        }

        @Override
        public KillTaskAttemptResponse killTaskAttempt(KillTaskAttemptRequest request) throws IOException {
            return null;
        }

        @Override
        public FailTaskAttemptResponse failTaskAttempt(FailTaskAttemptRequest request) throws IOException {
            return null;
        }

        @Override
        public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws IOException {
            return null;
        }

        @Override
        public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws IOException {
            return null;
        }

        @Override
        public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws IOException {
            return null;
        }
    }

    class HistoryService
    extends AMService
    implements HSClientProtocol {
        public HistoryService() {
            super(TestClientRedirect.HSHOSTADDRESS);
            this.protocol = HSClientProtocol.class;
        }

        @Override
        public GetCountersResponse getCounters(GetCountersRequest request) throws IOException {
            TestClientRedirect.this.hsContact = true;
            org.apache.hadoop.mapreduce.v2.api.records.Counters counters = TestClientRedirect.getMyCounters();
            GetCountersResponse response = recordFactory.newRecordInstance(GetCountersResponse.class);
            response.setCounters(counters);
            return response;
        }
    }

    class RMService
    extends AbstractService
    implements ApplicationClientProtocol {
        private String clientServiceBindAddress;
        InetSocketAddress clientBindAddress;
        private Server server;

        public RMService(String name) {
            super(name);
        }

        @Override
        protected void serviceInit(Configuration conf) throws Exception {
            this.clientServiceBindAddress = TestClientRedirect.RMADDRESS;
            this.clientBindAddress = NetUtils.createSocketAddr(this.clientServiceBindAddress);
            super.serviceInit(conf);
        }

        @Override
        protected void serviceStart() throws Exception {
            YarnRPC rpc = YarnRPC.create(this.getConfig());
            Configuration clientServerConf = new Configuration(this.getConfig());
            this.server = rpc.getServer(ApplicationClientProtocol.class, this, this.clientBindAddress, clientServerConf, null, 1);
            this.server.start();
            super.serviceStart();
        }

        @Override
        public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws IOException {
            return null;
        }

        @Override
        public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws IOException {
            ApplicationId applicationId = request.getApplicationId();
            ApplicationReport application = recordFactory.newRecordInstance(ApplicationReport.class);
            application.setApplicationId(applicationId);
            application.setFinalApplicationStatus(FinalApplicationStatus.UNDEFINED);
            if (TestClientRedirect.this.amRunning) {
                application.setYarnApplicationState(YarnApplicationState.RUNNING);
            } else if (TestClientRedirect.this.amRestarting) {
                application.setYarnApplicationState(YarnApplicationState.SUBMITTED);
            } else {
                application.setYarnApplicationState(YarnApplicationState.FINISHED);
                application.setFinalApplicationStatus(FinalApplicationStatus.SUCCEEDED);
            }
            String[] split = TestClientRedirect.AMHOSTADDRESS.split(":");
            application.setHost(split[0]);
            application.setRpcPort(Integer.parseInt(split[1]));
            application.setUser("TestClientRedirect-user");
            application.setName("N/A");
            application.setQueue("N/A");
            application.setStartTime(0L);
            application.setFinishTime(0L);
            application.setTrackingUrl("N/A");
            application.setDiagnostics("N/A");
            GetApplicationReportResponse response = recordFactory.newRecordInstance(GetApplicationReportResponse.class);
            response.setApplicationReport(application);
            return response;
        }

        @Override
        public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws IOException {
            throw new IOException("Test");
        }

        @Override
        public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws IOException {
            return KillApplicationResponse.newInstance(true);
        }

        @Override
        public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws IOException {
            return null;
        }

        @Override
        public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws IOException {
            return null;
        }

        @Override
        public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws IOException {
            return null;
        }

        @Override
        public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws IOException {
            return null;
        }

        @Override
        public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws IOException {
            return null;
        }

        @Override
        public org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse getDelegationToken(org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest request) throws IOException {
            return null;
        }

        @Override
        public org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse renewDelegationToken(org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest request) throws IOException {
            return null;
        }

        @Override
        public org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse cancelDelegationToken(org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest request) throws IOException {
            return null;
        }

        @Override
        public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
            return null;
        }

        @Override
        public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
            return null;
        }

        @Override
        public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
            return null;
        }

        @Override
        public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
            return null;
        }

        @Override
        public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

