/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.JavaSerializationComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.Utils;

public class TestJavaSerialization
extends TestCase {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private final Path INPUT_DIR = new Path(TEST_ROOT_DIR + "/input");
    private final Path OUTPUT_DIR = new Path(TEST_ROOT_DIR + "/out");
    private final Path INPUT_FILE = new Path(this.INPUT_DIR, "inp");

    private void cleanAndCreateInput(FileSystem fs) throws IOException {
        fs.delete(this.INPUT_FILE, true);
        fs.delete(this.OUTPUT_DIR, true);
        FSDataOutputStream os = fs.create(this.INPUT_FILE);
        OutputStreamWriter wr = new OutputStreamWriter(os);
        wr.write("b a\n");
        ((Writer)wr).close();
    }

    public void testMapReduceJob() throws Exception {
        JobConf conf = new JobConf(TestJavaSerialization.class);
        conf.setJobName("JavaSerialization");
        FileSystem fs = FileSystem.get(conf);
        this.cleanAndCreateInput(fs);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        conf.set("mapreduce.framework.name", "local");
        FileInputFormat.setInputPaths(conf, this.INPUT_DIR);
        FileOutputFormat.setOutputPath(conf, this.OUTPUT_DIR);
        JobClient.runJob(conf);
        Path[] outputFiles = FileUtil.stat2Paths(fs.listStatus(this.OUTPUT_DIR, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        TestJavaSerialization.assertEquals((int)1, (int)outputFiles.length);
        FSDataInputStream is = fs.open(outputFiles[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        TestJavaSerialization.assertEquals((String)"a\t1", (String)reader.readLine());
        TestJavaSerialization.assertEquals((String)"b\t1", (String)reader.readLine());
        TestJavaSerialization.assertNull((Object)reader.readLine());
        reader.close();
    }

    public void testWriteToSequencefile() throws Exception {
        JobConf conf = new JobConf(TestJavaSerialization.class);
        conf.setJobName("JavaSerialization");
        FileSystem fs = FileSystem.get(conf);
        this.cleanAndCreateInput(fs);
        conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SequenceFileOutputFormat.class);
        conf.setOutputKeyClass(String.class);
        conf.setOutputValueClass(Long.class);
        conf.setOutputKeyComparatorClass(JavaSerializationComparator.class);
        conf.setMapperClass(WordCountMapper.class);
        conf.setReducerClass(SumReducer.class);
        conf.set("mapreduce.framework.name", "local");
        FileInputFormat.setInputPaths(conf, this.INPUT_DIR);
        FileOutputFormat.setOutputPath(conf, this.OUTPUT_DIR);
        JobClient.runJob(conf);
        Path[] outputFiles = FileUtil.stat2Paths(fs.listStatus(this.OUTPUT_DIR, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        TestJavaSerialization.assertEquals((int)1, (int)outputFiles.length);
    }

    static class SumReducer<K>
    extends MapReduceBase
    implements Reducer<K, Long, K, Long> {
        SumReducer() {
        }

        @Override
        public void reduce(K key, Iterator<Long> values, OutputCollector<K, Long> output, Reporter reporter) throws IOException {
            long sum = 0L;
            while (values.hasNext()) {
                sum += values.next().longValue();
            }
            output.collect(key, sum);
        }
    }

    static class WordCountMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, String, Long> {
        WordCountMapper() {
        }

        @Override
        public void map(LongWritable key, Text value, OutputCollector<String, Long> output, Reporter reporter) throws IOException {
            StringTokenizer st = new StringTokenizer(value.toString());
            while (st.hasMoreTokens()) {
                output.collect(st.nextToken(), 1L);
            }
        }
    }
}

