/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestMapProgress
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestMapProgress.class);
    private static String TEST_ROOT_DIR;
    private FileSystem fs = null;
    private TestMapTask map = null;
    private JobID jobId = null;
    private FakeUmbilical fakeUmbilical = new FakeUmbilical();

    private void createInputFile(Path rootDir) throws IOException {
        if (this.fs.exists(rootDir)) {
            this.fs.delete(rootDir, true);
        }
        String str = "The quick brown fox\nThe brown quick fox\nThe fox brown quick\n";
        FSDataOutputStream inpFile = this.fs.create(new Path(rootDir, "part-0"));
        inpFile.writeBytes(str);
        ((FilterOutputStream)inpFile).close();
    }

    public void testMapProgress() throws Exception {
        JobConf job = new JobConf();
        this.fs = FileSystem.getLocal(job);
        Path rootDir = new Path(TEST_ROOT_DIR);
        this.createInputFile(rootDir);
        job.setNumReduceTasks(0);
        TaskAttemptID taskId = TaskAttemptID.forName("attempt_200907082313_0424_m_000000_0");
        job.setClass("mapreduce.job.outputformat.class", NullOutputFormat.class, OutputFormat.class);
        job.set("mapreduce.input.fileinputformat.inputdir", TEST_ROOT_DIR);
        this.jobId = taskId.getJobID();
        JobContextImpl jContext = new JobContextImpl(job, (org.apache.hadoop.mapreduce.JobID)this.jobId);
        InputFormat<?, ?> input = ReflectionUtils.newInstance(jContext.getInputFormatClass(), job);
        List<InputSplit> splits = input.getSplits(jContext);
        JobSplitWriter.createSplitFiles(new Path(TEST_ROOT_DIR), (Configuration)job, new Path(TEST_ROOT_DIR).getFileSystem(job), splits);
        JobSplit.TaskSplitMetaInfo[] splitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo(this.jobId, this.fs, job, new Path(TEST_ROOT_DIR));
        job.setUseNewMapper(true);
        for (int i = 0; i < splitMetaInfo.length; ++i) {
            this.map = new TestMapTask(job.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system") + this.jobId + "job.xml", taskId, i, splitMetaInfo[i].getSplitIndex(), 1);
            JobConf localConf = new JobConf(job);
            this.map.localizeConfiguration(localConf);
            this.map.setConf(localConf);
            this.map.run(localConf, this.fakeUmbilical);
        }
        this.fs.delete(rootDir, true);
    }

    static {
        String root = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        TEST_ROOT_DIR = new Path(root, "mapPhaseprogress").toString();
    }

    class TestMapTask
    extends MapTask {
        public TestMapTask(String jobFile, TaskAttemptID taskId, int partition, JobSplit.TaskSplitIndex splitIndex, int numSlotsRequired) {
            super(jobFile, taskId, partition, splitIndex, numSlotsRequired);
        }

        @Override
        Task.TaskReporter startReporter(TaskUmbilicalProtocol umbilical) {
            TestTaskReporter reporter = new TestTaskReporter(TestMapProgress.this.map);
            return reporter;
        }
    }

    public class TestTaskReporter
    extends Task.TaskReporter {
        private int recordNum;

        TestTaskReporter(Task task) {
            Task task2 = task;
            task2.getClass();
            super(task2, task.getProgress(), TestMapProgress.this.fakeUmbilical);
            this.recordNum = 0;
        }

        @Override
        public void setProgress(float progress) {
            super.setProgress(progress);
            float mapTaskProgress = TestMapProgress.this.map.getProgress().getProgress();
            LOG.info((Object)("Map task progress is " + mapTaskProgress));
            if (this.recordNum < 3) {
                ++this.recordNum;
            } else {
                return;
            }
            Assert.assertTrue((String)"Map progress is not the expected value.", ((double)Math.abs(mapTaskProgress - (float)this.recordNum / 3.0f) < 0.001 ? 1 : 0) != 0);
        }
    }

    static class FakeUmbilical
    implements TaskUmbilicalProtocol {
        FakeUmbilical() {
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        @Override
        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature(this, protocol, clientVersion, clientMethodsHash);
        }

        @Override
        public void done(TaskAttemptID taskid) throws IOException {
            LOG.info((Object)("Task " + taskid + " reporting done."));
        }

        @Override
        public void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting file system error: " + message));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting shuffle error: " + message));
        }

        @Override
        public void fatalError(TaskAttemptID taskId, String msg) throws IOException {
            LOG.info((Object)("Task " + taskId + " reporting fatal error: " + msg));
        }

        @Override
        public JvmTask getTask(JvmContext context) throws IOException {
            return null;
        }

        @Override
        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskId, taskStatus);
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return true;
        }

        @Override
        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            StringBuffer buf = new StringBuffer("Task ");
            buf.append(taskId);
            buf.append(" making progress to ");
            buf.append(taskStatus.getProgress());
            String state = taskStatus.getStateString();
            if (state != null) {
                buf.append(" and state of ");
                buf.append(state);
            }
            LOG.info((Object)buf.toString());
            return true;
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
            LOG.info((Object)("Task " + taskid + " has problem " + trace));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }
    }
}

