/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.mapred.StatisticsCollector;

public class TestStatisticsCollector
extends TestCase {
    public void testMovingWindow() throws Exception {
        StatisticsCollector collector = new StatisticsCollector(1);
        StatisticsCollector.TimeWindow window = new StatisticsCollector.TimeWindow("test", 6, 2);
        StatisticsCollector.TimeWindow sincStart = StatisticsCollector.SINCE_START;
        StatisticsCollector.TimeWindow[] windows = new StatisticsCollector.TimeWindow[]{sincStart, window};
        StatisticsCollector.Stat stat = collector.createStat("m1", windows);
        stat.inc(3);
        collector.update();
        TestStatisticsCollector.assertEquals((int)0, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)3, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(3);
        collector.update();
        TestStatisticsCollector.assertEquals((int)6, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)6, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(10);
        collector.update();
        TestStatisticsCollector.assertEquals((int)6, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)16, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(10);
        collector.update();
        TestStatisticsCollector.assertEquals((int)26, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)26, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(10);
        collector.update();
        stat.inc(10);
        collector.update();
        TestStatisticsCollector.assertEquals((int)46, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)46, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(10);
        collector.update();
        TestStatisticsCollector.assertEquals((int)46, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)56, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(12);
        collector.update();
        TestStatisticsCollector.assertEquals((int)62, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)68, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(13);
        collector.update();
        TestStatisticsCollector.assertEquals((int)62, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)81, (int)stat.getValues().get(sincStart).getValue());
        stat.inc(14);
        collector.update();
        TestStatisticsCollector.assertEquals((int)69, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)95, (int)stat.getValues().get(sincStart).getValue());
        Map<StatisticsCollector.TimeWindow, StatisticsCollector.StatUpdater> updaters = collector.getUpdaters();
        TestStatisticsCollector.assertEquals((int)updaters.size(), (int)2);
        Map<String, StatisticsCollector.Stat> ststistics = collector.getStatistics();
        TestStatisticsCollector.assertNotNull((Object)ststistics.get("m1"));
        StatisticsCollector.Stat newStat = collector.createStat("m2");
        TestStatisticsCollector.assertEquals((String)newStat.name, (String)"m2");
        StatisticsCollector.Stat st = collector.removeStat("m1");
        TestStatisticsCollector.assertEquals((String)st.name, (String)"m1");
        TestStatisticsCollector.assertEquals((int)69, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)95, (int)stat.getValues().get(sincStart).getValue());
        st = collector.removeStat("m1");
        TestStatisticsCollector.assertNull((Object)st);
        collector.start();
        Thread.sleep(2500L);
        TestStatisticsCollector.assertEquals((int)69, (int)stat.getValues().get(window).getValue());
        TestStatisticsCollector.assertEquals((int)95, (int)stat.getValues().get(sincStart).getValue());
    }
}

