/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.pipes.Application;
import org.apache.hadoop.mapred.pipes.PipesMapRunner;
import org.apache.hadoop.mapred.pipes.PipesPartitioner;
import org.apache.hadoop.mapred.pipes.PipesReducer;
import org.apache.hadoop.mapred.pipes.Submitter;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;

public class TestPipeApplication {
    private static File workSpace = new File("target", TestPipeApplication.class.getName() + "-workSpace");
    private static String taskName = "attempt_001_02_r03_04_05";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunner() throws Exception {
        File[] psw = this.cleanTokenPasswordFile();
        try {
            ReaderPipesMapRunner rReader = new ReaderPipesMapRunner();
            JobConf conf = new JobConf();
            conf.set("mapreduce.pipes.isjavarecordreader", "true");
            conf.set("mapreduce.task.attempt.id", taskName);
            CombineOutputCollector<IntWritable, Text> output = new CombineOutputCollector<IntWritable, Text>(new Counters.Counter(), new Progress());
            RawLocalFileSystem fs = new RawLocalFileSystem();
            fs.setConf(conf);
            IFile.Writer<IntWritable, Text> wr = new IFile.Writer<IntWritable, Text>(conf, fs, new Path(workSpace + File.separator + "outfile"), IntWritable.class, Text.class, null, null);
            output.setWriter(wr);
            File fCommand = this.getFileCommand("org.apache.hadoop.mapred.pipes.PipeApplicationRunnableStub");
            conf.set("mapreduce.job.cache.local.files", fCommand.getAbsolutePath());
            Token token = new Token("user".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
            TokenCache.setJobToken(token, conf.getCredentials());
            conf.setBoolean("mapreduce.job.skiprecords", true);
            TestTaskReporter reporter = new TestTaskReporter();
            PipesMapRunner<FloatWritable, NullWritable, IntWritable, Text> runner = new PipesMapRunner<FloatWritable, NullWritable, IntWritable, Text>();
            this.initStdOut(conf);
            runner.configure(conf);
            runner.run(rReader, output, reporter);
            String stdOut = this.readStdOut(conf);
            Assert.assertTrue((boolean)stdOut.contains("CURRENT_PROTOCOL_VERSION:0"));
            Assert.assertTrue((boolean)stdOut.contains("Key class:org.apache.hadoop.io.FloatWritable"));
            Assert.assertTrue((boolean)stdOut.contains("Value class:org.apache.hadoop.io.NullWritable"));
            Assert.assertTrue((boolean)stdOut.contains("value:0.0"));
            Assert.assertTrue((boolean)stdOut.contains("value:9.0"));
        }
        finally {
            if (psw != null) {
                for (File file : psw) {
                    file.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApplication() throws Throwable {
        JobConf conf = new JobConf();
        Reader rReader = new Reader();
        File fCommand = this.getFileCommand("org.apache.hadoop.mapred.pipes.PipeApplicationStub");
        TestTaskReporter reporter = new TestTaskReporter();
        File[] psw = this.cleanTokenPasswordFile();
        try {
            conf.set("mapreduce.task.attempt.id", taskName);
            conf.set("mapreduce.job.cache.local.files", fCommand.getAbsolutePath());
            Token token = new Token("user".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
            TokenCache.setJobToken(token, conf.getCredentials());
            FakeCollector output = new FakeCollector(new Counters.Counter(), new Progress());
            RawLocalFileSystem fs = new RawLocalFileSystem();
            fs.setConf(conf);
            IFile.Writer<IntWritable, Text> wr = new IFile.Writer<IntWritable, Text>(conf, fs, new Path(workSpace.getAbsolutePath() + File.separator + "outfile"), IntWritable.class, Text.class, null, null);
            output.setWriter(wr);
            conf.set("mapreduce.pipes.commandfile.preserve", "true");
            Application application = new Application(conf, rReader, output, reporter, IntWritable.class, Text.class);
            application.getDownlink().flush();
            application.getDownlink().mapItem(new IntWritable(3), new Text("txt"));
            application.getDownlink().flush();
            application.waitForFinish();
            wr.close();
            String stdOut = this.readStdOut(conf);
            Assert.assertTrue((boolean)stdOut.contains("key:3"));
            Assert.assertTrue((boolean)stdOut.contains("value:txt"));
            Assert.assertEquals((double)1.0, (double)reporter.getProgress(), (double)0.01);
            Assert.assertNotNull((Object)reporter.getCounter("group", "name"));
            Assert.assertEquals((Object)reporter.getStatus(), (Object)"PROGRESS");
            stdOut = this.readFile(new File(workSpace.getAbsolutePath() + File.separator + "outfile"));
            Assert.assertEquals((double)0.55f, (double)rReader.getProgress(), (double)0.001);
            application.getDownlink().close();
            Map.Entry<IntWritable, Text> entry = output.getCollect().entrySet().iterator().next();
            Assert.assertEquals((long)123L, (long)entry.getKey().get());
            Assert.assertEquals((Object)"value", (Object)entry.getValue().toString());
            try {
                application.abort(new Throwable());
                Assert.fail();
            }
            catch (IOException e) {
                Assert.assertEquals((Object)"pipe child exception", (Object)e.getMessage());
            }
        }
        finally {
            if (psw != null) {
                for (File file : psw) {
                    file.deleteOnExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubmitter() throws Exception {
        PrintStream oldps;
        SecurityManager securityManager;
        block12: {
            JobConf conf = new JobConf();
            File[] psw = this.cleanTokenPasswordFile();
            System.setProperty("test.build.data", "target/tmp/build/TEST_SUBMITTER_MAPPER/data");
            conf.set("hadoop.log.dir", "target/tmp");
            Submitter.setIsJavaMapper(conf, false);
            Submitter.setIsJavaReducer(conf, false);
            Submitter.setKeepCommandFile(conf, false);
            Submitter.setIsJavaRecordReader(conf, false);
            Submitter.setIsJavaRecordWriter(conf, false);
            PipesPartitioner partitioner = new PipesPartitioner();
            partitioner.configure(conf);
            Submitter.setJavaPartitioner(conf, partitioner.getClass());
            Assert.assertEquals(PipesPartitioner.class, Submitter.getJavaPartitioner(conf));
            securityManager = System.getSecurityManager();
            oldps = System.out;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ExitUtil.disableSystemExit();
            try {
                System.setOut(new PrintStream(out));
                Submitter.main(new String[0]);
                Assert.fail();
            }
            catch (ExitUtil.ExitException e) {
                Assert.assertTrue((boolean)out.toString().contains(""));
                Assert.assertTrue((boolean)out.toString().contains("bin/hadoop pipes"));
                Assert.assertTrue((boolean)out.toString().contains("[-input <path>] // Input directory"));
                Assert.assertTrue((boolean)out.toString().contains("[-output <path>] // Output directory"));
                Assert.assertTrue((boolean)out.toString().contains("[-jar <jar file> // jar filename"));
                Assert.assertTrue((boolean)out.toString().contains("[-inputformat <class>] // InputFormat class"));
                Assert.assertTrue((boolean)out.toString().contains("[-map <class>] // Java Map class"));
                Assert.assertTrue((boolean)out.toString().contains("[-partitioner <class>] // Java Partitioner"));
                Assert.assertTrue((boolean)out.toString().contains("[-reduce <class>] // Java Reduce class"));
                Assert.assertTrue((boolean)out.toString().contains("[-writer <class>] // Java RecordWriter"));
                Assert.assertTrue((boolean)out.toString().contains("[-program <executable>] // executable URI"));
                Assert.assertTrue((boolean)out.toString().contains("[-reduces <num>] // number of reduces"));
                Assert.assertTrue((boolean)out.toString().contains("[-lazyOutput <true/false>] // createOutputLazily"));
                Assert.assertTrue((boolean)out.toString().contains("-conf <configuration file>     specify an application configuration file"));
                Assert.assertTrue((boolean)out.toString().contains("-D <property=value>            use value for given property"));
                Assert.assertTrue((boolean)out.toString().contains("-fs <local|namenode:port>      specify a namenode"));
                Assert.assertTrue((boolean)out.toString().contains("-jt <local|jobtracker:port>    specify a job tracker"));
                Assert.assertTrue((boolean)out.toString().contains("-files <comma separated list of files>    specify comma separated files to be copied to the map reduce cluster"));
                Assert.assertTrue((boolean)out.toString().contains("-libjars <comma separated list of jars>    specify comma separated jar files to include in the classpath."));
                Assert.assertTrue((boolean)out.toString().contains("-archives <comma separated list of archives>    specify comma separated archives to be unarchived on the compute machines."));
            }
            finally {
                System.setOut(oldps);
                System.setSecurityManager(securityManager);
                if (psw == null) break block12;
                for (File file : psw) {
                    file.deleteOnExit();
                }
            }
        }
        try {
            File fCommand = this.getFileCommand(null);
            String[] args = new String[22];
            File input = new File(workSpace + File.separator + "input");
            if (!input.exists()) {
                Assert.assertTrue((boolean)input.createNewFile());
            }
            File outPut = new File(workSpace + File.separator + "output");
            FileUtil.fullyDelete(outPut);
            args[0] = "-input";
            args[1] = input.getAbsolutePath();
            args[2] = "-output";
            args[3] = outPut.getAbsolutePath();
            args[4] = "-inputformat";
            args[5] = "org.apache.hadoop.mapred.TextInputFormat";
            args[6] = "-map";
            args[7] = "org.apache.hadoop.mapred.lib.IdentityMapper";
            args[8] = "-partitioner";
            args[9] = "org.apache.hadoop.mapred.pipes.PipesPartitioner";
            args[10] = "-reduce";
            args[11] = "org.apache.hadoop.mapred.lib.IdentityReducer";
            args[12] = "-writer";
            args[13] = "org.apache.hadoop.mapred.TextOutputFormat";
            args[14] = "-program";
            args[15] = fCommand.getAbsolutePath();
            args[16] = "-reduces";
            args[17] = "2";
            args[18] = "-lazyOutput";
            args[19] = "lazyOutput";
            args[20] = "-jobconf";
            args[21] = "mapreduce.pipes.isjavarecordwriter=false,mapreduce.pipes.isjavarecordreader=false";
            Submitter.main(args);
            Assert.fail();
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)e.status, (long)0L);
        }
        finally {
            System.setOut(oldps);
            System.setSecurityManager(securityManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipesReduser() throws Exception {
        File[] psw = this.cleanTokenPasswordFile();
        JobConf conf = new JobConf();
        try {
            Token token = new Token("user".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
            TokenCache.setJobToken(token, conf.getCredentials());
            File fCommand = this.getFileCommand("org.apache.hadoop.mapred.pipes.PipeReducerStub");
            conf.set("mapreduce.job.cache.local.files", fCommand.getAbsolutePath());
            PipesReducer reducer = new PipesReducer();
            reducer.configure(conf);
            BooleanWritable bw = new BooleanWritable(true);
            conf.set("mapreduce.task.attempt.id", taskName);
            this.initStdOut(conf);
            conf.setBoolean("mapreduce.job.skiprecords", true);
            CombineOutputCollector output = new CombineOutputCollector(new Counters.Counter(), new Progress());
            TestTaskReporter reporter = new TestTaskReporter();
            ArrayList<Text> texts = new ArrayList<Text>();
            texts.add(new Text("first"));
            texts.add(new Text("second"));
            texts.add(new Text("third"));
            reducer.reduce(bw, texts.iterator(), output, (Reporter)reporter);
            reducer.close();
            String stdOut = this.readStdOut(conf);
            Assert.assertTrue((boolean)stdOut.contains("reducer key :true"));
            Assert.assertTrue((boolean)stdOut.contains("reduce value  :first"));
            Assert.assertTrue((boolean)stdOut.contains("reduce value  :second"));
            Assert.assertTrue((boolean)stdOut.contains("reduce value  :third"));
        }
        finally {
            if (psw != null) {
                for (File file : psw) {
                    file.deleteOnExit();
                }
            }
        }
    }

    @Test
    public void testPipesPartitioner() {
        PipesPartitioner<IntWritable, Text> partitioner = new PipesPartitioner<IntWritable, Text>();
        JobConf configuration = new JobConf();
        Submitter.getJavaPartitioner(configuration);
        partitioner.configure(new JobConf());
        IntWritable iw = new IntWritable(4);
        Assert.assertEquals((long)0L, (long)partitioner.getPartition(iw, new Text("test"), 2));
        PipesPartitioner.setNextPartition(3);
        Assert.assertEquals((long)3L, (long)partitioner.getPartition(iw, new Text("test"), 2));
    }

    private void initStdOut(JobConf configuration) {
        TaskAttemptID taskId = TaskAttemptID.forName(configuration.get("mapreduce.task.attempt.id"));
        File stdOut = TaskLog.getTaskLogFile(taskId, false, TaskLog.LogName.STDOUT);
        File stdErr = TaskLog.getTaskLogFile(taskId, false, TaskLog.LogName.STDERR);
        if (!stdOut.getParentFile().exists()) {
            stdOut.getParentFile().mkdirs();
        } else {
            stdOut.deleteOnExit();
            stdErr.deleteOnExit();
        }
    }

    private String readStdOut(JobConf conf) throws Exception {
        TaskAttemptID taskId = TaskAttemptID.forName(conf.get("mapreduce.task.attempt.id"));
        File stdOut = TaskLog.getTaskLogFile(taskId, false, TaskLog.LogName.STDOUT);
        return this.readFile(stdOut);
    }

    private String readFile(File file) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int counter = 0;
        while ((counter = ((InputStream)is).read(buffer)) >= 0) {
            out.write(buffer, 0, counter);
        }
        ((InputStream)is).close();
        return out.toString();
    }

    private File[] cleanTokenPasswordFile() throws Exception {
        File[] result = new File[2];
        result[0] = new File("./jobTokenPassword");
        if (result[0].exists()) {
            FileUtil.chmod(result[0].getAbsolutePath(), "700");
            Assert.assertTrue((boolean)result[0].delete());
        }
        result[1] = new File("./.jobTokenPassword.crc");
        if (result[1].exists()) {
            FileUtil.chmod(result[1].getAbsolutePath(), "700");
            result[1].delete();
        }
        return result;
    }

    private File getFileCommand(String clazz) throws Exception {
        String classpath = System.getProperty("java.class.path");
        File fCommand = new File(workSpace + File.separator + "cache.sh");
        fCommand.deleteOnExit();
        if (!fCommand.getParentFile().exists()) {
            fCommand.getParentFile().mkdirs();
        }
        fCommand.createNewFile();
        FileOutputStream os = new FileOutputStream(fCommand);
        ((OutputStream)os).write("#!/bin/sh \n".getBytes());
        if (clazz == null) {
            ((OutputStream)os).write("ls ".getBytes());
        } else {
            ((OutputStream)os).write(("java -cp " + classpath + " " + clazz).getBytes());
        }
        os.flush();
        ((OutputStream)os).close();
        FileUtil.chmod(fCommand.getAbsolutePath(), "700");
        return fCommand;
    }

    private class FakeCollector
    extends CombineOutputCollector<IntWritable, Text> {
        private final Map<IntWritable, Text> collect;

        public FakeCollector(Counters.Counter outCounter, Progressable progressable) {
            super(outCounter, progressable);
            this.collect = new HashMap<IntWritable, Text>();
        }

        @Override
        public synchronized void collect(IntWritable key, Text value) throws IOException {
            this.collect.put(key, value);
            super.collect(key, value);
        }

        public Map<IntWritable, Text> getCollect() {
            return this.collect;
        }
    }

    private class ReaderPipesMapRunner
    implements RecordReader<FloatWritable, NullWritable> {
        private int index = 0;

        private ReaderPipesMapRunner() {
        }

        @Override
        public boolean next(FloatWritable key, NullWritable value) throws IOException {
            key.set(this.index++);
            return this.index <= 10;
        }

        @Override
        public float getProgress() throws IOException {
            return this.index;
        }

        @Override
        public long getPos() throws IOException {
            return this.index;
        }

        @Override
        public NullWritable createValue() {
            return NullWritable.get();
        }

        @Override
        public FloatWritable createKey() {
            FloatWritable result = new FloatWritable(this.index);
            return result;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class Reader
    implements RecordReader<FloatWritable, NullWritable> {
        private int index = 0;
        private FloatWritable progress;

        private Reader() {
        }

        @Override
        public boolean next(FloatWritable key, NullWritable value) throws IOException {
            this.progress = key;
            ++this.index;
            return this.index <= 10;
        }

        @Override
        public float getProgress() throws IOException {
            return this.progress.get();
        }

        @Override
        public long getPos() throws IOException {
            return this.index;
        }

        @Override
        public NullWritable createValue() {
            return NullWritable.get();
        }

        @Override
        public FloatWritable createKey() {
            FloatWritable result = new FloatWritable(this.index);
            return result;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class TestTaskReporter
    implements Reporter {
        private int recordNum = 0;
        private String status = null;
        private Counters counters = new Counters();
        private InputSplit split = new FakeSplit();

        private TestTaskReporter() {
        }

        @Override
        public void progress() {
            ++this.recordNum;
        }

        @Override
        public void setStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        @Override
        public Counters.Counter getCounter(String group, String name) {
            Counters.Counter counter = null;
            if (this.counters != null && (counter = this.counters.findCounter(group, name)) == null) {
                Counters.Group grp = (Counters.Group)this.counters.addGroup(group, group);
                counter = grp.addCounter(name, name, 10L);
            }
            return counter;
        }

        @Override
        public Counters.Counter getCounter(Enum<?> name) {
            return this.counters == null ? null : (Counters.Counter)this.counters.findCounter(name);
        }

        @Override
        public void incrCounter(Enum<?> key, long amount) {
            if (this.counters != null) {
                this.counters.incrCounter(key, amount);
            }
        }

        @Override
        public void incrCounter(String group, String counter, long amount) {
            if (this.counters != null) {
                this.counters.incrCounter(group, counter, amount);
            }
        }

        @Override
        public InputSplit getInputSplit() throws UnsupportedOperationException {
            return this.split;
        }

        @Override
        public float getProgress() {
            return this.recordNum;
        }
    }

    public static class FakeSplit
    implements InputSplit {
        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }
    }

    private class CombineOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private IFile.Writer<K, V> writer;
        private Counters.Counter outCounter;
        private Progressable progressable;

        public CombineOutputCollector(Counters.Counter outCounter, Progressable progressable) {
            this.outCounter = outCounter;
            this.progressable = progressable;
        }

        public synchronized void setWriter(IFile.Writer<K, V> writer) {
            this.writer = writer;
        }

        @Override
        public synchronized void collect(K key, V value) throws IOException {
            this.outCounter.increment(1L);
            this.writer.append(key, value);
            this.progressable.progress();
        }
    }

    private class Progress
    implements Progressable {
        private Progress() {
        }

        @Override
        public void progress() {
        }
    }
}

