/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class WordCountInputFormat
extends FileInputFormat<IntWritable, Text> {
    @Override
    public InputSplit[] getSplits(JobConf conf, int numSplits) throws IOException {
        ArrayList<WordCountInputSplit> result = new ArrayList<WordCountInputSplit>();
        LocalFileSystem local = FileSystem.getLocal(conf);
        for (Path dir : WordCountInputFormat.getInputPaths(conf)) {
            for (FileStatus file : ((FileSystem)local).listStatus(dir)) {
                result.add(new WordCountInputSplit(file.getPath()));
            }
        }
        return result.toArray(new InputSplit[result.size()]);
    }

    @Override
    public RecordReader<IntWritable, Text> getRecordReader(InputSplit split, JobConf conf, Reporter reporter) {
        return new RecordReader<IntWritable, Text>(){

            @Override
            public boolean next(IntWritable key, Text value) throws IOException {
                return false;
            }

            @Override
            public IntWritable createKey() {
                return new IntWritable();
            }

            @Override
            public Text createValue() {
                return new Text();
            }

            @Override
            public long getPos() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public float getProgress() {
                return 0.0f;
            }
        };
    }

    static class WordCountInputSplit
    implements InputSplit {
        private String filename;

        WordCountInputSplit() {
        }

        WordCountInputSplit(Path filename) {
            this.filename = filename.toUri().getPath();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            Text.writeString(out, this.filename);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.filename = Text.readString(in);
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }
    }
}

