/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LargeSorter
extends Configured
implements Tool {
    private static final String LS_PREFIX = "mapreduce.large-sorter.";
    public static final String MBS_PER_MAP = "mapreduce.large-sorter.mbs-per-map";
    public static final String NUM_MAP_TASKS = "mapreduce.large-sorter.map-tasks";
    public static final String NUM_REDUCE_TASKS = "mapreduce.large-sorter.reduce-tasks";
    private static final String MAX_VALUE = "mapreduce.large-sorter.max-value";
    private static final String MIN_VALUE = "mapreduce.large-sorter.min-value";
    private static final String MIN_KEY = "mapreduce.large-sorter.min-key";
    private static final String MAX_KEY = "mapreduce.large-sorter.max-key";

    private void verifyNotZero(Configuration conf, String config) {
        if (conf.getInt(config, 1) <= 0) {
            throw new IllegalArgumentException(config + "should be > 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        Path outDir = new Path(LargeSorter.class.getName() + System.currentTimeMillis());
        Configuration conf = this.getConf();
        this.verifyNotZero(conf, MBS_PER_MAP);
        this.verifyNotZero(conf, NUM_MAP_TASKS);
        conf.setInt("mapreduce.job.maps", conf.getInt(NUM_MAP_TASKS, 2));
        int ioSortMb = conf.getInt("mapreduce.task.io.sort.mb", 512);
        int mapMb = Math.max(2 * ioSortMb, conf.getInt("mapreduce.map.memory.mb", 1024));
        conf.setInt("mapreduce.map.memory.mb", mapMb);
        conf.set("mapreduce.map.java.opts", "-Xmx" + (mapMb - 200) + "m");
        Job job = new Job(conf);
        job.setJarByClass(LargeSorter.class);
        job.setJobName("large-sorter");
        FileOutputFormat.setOutputPath(job, outDir);
        job.setOutputKeyClass(BytesWritable.class);
        job.setOutputValueClass(BytesWritable.class);
        job.setInputFormatClass(RandomInputFormat.class);
        job.setMapperClass(RandomMapper.class);
        job.setReducerClass(Discarder.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setNumReduceTasks(conf.getInt(NUM_REDUCE_TASKS, 1));
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = 1;
        try {
            ret = job.waitForCompletion(true) ? 0 : 1;
        }
        finally {
            FileSystem.get(conf).delete(outDir, true);
        }
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        System.out.println("The job took " + (endTime.getTime() - startTime.getTime()) / 1000L + " seconds.");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new Configuration(), new LargeSorter(), args);
        System.exit(res);
    }

    static class Discarder
    extends Reducer<BytesWritable, BytesWritable, WritableComparable, Writable> {
        Discarder() {
        }

        @Override
        public void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        }
    }

    static class RandomMapper
    extends Mapper<WritableComparable, Writable, BytesWritable, BytesWritable> {
        private long numBytesToWrite;
        private int minKeySize;
        private int keySizeRange;
        private int minValueSize;
        private int valueSizeRange;
        private Random random = new Random();
        private BytesWritable randomKey = new BytesWritable();
        private BytesWritable randomValue = new BytesWritable();

        RandomMapper() {
        }

        private void randomizeBytes(byte[] data, int offset, int length) {
            for (int i = offset + length - 1; i >= offset; --i) {
                data[i] = (byte)this.random.nextInt(256);
            }
        }

        @Override
        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.numBytesToWrite = 0x100000L * conf.getLong(LargeSorter.MBS_PER_MAP, 2 * conf.getInt("mapreduce.task.io.sort.mb", 512));
            this.minKeySize = conf.getInt(LargeSorter.MIN_KEY, 10);
            this.keySizeRange = conf.getInt(LargeSorter.MAX_KEY, 1000) - this.minKeySize;
            this.minValueSize = conf.getInt(LargeSorter.MIN_VALUE, 0);
            this.valueSizeRange = conf.getInt(LargeSorter.MAX_VALUE, 20000) - this.minValueSize;
        }

        @Override
        public void map(WritableComparable key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
            int itemCount = 0;
            while (this.numBytesToWrite > 0L) {
                int keyLength = this.minKeySize + (this.keySizeRange != 0 ? this.random.nextInt(this.keySizeRange) : 0);
                this.randomKey.setSize(keyLength);
                this.randomizeBytes(this.randomKey.getBytes(), 0, this.randomKey.getLength());
                int valueLength = this.minValueSize + (this.valueSizeRange != 0 ? this.random.nextInt(this.valueSizeRange) : 0);
                this.randomValue.setSize(valueLength);
                this.randomizeBytes(this.randomValue.getBytes(), 0, this.randomValue.getLength());
                context.write(this.randomKey, this.randomValue);
                this.numBytesToWrite -= (long)(keyLength + valueLength);
                context.getCounter(Counters.BYTES_WRITTEN).increment(keyLength + valueLength);
                context.getCounter(Counters.RECORDS_WRITTEN).increment(1L);
                if (++itemCount % 200 != 0) continue;
                context.setStatus("wrote record " + itemCount + ". " + this.numBytesToWrite + " bytes left.");
            }
            context.setStatus("done with " + itemCount + " records.");
        }
    }

    static class RandomInputFormat
    extends InputFormat<Text, Text> {
        RandomInputFormat() {
        }

        @Override
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> result = new ArrayList<InputSplit>();
            Path outDir = FileOutputFormat.getOutputPath(job);
            int numSplits = job.getConfiguration().getInt("mapreduce.job.maps", 1);
            for (int i = 0; i < numSplits; ++i) {
                result.add(new FileSplit(new Path(outDir, "dummy-split-" + i), 0L, 1L, null));
            }
            return result;
        }

        @Override
        public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            return new RandomRecordReader(((FileSplit)split).getPath());
        }

        static class RandomRecordReader
        extends RecordReader<Text, Text> {
            Path name;
            Text key = null;
            Text value = new Text();

            public RandomRecordReader(Path p) {
                this.name = p;
            }

            @Override
            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            }

            @Override
            public boolean nextKeyValue() {
                if (this.name != null) {
                    this.key = new Text();
                    this.key.set(this.name.getName());
                    this.name = null;
                    return true;
                }
                return false;
            }

            @Override
            public Text getCurrentKey() {
                return this.key;
            }

            @Override
            public Text getCurrentValue() {
                return this.value;
            }

            @Override
            public void close() {
            }

            @Override
            public float getProgress() {
                return 0.0f;
            }
        }
    }

    static enum Counters {
        RECORDS_WRITTEN,
        BYTES_WRITTEN;

    }
}

