/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.ReflectionUtils;

public class MapReduceTestUtil {
    public static final Log LOG = LogFactory.getLog((String)MapReduceTestUtil.class.getName());
    private static Random rand = new Random();
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public static void cleanData(FileSystem fs, Path dirPath) throws IOException {
        fs.delete(dirPath, true);
    }

    public static String generateRandomWord() {
        return idFormat.format(rand.nextLong());
    }

    public static String generateRandomLine() {
        long r = rand.nextLong() % 7L;
        long n = r + 20L;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < n) {
            sb.append(MapReduceTestUtil.generateRandomWord()).append(" ");
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static void generateData(FileSystem fs, Path dirPath) throws IOException {
        FSDataOutputStream out = fs.create(new Path(dirPath, "data.txt"));
        for (int i = 0; i < 10000; ++i) {
            String line = MapReduceTestUtil.generateRandomLine();
            out.write(line.getBytes("UTF-8"));
        }
        out.close();
    }

    public static Job createCopyJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        conf.setInt("mapreduce.job.maps", 3);
        Job theJob = Job.getInstance(conf);
        theJob.setJobName("DataMoveJob");
        FileInputFormat.setInputPaths(theJob, indirs);
        theJob.setMapperClass(DataCopyMapper.class);
        FileOutputFormat.setOutputPath(theJob, outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(DataCopyReducer.class);
        theJob.setNumReduceTasks(1);
        return theJob;
    }

    public static Job createFailJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        FileSystem fs = outdir.getFileSystem(conf);
        if (fs.exists(outdir)) {
            fs.delete(outdir, true);
        }
        conf.setInt("mapreduce.map.maxattempts", 2);
        Job theJob = Job.getInstance(conf);
        theJob.setJobName("Fail-Job");
        FileInputFormat.setInputPaths(theJob, indirs);
        theJob.setMapperClass(FailMapper.class);
        theJob.setReducerClass(Reducer.class);
        theJob.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath(theJob, outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        return theJob;
    }

    public static Job createKillJob(Configuration conf, Path outdir, Path ... indirs) throws Exception {
        Job theJob = Job.getInstance(conf);
        theJob.setJobName("Kill-Job");
        FileInputFormat.setInputPaths(theJob, indirs);
        theJob.setMapperClass(KillMapper.class);
        theJob.setReducerClass(Reducer.class);
        theJob.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath(theJob, outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        return theJob;
    }

    public static Job createJob(Configuration conf, Path inDir, Path outDir, int numInputFiles, int numReds) throws IOException {
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        return MapReduceTestUtil.createJob(conf, inDir, outDir, numInputFiles, numReds, input);
    }

    public static Job createJob(Configuration conf, Path inDir, Path outDir, int numInputFiles, int numReds, String input) throws IOException {
        Job job = Job.getInstance(conf);
        FileSystem fs = FileSystem.get(conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (fs.exists(inDir)) {
            fs.delete(inDir, true);
        }
        fs.mkdirs(inDir);
        for (int i = 0; i < numInputFiles; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            ((FilterOutputStream)file).close();
        }
        FileInputFormat.setInputPaths(job, inDir);
        FileOutputFormat.setOutputPath(job, outDir);
        job.setNumReduceTasks(numReds);
        return job;
    }

    public static TaskAttemptContext createDummyMapTaskAttemptContext(Configuration conf) {
        org.apache.hadoop.mapreduce.TaskAttemptID tid = new org.apache.hadoop.mapreduce.TaskAttemptID("jt", 1, TaskType.MAP, 0, 0);
        conf.set("mapreduce.task.attempt.id", tid.toString());
        return new TaskAttemptContextImpl(conf, tid);
    }

    public static StatusReporter createDummyReporter() {
        return new StatusReporter(){

            @Override
            public void setStatus(String s) {
            }

            @Override
            public void progress() {
            }

            @Override
            public float getProgress() {
                return 0.0f;
            }

            @Override
            public Counter getCounter(Enum<?> name) {
                return new Counters().findCounter(name);
            }

            @Override
            public Counter getCounter(String group, String name) {
                return new Counters().findCounter(group, name);
            }
        };
    }

    public static String readOutput(Path outDir, Configuration conf) throws IOException {
        Path[] fileList;
        FileSystem fs = outDir.getFileSystem(conf);
        StringBuffer result = new StringBuffer();
        for (Path outputFile : fileList = FileUtil.stat2Paths(fs.listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()))) {
            LOG.info((Object)("Path: " + outputFile));
            BufferedReader file = new BufferedReader(new InputStreamReader(fs.open(outputFile)));
            String line = file.readLine();
            while (line != null) {
                result.append(line);
                result.append("\n");
                line = file.readLine();
            }
            file.close();
        }
        return result.toString();
    }

    public static String readTaskLog(TaskLog.LogName filter, TaskAttemptID taskId, boolean isCleanup) throws IOException {
        int res;
        StringBuffer result = new StringBuffer();
        TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter, 0L, -1L, isCleanup);
        byte[] b = new byte[65536];
        while ((res = taskLogReader.read(b)) > 0) {
            result.append(new String(b));
        }
        ((InputStream)taskLogReader).close();
        String str = result.toString();
        str = str.trim();
        return str;
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }

    public static class Fake_RR<K, V>
    extends RecordReader<K, V> {
        private Class<? extends K> keyclass;
        private Class<? extends V> valclass;

        @Override
        public boolean nextKeyValue() throws IOException {
            return false;
        }

        @Override
        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            this.keyclass = conf.getClass("test.fakeif.keyclass", NullWritable.class, WritableComparable.class);
            this.valclass = conf.getClass("test.fakeif.valclass", NullWritable.class, WritableComparable.class);
        }

        @Override
        public K getCurrentKey() {
            return ReflectionUtils.newInstance(this.keyclass, null);
        }

        @Override
        public V getCurrentValue() {
            return ReflectionUtils.newInstance(this.valclass, null);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException {
            return 0.0f;
        }
    }

    public static class Fake_IF<K, V>
    extends InputFormat<K, V>
    implements Configurable {
        protected Class<? extends K> keyclass;
        protected Class<? extends V> valclass;
        Configuration conf = null;

        @Override
        public List<InputSplit> getSplits(JobContext context) {
            ArrayList<InputSplit> ret = new ArrayList<InputSplit>();
            ret.add(new FakeSplit());
            return ret;
        }

        public static void setKeyClass(Configuration conf, Class<?> k) {
            conf.setClass("test.fakeif.keyclass", k, WritableComparable.class);
        }

        public static void setValClass(Configuration job, Class<?> v) {
            job.setClass("test.fakeif.valclass", v, Writable.class);
        }

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf;
            this.keyclass = conf.getClass("test.fakeif.keyclass", NullWritable.class, WritableComparable.class);
            this.valclass = conf.getClass("test.fakeif.valclass", NullWritable.class, WritableComparable.class);
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public RecordReader<K, V> createRecordReader(InputSplit ignored, TaskAttemptContext context) {
            return new RecordReader<K, V>(){

                @Override
                public boolean nextKeyValue() throws IOException {
                    return false;
                }

                @Override
                public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                }

                @Override
                public K getCurrentKey() {
                    return null;
                }

                @Override
                public V getCurrentValue() {
                    return null;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public float getProgress() throws IOException {
                    return 0.0f;
                }
            };
        }
    }

    public static class FakeSplit
    extends InputSplit
    implements Writable {
        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }
    }

    public static class IncomparableKey
    implements WritableComparable<Object> {
        @Override
        public void write(DataOutput out) {
        }

        @Override
        public void readFields(DataInput in) {
        }

        @Override
        public int compareTo(Object o) {
            throw new RuntimeException("Should never see this.");
        }
    }

    public static class KillMapper
    extends Mapper<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        @Override
        public void map(WritableComparable<?> key, Writable value, Mapper.Context context) throws IOException {
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static class FailMapper
    extends Mapper<WritableComparable<?>, Writable, WritableComparable<?>, Writable> {
        @Override
        public void map(WritableComparable<?> key, Writable value, Mapper.Context context) throws IOException {
            throw new RuntimeException("failing map");
        }
    }

    public static class DataCopyReducer
    extends Reducer<Text, Text, Text, Text> {
        @Override
        public void reduce(Text key, Iterator<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            Text dumbKey = new Text("");
            while (values.hasNext()) {
                Text data = values.next();
                context.write(dumbKey, data);
            }
        }
    }

    public static class DataCopyMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        @Override
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(new Text(key.toString()), value);
        }
    }
}

