/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMapCollection {
    private static final Log LOG = LogFactory.getLog((String)TestMapCollection.class.getName());

    private static void runTest(String name, int keylen, int vallen, int records, int ioSortMB, float spillPer) throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance(conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", ioSortMB);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(spillPer));
        conf.setClass("test.mapcollection.class", FixedRecordFactory.class, RecordFactory.class);
        FixedRecordFactory.setLengths(conf, keylen, vallen);
        conf.setInt("test.spillmap.records", records);
        TestMapCollection.runTest(name, job);
    }

    private static void runTest(String name, Job job) throws Exception {
        job.setNumReduceTasks(1);
        job.getConfiguration().set("mapreduce.framework.name", "local");
        job.getConfiguration().setInt("mapreduce.task.io.sort.factor", 1000);
        job.getConfiguration().set("fs.defaultFS", "file:///");
        job.getConfiguration().setInt("test.mapcollection.num.maps", 1);
        job.setInputFormatClass(FakeIF.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapperClass(Mapper.class);
        job.setReducerClass(SpillReducer.class);
        job.setMapOutputKeyClass(KeyWritable.class);
        job.setMapOutputValueClass(ValWritable.class);
        job.setSortComparatorClass(VariableComparator.class);
        LOG.info((Object)("Running " + name));
        Assert.assertTrue((String)"Job failed!", (boolean)job.waitForCompletion(false));
    }

    @Test
    public void testValLastByte() throws Exception {
        TestMapCollection.runTest("vallastbyte", 128, 896, 1344, 1, 0.5f);
        TestMapCollection.runTest("keylastbyte", 512, 1024, 896, 1, 0.5f);
    }

    @Test
    public void testLargeRecords() throws Exception {
        TestMapCollection.runTest("largerec", 100, 0x100000, 5, 1, 0.8f);
        TestMapCollection.runTest("largekeyzeroval", 0x100000, 0, 5, 1, 0.8f);
    }

    @Test
    public void testSpillPer2B() throws Exception {
        TestMapCollection.runTest("fullspill2B", 1, 1, 10000, 1, 1.0f);
        TestMapCollection.runTest("fullspill200B", 100, 100, 10000, 1, 1.0f);
        TestMapCollection.runTest("fullspillbuf", 10240, 20480, 256, 1, 1.0f);
        TestMapCollection.runTest("lt50perspill", 100, 100, 10000, 1, 0.3f);
    }

    @Test
    public void testZeroVal() throws Exception {
        TestMapCollection.runTest("zeroval", 1, 0, 10000, 1, 0.8f);
        TestMapCollection.runTest("zerokey", 0, 1, 10000, 1, 0.8f);
        TestMapCollection.runTest("zerokeyval", 0, 0, 10000, 1, 0.8f);
        TestMapCollection.runTest("zerokeyvalfull", 0, 0, 10000, 1, 1.0f);
    }

    @Test
    public void testSingleRecord() throws Exception {
        TestMapCollection.runTest("singlerecord", 100, 100, 1, 1, 1.0f);
        TestMapCollection.runTest("zerokeyvalsingle", 0, 0, 1, 1, 1.0f);
    }

    @Test
    public void testLowSpill() throws Exception {
        TestMapCollection.runTest("lowspill", 4000, 96, 20, 1, 0.00390625f);
    }

    @Test
    public void testSplitMetaSpill() throws Exception {
        TestMapCollection.runTest("splitmetaspill", 7, 1, 131072, 1, 0.8f);
    }

    @Test
    public void testPostSpillMeta() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance(conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(0.9863281f));
        conf.setClass("test.mapcollection.class", StepFactory.class, RecordFactory.class);
        StepFactory.setLengths(conf, 4000, 0, 96, 0, 252);
        conf.setInt("test.spillmap.records", 1000);
        conf.setBoolean("test.disable.key.read", true);
        conf.setBoolean("test.disable.val.read", true);
        TestMapCollection.runTest("postspillmeta", job);
    }

    @Test
    public void testLargeRecConcurrent() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance(conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(0.9863281f));
        conf.setClass("test.mapcollection.class", StepFactory.class, RecordFactory.class);
        StepFactory.setLengths(conf, 4000, 261120, 96, 1024, 251);
        conf.setInt("test.spillmap.records", 255);
        conf.setBoolean("test.disable.key.read", false);
        conf.setBoolean("test.disable.val.read", false);
        TestMapCollection.runTest("largeconcurrent", job);
    }

    @Test
    public void testRandom() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance(conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.setClass("test.mapcollection.class", RandomFactory.class, RecordFactory.class);
        Random r = new Random();
        long seed = r.nextLong();
        LOG.info((Object)("SEED: " + seed));
        r.setSeed(seed);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(Math.max(0.1f, r.nextFloat())));
        RandomFactory.setLengths(conf, r, 16384);
        conf.setInt("test.spillmap.records", r.nextInt(500));
        conf.setLong("test.randomfactory.seed", r.nextLong());
        TestMapCollection.runTest("random", job);
    }

    @Test
    public void testRandomCompress() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.client.completion.pollinterval", 100);
        Job job = Job.getInstance(conf);
        conf = job.getConfiguration();
        conf.setInt("mapreduce.task.io.sort.mb", 1);
        conf.setBoolean("mapreduce.map.output.compress", true);
        conf.setClass("test.mapcollection.class", RandomFactory.class, RecordFactory.class);
        Random r = new Random();
        long seed = r.nextLong();
        LOG.info((Object)("SEED: " + seed));
        r.setSeed(seed);
        conf.set("mapreduce.map.sort.spill.percent", Float.toString(Math.max(0.1f, r.nextFloat())));
        RandomFactory.setLengths(conf, r, 16384);
        conf.setInt("test.spillmap.records", r.nextInt(500));
        conf.setLong("test.randomfactory.seed", r.nextLong());
        TestMapCollection.runTest("randomCompress", job);
    }

    public static class RandomFactory
    extends RecordFactory {
        public int minkey;
        public int maxkey;
        public int minval;
        public int maxval;
        private final Random r = new Random();

        private static int nextRand(Random r, int max) {
            return (int)Math.exp(r.nextDouble() * Math.log(max));
        }

        @Override
        public void setConf(Configuration conf) {
            this.r.setSeed(conf.getLong("test.randomfactory.seed", 0L));
            this.minkey = conf.getInt("test.randomfactory.minkey", 0);
            this.maxkey = conf.getInt("test.randomfactory.maxkey", 0) - this.minkey;
            this.minval = conf.getInt("test.randomfactory.minval", 0);
            this.maxval = conf.getInt("test.randomfactory.maxval", 0) - this.minval;
        }

        public static void setLengths(Configuration conf, Random r, int max) {
            int v2;
            int v1;
            int k2;
            int k1 = RandomFactory.nextRand(r, max);
            if (k1 > (k2 = RandomFactory.nextRand(r, max))) {
                int tmp = k1;
                k2 = k1 = k2;
            }
            if ((v1 = RandomFactory.nextRand(r, max)) > (v2 = RandomFactory.nextRand(r, max))) {
                int tmp = v1;
                v2 = v1 = v2;
            }
            RandomFactory.setLengths(conf, k1, ++k2, v1, ++v2);
        }

        public static void setLengths(Configuration conf, int minkey, int maxkey, int minval, int maxval) {
            assert (minkey < maxkey);
            assert (minval < maxval);
            conf.setInt("test.randomfactory.minkey", minkey);
            conf.setInt("test.randomfactory.maxkey", maxkey);
            conf.setInt("test.randomfactory.minval", minval);
            conf.setInt("test.randomfactory.maxval", maxval);
            conf.setBoolean("test.disable.key.read", minkey == 0);
            conf.setBoolean("test.disable.val.read", minval == 0);
        }

        @Override
        public int keyLen(int i) {
            return this.minkey + RandomFactory.nextRand(this.r, this.maxkey - this.minkey);
        }

        @Override
        public int valLen(int i) {
            return this.minval + RandomFactory.nextRand(this.r, this.maxval - this.minval);
        }
    }

    public static class StepFactory
    extends RecordFactory {
        public int prekey;
        public int postkey;
        public int preval;
        public int postval;
        public int steprec;

        @Override
        public void setConf(Configuration conf) {
            this.prekey = conf.getInt("test.stepfactory.prekey", 0);
            this.postkey = conf.getInt("test.stepfactory.postkey", 0);
            this.preval = conf.getInt("test.stepfactory.preval", 0);
            this.postval = conf.getInt("test.stepfactory.postval", 0);
            this.steprec = conf.getInt("test.stepfactory.steprec", 0);
        }

        public static void setLengths(Configuration conf, int prekey, int postkey, int preval, int postval, int steprec) {
            conf.setInt("test.stepfactory.prekey", prekey);
            conf.setInt("test.stepfactory.postkey", postkey);
            conf.setInt("test.stepfactory.preval", preval);
            conf.setInt("test.stepfactory.postval", postval);
            conf.setInt("test.stepfactory.steprec", steprec);
        }

        @Override
        public int keyLen(int i) {
            return i > this.steprec ? this.postkey : this.prekey;
        }

        @Override
        public int valLen(int i) {
            return i > this.steprec ? this.postval : this.preval;
        }
    }

    public static class FakeIF
    extends InputFormat<KeyWritable, ValWritable> {
        @Override
        public List<InputSplit> getSplits(JobContext ctxt) throws IOException {
            int numSplits = ctxt.getConfiguration().getInt("test.mapcollection.num.maps", -1);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numSplits);
            for (int i = 0; i < numSplits; ++i) {
                splits.add(i, new FakeSplit());
            }
            return splits;
        }

        @Override
        public RecordReader<KeyWritable, ValWritable> createRecordReader(InputSplit ignored, TaskAttemptContext taskContext) {
            return new RecordReader<KeyWritable, ValWritable>(){
                private RecordFactory factory;
                private final KeyWritable key = new KeyWritable();
                private final ValWritable val = new ValWritable();
                private int current;
                private int records;

                @Override
                public void initialize(InputSplit split, TaskAttemptContext context) {
                    Configuration conf = context.getConfiguration();
                    this.key.setConf(conf);
                    this.val.setConf(conf);
                    this.factory = ReflectionUtils.newInstance(conf.getClass("test.mapcollection.class", FixedRecordFactory.class, RecordFactory.class), conf);
                    Assert.assertNotNull((Object)this.factory);
                    this.current = 0;
                    this.records = conf.getInt("test.spillmap.records", 100);
                }

                @Override
                public boolean nextKeyValue() {
                    this.key.setLength(this.factory.keyLen(this.current));
                    this.val.setLength(this.factory.valLen(this.current));
                    return this.current++ < this.records;
                }

                @Override
                public KeyWritable getCurrentKey() {
                    return this.key;
                }

                @Override
                public ValWritable getCurrentValue() {
                    return this.val;
                }

                @Override
                public float getProgress() {
                    return (float)this.current / (float)this.records;
                }

                @Override
                public void close() {
                    Assert.assertEquals((String)"Unexpected count", (long)this.records, (long)(this.current - 1));
                }
            };
        }
    }

    public static class FixedRecordFactory
    extends RecordFactory {
        private int keylen;
        private int vallen;

        @Override
        public void setConf(Configuration conf) {
            this.keylen = conf.getInt("test.fixedrecord.keylen", 0);
            this.vallen = conf.getInt("test.fixedrecord.vallen", 0);
        }

        @Override
        public int keyLen(int i) {
            return this.keylen;
        }

        @Override
        public int valLen(int i) {
            return this.vallen;
        }

        public static void setLengths(Configuration conf, int keylen, int vallen) {
            conf.setInt("test.fixedrecord.keylen", keylen);
            conf.setInt("test.fixedrecord.vallen", vallen);
            conf.setBoolean("test.disable.key.read", 0 == keylen);
            conf.setBoolean("test.disable.val.read", 0 == vallen);
        }
    }

    public static abstract class RecordFactory
    implements Configurable {
        @Override
        public Configuration getConf() {
            return null;
        }

        public abstract int keyLen(int var1);

        public abstract int valLen(int var1);
    }

    public static class FakeSplit
    extends InputSplit
    implements Writable {
        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public long getLength() {
            return 0L;
        }

        @Override
        public String[] getLocations() {
            return new String[0];
        }
    }

    public static class SpillReducer
    extends Reducer<KeyWritable, ValWritable, NullWritable, NullWritable> {
        private int numrecs;
        private int expected;

        @Override
        protected void setup(Reducer.Context job) {
            this.numrecs = 0;
            this.expected = job.getConfiguration().getInt("test.spillmap.records", 100);
        }

        @Override
        protected void reduce(KeyWritable k, Iterable<ValWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            for (ValWritable val : values) {
                ++this.numrecs;
            }
        }

        @Override
        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Assert.assertEquals((String)"Unexpected record count", (long)this.expected, (long)this.numrecs);
        }
    }

    public static class VariableComparator
    implements RawComparator<KeyWritable>,
    Configurable {
        private boolean readLen;

        @Override
        public void setConf(Configuration conf) {
            this.readLen = !conf.getBoolean("test.disable.key.read", false);
        }

        @Override
        public Configuration getConf() {
            return null;
        }

        @Override
        public int compare(KeyWritable k1, KeyWritable k2) {
            return k1.compareTo(k2);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int i;
            int n2;
            int n1;
            if (this.readLen) {
                n1 = WritableUtils.decodeVIntSize(b1[s1]);
                n2 = WritableUtils.decodeVIntSize(b2[s2]);
            } else {
                n1 = 0;
                n2 = 0;
            }
            for (i = s1 + n1; i < l1 - n1; ++i) {
                Assert.assertEquals((String)("Invalid key at " + s1), (long)75L, (long)b1[i]);
            }
            for (i = s2 + n2; i < l2 - n2; ++i) {
                Assert.assertEquals((String)("Invalid key at " + s2), (long)75L, (long)b2[i]);
            }
            return l1 - l2;
        }
    }

    public static class ValWritable
    extends FillWritable {
        public ValWritable() {
            super((byte)86);
        }

        @Override
        public void setConf(Configuration conf) {
            this.disableRead = conf.getBoolean("test.disable.val.read", false);
        }
    }

    public static class KeyWritable
    extends FillWritable
    implements WritableComparable<FillWritable> {
        static final byte keyFill = 75;

        public KeyWritable() {
            super((byte)75);
        }

        @Override
        public void setConf(Configuration conf) {
            this.disableRead = conf.getBoolean("test.disable.key.read", false);
        }
    }

    public static abstract class FillWritable
    implements Writable,
    Configurable {
        private int len;
        protected boolean disableRead;
        private byte[] b;
        private final Random r;
        protected final byte fillChar;

        public FillWritable(byte fillChar) {
            this.fillChar = fillChar;
            this.r = new Random();
            long seed = this.r.nextLong();
            LOG.info((Object)("seed: " + seed));
            this.r.setSeed(seed);
        }

        @Override
        public Configuration getConf() {
            return null;
        }

        public void setLength(int len) {
            this.len = len;
        }

        public int compareTo(FillWritable o) {
            if (o == this) {
                return 0;
            }
            return this.len - o.len;
        }

        public int hashCode() {
            return 37 * this.len;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FillWritable)) {
                return false;
            }
            return 0 == this.compareTo((FillWritable)o);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            if (this.disableRead) {
                return;
            }
            this.len = WritableUtils.readVInt(in);
            for (int i = 0; i < this.len; ++i) {
                Assert.assertEquals((String)("Invalid byte at " + i), (long)this.fillChar, (long)in.readByte());
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (0 == this.len) {
                return;
            }
            int written = 0;
            if (!this.disableRead) {
                WritableUtils.writeVInt(out, this.len);
                written -= WritableUtils.getVIntSize(this.len);
            }
            if (this.len > 1024) {
                int write;
                if (null == this.b || this.b.length < this.len) {
                    this.b = new byte[2 * this.len];
                }
                Arrays.fill(this.b, this.fillChar);
                do {
                    write = Math.min(this.len - written, this.r.nextInt(this.len));
                    out.write(this.b, 0, write);
                } while ((written += write) < this.len);
                Assert.assertEquals((long)this.len, (long)written);
            } else {
                for (int i = written; i < this.len; ++i) {
                    out.write(this.fillChar);
                }
            }
        }
    }
}

